#include "asm.h"
/*		Copyright 1976 by Bill Webb. 		*/

char *types[]
{"undefined","equated","label"};
getsym(name)
char *name;
{
register int c;
register char *n;

n = name;
c = *ptr++;
if(ALPHA)
	*n++ = c;
else
	error("invalid symbol");
while ((c = *ptr++) && ALPHANUM)
	if(n < name+SYMLEN)
		*n++ = c;
while (n < name+SYMLEN)
	*n++ = 0;
--ptr;
}

lookup(name)
char *name;
{
register struct symbol *s;
register int i;

i = hash(name) % MAXSYMHASH;
while (s = symhash[i])
	{
	if(symeq(name,s->s_name))
		return(s);
	if (++i >= MAXSYMHASH)
		i = 0;
	}
s = lastsym;
if(s >= symbols+MAXSYM)
	err("symbol table overflow");
symhash[i] = s;
++lastsym;
cpsym(s->s_name,name);
if(s->s_type == UNDEF && passnum > 1)
	warn("%s undefined",s->s_name);
return(s);
}

dump()
{
register struct symbol *s;
register int i;
register int c;
char addrbuff[6];
int symcmp();

qsort(&symbols,lastsym - &symbols,sizeof symbols[0],&symcmp);
i = 0;
printf("\n\nSymbol Table\n\n");
for (ALLSYMS)
	{
	outcvt(addrbuff,4,s->s_value,16);
	c = s->s_type == LABEL ? ' ': '=';
	printf("%-6.6s%c %s",s->s_name,c,addrbuff);
	if((++i & 03) == 0)
		putchar('\n');
	else
		putchar('\t');
	}
if(i & 03)
	putchar('\n');
}


cpsym(s1,s2)
char *s1, *s2;
{
register int i;

for (i=0; i<SYMLEN; ++i)
	if(*s1++ = *s2)
		++s2;
}

symeq(s1,s2)
char *s1, *s2;
{
register int i;
register char *p1;
register char *p2;

p1 = s1;
p2 = s2;
for (i=0; i<SYMLEN; ++i)
	{
	if(*p1 != *p2++)
		return(0);
	if(*p1++ == 0)
		break;
	}
return(1);
}


symcmp(s1,s2) struct symbol *s1, *s2;
{
register char *p1, *p2;
register int c;
int i;

p1 = s1->s_name;
p2 = s2->s_name;
for (i=0; i<SYMLEN; ++i)
	if(c = *p1++ - *p2++)
		break;
return(c);
}
