#include "asm.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define	L	+ 0400		/* long option */
#define	LIMM	01000		/* long immediate operand */

#define	EQU	0
#define	DUAL	1
#define	MEM	3 + LIMM
#define	OPR	2
#define	CTL	4
#define	SGL	5
#define	ACC	6
#define	BR	7
#define	JMP	8
#define	ARG	9 L
#define	STA	10
#define	STX	11

struct opcode opcodes[]
{

"aba",	OPR,	033,
"adc",	DUAL,	0211,
"add",	DUAL,	0213,
"and",	DUAL,	0204,
"asl",	ARG,	0110,
"asr",	ARG,	0107,
"bcc",	BR,	044,
"bcs",	BR,	045,
"beq",	BR,	047,
"bge",	BR,	054,
"bgt",	BR,	056,
"bhi",	BR,	042,
"bit",	DUAL,	0205,
"ble",	BR,	057,
"bls",	BR,	043,
"blt",	BR,	055,
"bmi",	BR,	053,
"bne",	BR,	046,
"bpl",	BR,	052,
"bra",	BR,	040,
"bsr",	BR,	0215,
"bvc",	BR,	050,
"bvs",	BR,	051,
"cba",	OPR,	021,
"clc",	OPR,	014,
"cli",	OPR,	016,
"clr",	ARG,	0117,
"clv",	OPR,	012,
"cmp",	DUAL,	0201,
"com",	ARG,	0103,
"cpx",	MEM,	0214,
"cra",	OPR,	021,
"daa",	OPR,	031,
"dec",	ARG,	0112,
"des",	OPR,	064,
"dex",	OPR,	011,
"end",	CTL,	0,
"eor",	DUAL,	0210,
"equ",	EQU,	0,
"fcb",	CTL,	2,
"fcc",	CTL,	4,
"fdb",	CTL,	5,
"inc",	ARG,	0114,
"ins",	OPR,	061,
"inx",	OPR,	010,
"jmp",	JMP,	0156,
"jsr",	JMP,	0255,
"lda",	DUAL,	0206,
"lds",	MEM,	0216,
"ldx",	MEM,	0316,
"lsr",	ARG,	0104,
"neg",	ARG,	0100,
"nop",	OPR,	01,
"ora",	DUAL,	0212,
"org",	CTL,	1,
"psh",	ACC,	066,
"pul",	ACC,	062,
"rmb",	CTL,	3,
"rol",	ARG,	0111,
"ror",	ARG,	0106,
"rti",	OPR,	073,
"rts",	OPR,	071,
"sba",	OPR,	020,
"sbc",	DUAL,	0202,
"sec",	OPR,	015,
"sei",	OPR,	017,
"sev",	OPR,	013,
"sta",	STA,	0227,
"sts",	STX,	0237,
"stx",	STX,	0337,
"sub",	DUAL,	0200,
"swi",	OPR,	077,
"tab",	OPR,	026,
"tap",	OPR,	06,
"tba",	OPR,	027,
"tpa",	OPR,	07,
"tst",	ARG,	0115,
"tsx",	OPR,	060,
"txs",	OPR,	065,
"wai",	OPR,	076,
0,	0,	0
};
