#
/*		Copyright 1976 by Bill Webb. 		*/

#define	SYMLEN	6		/* number of chars/symbol */
#define	MAXSYM	512
#define	MAXSYMHASH (MAXSYM * 13 / 10 - 2)

struct symbol
{
char s_name[SYMLEN];
char *s_value;
int s_type;
} symbols[MAXSYM];
#define	ALLSYMS s=symbols; s<lastsym; ++s

struct { char lo, hi; };

struct opcode
{
char *o_name;
char o_type;
char o_flags;
#define		LONG	01		/* must be EXT addressing */
int o_code;
} opcodes[];

#define	MAXOPHASH	323
struct opcode *ophash[MAXOPHASH];
struct symbol *symhash[MAXSYMHASH];

int (*oprtns[])();



char *ptr;		/* input line pointer */
int errcnt;		/* number of errors so far */
char *curpc;		/* current pc value */
char *dot;		/* current start of instruction */
char *maxdot;		/* maximum dot used */
int passnum;		/* current pass number */
int linecnt;		/* number of lines read */
int opcode;		/* current operation code */
int gotend;		/* have processed end stmt */
struct opcode *op;	/* pointer to current op code entry */
#define	EVER	;;
#define	TAB	'\t'
#define	ALLOPS	o=opcodes; o->o_name; ++o
char opname[SYMLEN];
char sym[SYMLEN];
char label[SYMLEN];

#define	UNDEF	0
#define	LABEL	2
#define	EXPR	1

#define	AREG	0
#define	BREG	1
#define	IMM	0
#define	DIR	020
#define	EXT	060
#define	IND	040

#define	ALPHA	(c >= 'a' && c <= 'z')
#define	DIGIT	(c >= '0' && c <= '9')
#define	ALPHANUM	(ALPHA || DIGIT)

#define	MAXLINE	132

char line[MAXLINE];	/* input line buffer */
struct symbol *lastsym;
int base;		/* numeric conversion base */
char outbuff[20];
char *outptr;
int again;		/* 0 if another pass not needed */
int lastpass;		/* 0 until last pass is made */
int exprtype;		/* 0 unless undefined variable in expr */
int tflg;	/* debugging flag */
int sflg, lflg;
int oflg;	/* produce object */
int gflg;	/* generate 1 line of printout */
int uflg;	/* fold lower to upper in strings */
int lastcnt;		/* previous line number */
int noprint;		/* inhibit print as already done. */
int chksum;		/* checksum for object */
int objlen;		/* number of bytes of object */
int objaddr;		/* object code start address */
#define	MAXOBJ	70/2-5
char objbuff[MAXOBJ];	/* buffer for object bytes */
extern fout;
