#include <stdio.h>
/*			Copyright 1982 by Bill Webb.	 		*/
#include "data.h"
long int ftell();

mkindex(datafile,indexfile)
register FILE *datafile;
FILE *indexfile;
{
	register int c;
	register int lastc;
	long int prev=0, lastchar=(-1);
	char *bad_fwrite="bad fwrite";
	long len = 0;
	
	nrecs=0;
	tracef(("addr datafile=%o \tindexfile=%o\n", datafile,indexfile));

		/* write a dummy lineno at posn 0 in index file */
	if(!(fwrite((char *)&prev, sizeof(long int), 1, indexfile)))
		err(bad_fwrite);

	for (lastc = fs; (c=getc(datafile)) != EOF; lastc = c) {
		if (c == recsep && (!aflg || lastc == fs))
			{
			if(!(fwrite((char *)&prev, sizeof(long int), 1, indexfile)))
				err(bad_fwrite);
			prev = ftell(datafile);
			nrecs++;		/* count number of records */
			if (len >= bufsiz)
				printf("Record %D, length %D > maximum (%d)\n",nrecs,len,bufsiz);
			len = 0;
		}
	++len;
	}
	if (len >= bufsiz)
		printf("Record %D, length %D > maximum (%d)\n",nrecs,len,bufsiz);

	prstats("");

	fseek(datafile,lastchar,2);	/* seek last char in file */
	if(getc(datafile) != recsep)	/* read last char,chk recsep presence */
		printf(" [Incomplete last record]");
	printf("\n");
	/* re-write the line count */
	fseek(indexfile,0L,0);
	fwrite((char *)&nrecs, sizeof(long int), 1, indexfile);
	fflush(indexfile);
	cre_modfile = true;		/* make new modfile */
}

rdindex(datafile,indexfile)
register FILE *datafile;
FILE *indexfile;
{
if (fread((char *)&nrecs,sizeof nrecs,1,indexfile) != 1)
	err("bad index file for %s",datafname);
if (nrecs < 0)
	{
	nrecs = -nrecs;
	modflag++;
	}
prstats("\n");
}

long filesize(file) FILE *file;
{
fseek(datafile,0L,2);
return(ftell(datafile));
}

prstats(str) char *str;
{

	prfile();
	printf(" %ld records, %ld characters.", nrecs, filesize(datafile));
	printf("%s",str);
}

prfile()
{
	printf("\"%s\"", datafname);
	if (modflag)
		printf(" [modified]");
	if (updated)
		printf(" [updated]");
	if (readonly)
		printf(" [read only]");
}
