#include "data.h"
/*			Copyright 1982 by Bill Webb.	 		*/

int cur_rs;		/* record sep for this record */
char *hfmt = "%s";
char *strsave();

#define	NL	'\n'
int NF;
int fscnt;		/* number of actual FS delimiters */

exp_rec(inptr,outptr,flag) register char *inptr, *outptr;
/*
 * take the input buffer and translate it into output
 * buffer format.
 * possible translations are:
 * lflg	translate each field into a line
 * replace record separator by NL
 * if flag then only take the first field.
 */
{
register int c = fs;
char *ptr;
int i;

fscnt = 0;
for (NF=0; ; )
	{
	if (c == fs && !flag)
		{
		ptr = outptr;
		puthdr(++NF,&ptr);
		outptr = ptr;
		}
	c = *inptr++;
	if (c == NULL || (c == recsep && *inptr == NULL))
		break;
	else if (c == fs)
		{
		++fscnt;		/* count actual delimeters */
		*outptr++ = NL;
		if (flag)
			break;
		}
	else *outptr++ = c;
	}
cur_rs = c;		/* record sep on this record */
*outptr++ = NL;
tracef(("Record has %d fields (%d headers)\n",NF,hcnt));
i = NF;
if (hflg)
	for (; i < hcnt;)
		{
		ptr = outptr;
		puthdr(++i,&ptr);
		outptr = ptr;
		*outptr++ = NL;
		}
if (i != NF)
	tracef(("created %d null fields\n",i-NF));
*outptr = 0;
}

puthdr(NF,pptr) char **pptr;
/*
 * output the appropriate header for each field of the record.
 * if a header is present be sure to install the current field
 * separator character
 * -n	number each field.
 * -h	use field header provided.
 */
{
if (nflg || hflg)
	{
	if (header[NF-1] == (char *) NULL)
		{
		if (NF > MAXFIELD)
			Warn("More than %d fields",MAXFIELD);
		sprintf(tmpbuf,"field %2d",NF);
		header[NF-1] = strsave(tmpbuf);
		}
	pprintf(pptr,hfmt,header[NF-1]);
	*(*pptr)++ = fs;		/* put in field separator */
	}
}

int fix_rec(inptr,outptr) register char *inptr, *outptr;
/*
 * take a record in output format, as edited by the user, and
 * rebuild in data file record format.
 * if -n or -h specified then scan for the field delimiter
 * if none, then take appropriate action.
 */
{
register char *p;	/* locates end of line */
char *s;		/* locates end of header */
int i;
int j;

tracef(("fix input '%s'\n",inptr));
for (i=0; ;++i)
	{
	p = inptr;
	while (*p && *p != NL)
		++p;
	if(*p == 0)
		break;		/* no more records */
	*p++ = 0;			/* mark end of field */
	if (nflg || hflg)
		{
		s = inptr;
		while (*s && *s != fs)
			++s;
		if (*s == 0)
			Warn("field %d: '%c' was removed - command cancelled",i,fs);
		p = s;
		while (*--p == ' ')
			*p = 0;		/* remove trailing blanks */
		*s++ = 0;
		while (*inptr == ' ')
			++inptr;	/* remove leading blanks */
		if (mflg && strcmp(inptr,header[i]))
			Warn("field %d header '%s' removed",i,header[i]);
		inptr = s;	/* actual data pointer */
		}
	while (*outptr++ = *inptr++)
		;		/* copy the data */
	outptr[-1] = fs;
	}
for (s=outptr; (outptr[-1] == fs && i > fscnt); --i )
	--outptr;
if (s != outptr)
	tracef(("Removed %d trailing delimiters (%d left)\n",s-outptr,i));
*outptr++ = cur_rs;
*outptr++ = 0;
return(true);
}
