#include "lisp.h"
/*		Copyright 1976 by Bill Webb. 		*/


last(l) struct cons *l;
{
/*
 * return pointer to last cons cell in a list. 
 */
register struct cons *p, *q;

q = nil;
for (p =l; p!=nil; p=p->cdr)
	{
	q = p;
	if(ATOMP(p))
		error("not a list");
	}
return(q);
}

member(a,b) struct cons *a, *b;
{
/* test if a is a member of list b */
register struct cons *p, *q;

p = a;
for (q = b; q!=nil; q = q->cdr)
	if(EQUAL(p,q->car))
		return(1);
return(0);
}

memq(a,b) struct cons *a, *b;
{
/* test if a is a member of list b */
register struct cons *p, *q;

p = a;
for (q = b; q!=nil; q = q->cdr)
	if(EQATOM(p,q->car))
		return(q);
return(0);
}

drev(l) struct cons *l;
{
register struct cons *p, *q, *s;

/*
 * reverse in place the list given.
 */
s = l;
if(s == nil || (s->cdr) == nil)
	return(s);
p = nil;
while ((q = s) != nil)
	{
	s = q->cdr;
	q->cdr = p;
	p = q;
	}
return(p);
}

eqlist(p,q) struct cons *p, *q;
{
register struct cons *a, *b;

a = p; b = q;
if (a == b)
	return(1);
if (NUMP(a) && NUMP(b))
	 return(a->realval == b->realval);
if (ATOMP(a) || ATOMP(b))
	return(0);
return(eqlist(a->car,b->car) && eqlist(a->cdr,b->cdr));
}

makenum(value,tp) NUMERIC value;
{
register struct cons *p;
register int i;

if(!(tp&REAL) && value >= 0.0 && value < MAXNUM)
	if(p = numatoms[i = value])
		return(p);
p = alloc(NUMSIZE);
p->type = (tp & REAL) | ATOM | NUMBER;
p->cdr = badptr;
p->car = p;
p->realval = value;
++num_cnt;
return(p);
}

outint(buff,n)
char *buff;
{
register int k,j;
extern ldivr;

k = ldiv(0,n,10);
j = ldivr;
if(k)
	buff = outint(buff,k);
*buff++ = j+'0';
return(buff);
}

find(s1,s2,n) struct cons *s1, *s2; int *n;
{
register struct cons *a, *b, *q;

a = s1;
b = s2;
if(ATOMP(b))
	return(0);
if(EQUAL(a,b->car) && --*n <= 0)
	return(b);
if( (q = find(a,b->car,n)) || (q = find(a,b->cdr,n)))
	return(q);
return(0);
}

nth(p,n) struct cons *p;
{
/*
 * return n'th element of list p.
 */
while (--n >= 0)
	p = p->cdr;
return(p);
}

pl(n)
{
return(n == 1 ? "" : "s");
}

copylist(l) struct cons *l;
{
register struct cons *p;
register struct cons *q;
struct cons c;

q = &c;
q->cdr = nil;
SCANLIST(l,p)
	q = q->cdr = cons(p->car,nil);
return(c.cdr);
}
