#include "lisp.h"
/*			Copyright 1976 by Bill Webb.	 		*/

/*
 * functions affecting property lists.
 */

SUBR(_put)					/* _put		*/
{
register struct cons *a, *q, *p;

a = ARG1;
p = cnt <= 2 ? defprop : ARG3;
if(ATOMP(a))
	a->cdr = putprop(a->cdr,ARG2,p);
else
	for (; a!=nil; a=a->cdr)
		{
		q = a->car;
		CHKATOM(q);
		q->cdr = putprop(q->cdr,ARG2,p);
		}
return(p);
}

SUBR(_putl)					/* _putl	*/
{
register struct cons *a, *p;

a = ARG1;
p = cnt <= 2 ? defprop : ARG3;
return(putprop(a,ARG2,p));
}

SUBR(_addprop)					/* _addprop	*/
{
register struct cons *a, *q, *p;

a = ARG1;
p = cnt <= 2 ? defprop : ARG3;
if(ATOMP(a))
	a->cdr = addprop(a->cdr,ARG2,p);
else
	for (; a!=nil; a=a->cdr)
		{
		q = a->car;
		CHKATOM(q);
		q->cdr = addprop(q->cdr,ARG2,p);
		}
return(p);
}

addprop(a,b,c) struct cons *a, *b, *c;
{
/* add property b, value c, to property list a.
 */
a = cons(b,cons(c,a));
return(a);
}

putprop(a,b,c) struct cons *a, *b, *c;
{
/*
 * replace prop b (with value c) in property list a.
 */
register struct cons *p, *q;

/* search for property already on list. */
SCANPROP(a,p)
	{
	q = p->car;
	if(EQATOM(q,b))
		{
		p->cdr->car = c;
		return(a);
		}
	}
return(addprop(a,b,c));		/* add new property */
}

FSUBR(_defprop)					/* _defprop	*/
{
register struct cons *p;
struct cons *ptrs[3];

p = l;
ptrs[0] = p->car;
ptrs[1] = (p = p->cdr) -> car;
ptrs[2] = (p = p->cdr) -> car;
_put(p==nil ? 2 : 3, ptrs);
return(ptrs[0]);
}


FSUBR(_get)					/* _get		*/
{
register struct cons *a, *b;

a = eval(l->car);
if(ATOMP(a))
	a = a->cdr;
b = eval(l->cdr->car);
return(getprop(a,b,l->cdr->cdr));
}


FSUBR(_getl)					/* _getl	*/
{
register struct cons *a, *b, *p;

a = eval(l->car);
b = eval(l->cdr->car);
CHKLIST(b);
return(getlprop(a,b,l->cdr->cdr));
}

getprop(a,b,c) struct cons *a, *b, *c;
{
/*
 * search property list a for property b.
 * return value if found else evaluate c.
 * if c == nil return nil.
 */
register struct cons *p;

SCANPROP(a,p)
	if(EQATOM(p->car,b))
		return(p->cdr->car);
if(c!=nil)
	c = eval(c->car);
return(c);
}

SUBR(_rem)					/* _rem	*/
{
register struct cons *a, *q;
register int p;

a = ARG1;
p = cnt > 2 ? integer(ARG3) : 1;
if(ATOMP(a))
	remprop(a,ARG2,p);
else
	for (; a!=nil; a=a->cdr)
		{
		q = a->car;
		CHKATOM(q);
		remprop(q,ARG2,p);
		}
return(nil);
}

remprop(atom,prop,cnt) struct cons *atom, *prop;
{
register struct cons *p, *q;

q = atom;
for (p=q->cdr; p!=nil; p = (q=p->cdr)->cdr)
	{
	if(EQATOM(p->car,prop))
		{
		q->cdr = p->cdr->cdr;
		if(--cnt < 0)
			break;
		}
	}
return(nil);
}

getlprop(a,b,c) struct cons *a, *b, *c;
{
/*
 * search property list a for any property in list b.
 * return rest of the list if found else evaluate c.
 * if c == nil return nil.
 */
register struct cons *p;

SCANPROP(a,p)
	if(memq(p->car,b))
		return(p);
if(c!=nil)
	c = eval(c->car);
return(c);
}
