#include "lisp.h"
/*			Copyright 1976 by Bill Webb.	 		*/

NUMERIC fix();

SUBR(_add1)						/* _add1	*/
{
register struct cons *p;

p = ARG1;
CHKNUM(p);
return(makenum(p->realval + 1.0,p->type));
}

SUBR(_sub1)						/* _sub1	*/
{
register struct cons *p;

p = ARG1;
CHKNUM(p);
return(makenum(p->realval - 1.0,p->type));
}

SUBR(_minus)						/* _minus	*/
{
register struct cons *p;

p = ARG1;
CHKNUM(p);
return(makenum(-p->realval,p->type));
}

SUBR(_plus)						/* _plus	*/
{
register struct cons *p;
register tp;
NUMERIC sum;

sum = 0.0;
tp = ATOM | NUMBER;
while (--cnt >= 0)
	{
	p = *args++;
	CHKNUM(p);
	sum =+ p->realval;
	tp =| p->type;
	}
return(makenum(sum,tp));
}

SUBR(_times)						/* _times	*/
{
register struct cons *p;
register tp;
NUMERIC prod;

prod = 1.0;
tp = ATOM | NUMBER;
while (--cnt >= 0)
	{
	p = *args++;
	CHKNUM(p);
	prod =* p->realval;
	tp =| p->type;
	}
return(makenum(prod,tp));
}

SUBR(_zerop)						/* _zerop	*/
{
register struct cons *p;

p = ARG1;
return(BOOL(NUMP(p) && p->realval == 0.0));
}

SUBR(_minusp)						/* _minusp	*/
{
register struct cons *p;

p = ARG1;
return(BOOL(NUMP(p) && p->realval < 0.0));
}

SUBR(_sub)						/* _sub	*/
{
register struct cons *p, *q;
register tp;

p = ARG1;
q = ARG2;
CHKNUM(p);
CHKNUM(q);
tp = p->type | q->type;
return(makenum(p->realval - q->realval,tp));
}

numerr()
{
error("not numeric");
}

notnumerr()
{
error("is numeric");
}

SUBR(_divide)						/* _divide	*/
{
register struct cons *p, *q;

p = ARG1;
q = ARG2;
CHKNUM(p);
CHKNUM(q);
return(makenum(p->realval / q->realval,REAL));
}

SUBR(_remain)						/* _remain	*/
{
NUMERIC a,b;

a = number(ARG1);
b = number(ARG2);
return(makenum(a - fix(a/b) * b,ARG1->type | ARG2->type));
}

SUBR(_greaterp)						/* _greaterp	*/
{
register struct cons *p, *q;

p = *args++;
CHKNUM(p);
while (--cnt > 0)
	{
	q = *args++;
	CHKNUM(q);
	if(p->realval <= q->realval)
		return(nil);
	p = q;
	}
return(t);
}

SUBR(_lessp)						/* _lessp	*/
{
register struct cons *p, *q;

p = *args++;
CHKNUM(p);
while (--cnt > 0)
	{
	q = *args++;
	CHKNUM(q);
	if(p->realval > q->realval)
		return(nil);
	p = q;
	}
return(t);
}

SUBR(_plen)						/* _plen	*/
{
register struct cons *p;

p = ARG1;
CHKATOM(p);
return(makenum(length(p->pname)+0.0, INT));
}


SUBR(_abs)						/* _abs	*/
{
register struct cons *p;
NUMERIC f;

p = ARG1;
CHKNUM(p);
f = p->realval;
if(f < 0)
	f = -f;
return(makenum(f,p->type));
}

SUBR(_float)						/* _float	*/
{

return(makenum( number(ARG1),REAL));
}

SUBR(_fix)						/* _fix */
{

return( makenum( fix( number( ARG1)),INT));
}

SUBR(_min)						/* _min	*/
{
register struct cons *p, *q;

p = *args++;
CHKNUM(p);
while (--cnt > 0)
	{
	q = *args++;
	CHKNUM(q);
	if(p->realval > q->realval)
		p = q;
	}
return(p);
}

SUBR(_max)						/* _max	*/
{
register struct cons *p, *q;

p = *args++;
CHKNUM(p);
while (--cnt > 0)
	{
	q = *args++;
	CHKNUM(q);
	if(p->realval < q->realval)
		p = q;
	}
return(p);
}

SUBR(_length)						/* _length	*/
{
register struct cons *p;
register int l;

l = 0;
for (p = ARG1; p!=nil; p = p->cdr)
	if(ATOMP(p))
		break;
	else
		++l;
return(makenum(l+0.0,INT));
}

NUMERIC number(l) struct cons *l;
{
register struct cons *p;

p = l;
CHKNUM(p);
return(p->realval);
}

integer(l) struct cons *l;
{
register struct cons *p;
register int i;

p = l;
CHKNUM(p);
return(i = p->realval);
}
