#include "lisp.h"
/*		Copyright 1976 by Bill Webb. 		*/

/*
 * Evaluate lisp forms that are "nsubrs" i.e. those that
 * receive their arguments from eval unevaluated. 
 * they then eval any arguments that they need via eval.
 * arguments are passed as a sublist of the list passed to eval.
 */


FSUBR(_and)					/* _and */
{
register struct cons *p;

p = nil;
while (l != nil)
	{
	if((p = eval(l->car)) == nil)
		break;
	l = l->cdr;
	}
return(p);
}

FSUBR(_or)					/* _or */
{
register struct cons *p;

p = nil;
while (l != nil)
	{
	if((p = eval(l->car)) != nil)
		break;
	l = l->cdr;
	}
return(p);
}


FSUBR(_trace)					/* _trace */
{
register struct cons *p;

if(l == nil)
	tflg = 1;
for (p=l; p != nil ; p = p->cdr)
	{
	if(!ATOMP(p->car))
		error("not atomic");
	p->car->type =| TRACE;
	}
return(nil);
}

FSUBR(_untrace)					/* _untrace */
{
register struct cons *p;

if(l == nil)
	tflg = 0;
for (p=l; p != nil ; p = p->cdr)
	{
	if(!ATOMP(p->car))
		error("not atomic");
	p->car->type =&  ~TRACE;
	}
return(nil);
}


FSUBR(_cond)					/* _cond */
{
register struct cons *p, *q;
/*
 * l is a list of lists. the first s-expr of each list is
 * eval'd and if not nil then the rest of the s-exprs (if any)
 * of the list are also eval'd. 
 */
while (l != nil)
	{
	p = l->car;
	/*
	 * p is a pointer to a list. the first elt of the list is
	 * eval'd and if not nil then the rest of p is eval'd.
	 */
	if((q = eval(p->car)) != nil)
		{
		while ((p = p->cdr) != nil)
			q = eval(p->car);
		return(q);
		}
	l = l->cdr;
	}
return(nil);
}

NSUBR(_setq)					/* _setq */
{
return(set(cnt,args,0));
}

SUBR(_set)					/* _set */
{
return(set(cnt,args,1));
}


set(cnt,args,flag) struct cons *args[];
{
register struct cons *p, *q, *r;

/*
 * common set routine.
 * flag == 1 set (eval both args)
 *	   0 setq (1st arg quoted).
 */

if(cnt&1)
	error("set: odd number of arguments");
while ((cnt =- 2) >= 0)
	{
	p = *args++;
	if(!LITATOM(p))
		error("set: not atomic");
	q = *args++;
	if(!flag)
		q = eval(q);
	p->car = q;
	}
return(q);
}


FSUBR(_quote)					/* _quote */
{
return(l->car);
}



FSUBR(_uncons)					/* _uncons */
{
register struct cons *a, *b;

a = eval(l->car);
b = l->cdr->car;
CHKATOM(b);
b->car = a->cdr;
return(a->car);
}

NSUBR(_time)					/* _time */
{
int a_cnt, c_cnt, n_cnt;
register int n, i;
register struct cons *p;
struct cons *q;
int tbuff[6];
float cpu;

c_cnt = cons_cnt;
a_cnt = atom_cnt;
n_cnt = num_cnt;
n = (cnt > 1) ? integer(ARG2) : 1;
times(tbuff);
cpu = (tbuff[0]+tbuff[1]);
q = nil;
for (i=0; i<n; ++i)
	q = eval(ARG1);
times(tbuff);
cpu = (tbuff[0]+tbuff[1]) - cpu;
cpu =/ 60.0;
printf("conses:	%d	atoms: %d	numbers: %d\n",
	cons_cnt-c_cnt, atom_cnt-a_cnt, num_cnt-n_cnt);
printf("time:	cpu:	%.2f	avg: %.3f\n",cpu,cpu/n);
return(q);
}


FSUBR(_prog)					/* _prog */
{
/*
 * evaluate a prog form. only complication is provision
 * for "return" and "go" processing. This is done by changing
 * the eval stack type code to PROG and storing the next form
 * address in the stack frame.
 */
register struct cons *p;
register struct cons *q;
register char **s;

s = curstk;
s->stype = T_PROG;
*evalsp++ = l->cdr;		/* start at begin of arguments */
vpush(l->car);
q = nil;
while ( (p = s->pnext) != nil)
	{
	s->pnext = p->cdr;
	if(!ATOMP(p->car) || p->cdr == nil)
		q = eval(p->car);
	}
unbind();
return(q);
}


SUBR(_return)					/* _return */
{
/*
 * return from the previous prog statment. 
 * with the appropriate parameter.
 */
register char **s;

for (s = curstk; s ; s=s->slast)
	{
	if(s->stype == T_PROG)
		pret(s,ARG1,nil);
	}
error("return not inside prog");

}

NSUBR(_go)					/* _go */
{
/*
 * go atom
 * causes a transfer to the label in the current prog "atom".
 */

register struct cons *label, *p;
register char **s;

label = ARG1;
while (!ATOMP(label))
	label = eval(label);
for (s = curstk; s ; s=s->slast)
	{
	if(s->stype == T_PROG)
		goto gotprog;
	}
error("go not inside prog");

gotprog:

for (p=s->sform->cdr; p!=nil; p=p->cdr)
	{
	if(p->car == label && p->cdr != nil)
		pret(s,nil,p->cdr);
	}
error("label missing");
}

FSUBR(_select)						/* _select */
{
register struct cons *p, *q, *f;
struct cons *value;
/*
 * l is a list of lists. the first s-expr of each list is
 * eval'd and if == value then the rest of the s-exprs (if any)
 * of the list are also eval'd. 
 */

f = l;
value = eval(f->car);
q = nil;			/* just in case */
for (f=f->cdr; f!=nil; f=f->cdr)
	{
	p = f->car;
	/*
	 * p is a pointer to a list. the first elt of the list is
	 * eval'd and if it equal's value then the rest of p is eval'd.
	 * if the conditions are exhausted then the last item of the list
	 * is returned.
	 */
	q = eval(p->car);
	if(f->cdr == nil)
		break;
	if(EQUAL(q,value))
		{
		while ((p = p->cdr) != nil)
			q = eval(p->car);
		break;
		}
	}
return(q);
}

FSUBR(_selq)						/* _selq */
{
register struct cons *p, *q, *f;
struct cons *value;
/*
 * l is a list of lists. if the first s-expr of a list is
 * an atom it is EQ tested against value, otherwise it is MEMQ tested
 * against members of the list. if a test returns true then the
 * of the list are also eval'd. 
 */

f = l;
value = eval(f->car);
q = nil;			/* just in case */
for (f=f->cdr; f!=nil; f=f->cdr)
	{
	p = f->car;
	/*
	 * p is a pointer to a list. the first elt of the list is
	 * tested against "value".
	 * if the conditions are exhausted then the last item of the list
	 * is returned.
	 */
	q = p->car;
	if(f->cdr == nil)
		{
		q = eval(p);
		break;
		}
	if( ATOMP(q) ? EQATOM(q,value) : ( q = memq(value,q)) )
		{
		p = p->cdr;
		while (p != nil)
			{
			q = eval(p->car);
			p = p->cdr;
			}
		break;
		}
	}
return(q);
}

NSUBR(_assoc)						/* _assoc */
{
register struct cons *a, *b, *p;

a = eval(ARG1);
b = eval(ARG2);

SCANLIST(b,p)
	if(EQUAL(a,p->car->car))
		return(p->car);
return(cnt > 2 ? eval(ARG3) : nil);
}

NSUBR(_assocq)						/* _assocq */
{
register struct cons *a, *q, *p;

a = eval(ARG1);

SCANLIST(eval(ARG2),p)
	{
	q = p->car;
	if(EQATOM(a,q->car))
		return(q);
	}
return(cnt > 2 ? eval(ARG3) : nil);
}

FSUBR(_defun)					/* _defun */
{
/*
 * (defun fn <type> <args> s-expr list )
 * on entry f->car ==> fn.
 *
 * on exit: 
 * (car(fn) ==> (expr (lambda args s-exprs) ... other properties).
 */
register struct cons *tp, *fn, *f;
struct cons *argp, *ltype;

f = l;
fn = f->car;
tp = f->cdr->car;		/* presumed type */
argp = f->cdr;
ltype = (tp == expr) ? lambda : ((tp == nexpr) ? nlambda : 
	((tp == fexpr) ? flambda : 0));
if(ltype)
	argp = argp->cdr;
else
	ltype = lambda;
if(fn->cdr != nil && fn->cdr->car == expr)
	fn->cdr = fn->cdr->cdr->cdr;		/* unlink previous fn */
fn->cdr = cons(expr, cons( cons(ltype,argp), fn->cdr));
return(fn);
}


pret(sl,result,ptr) struct cons *ptr, *result; char **sl;
{
/*
 * return to prog at requested sl with given result.
 * the stack is fixed up appropriately.
 */

register char **s;
register char **c;

c = curstk = sl;
s = c->snext->r5;
evalsp = c->snext;
c->snext = 0;
if(ptr)
	c->pnext = ptr;
ret(result,s);
}

NSUBR(_repeat)						/* _repeat */
{
register struct cons *r, *f;
register int n;

r = nil;
n = integer(ARG2);
while (--n >= 0)
	{
	r = eval(ARG1);
	if(cnt > 2 && EQUAL(r,ARG3))
		break;
	}
return(r);
}

NSUBR(_until)						/* _until */
{
register int i;
register struct cons *r;

while ((r = eval(ARG1)) == nil)
	{
	for (i=1; i<cnt; ++i)
		eval(args[i]);
	}
return(r);
}

NSUBR(_while)						/* _while */
{
register int i;
register struct cons *r;

while ((r = eval(ARG1)) != nil)
	{
	for (i=1; i<cnt; ++i)
		eval(args[i]);
	}
return(r);
}
