#include "lisp.h"
/*			Copyright 1976 by Bill Webb.	 		*/

SUBR(_map)						/* _map	*/
{
/*
 * apply "fn" to "l1 ... ln" then to "(cdr l) .... (cdr ln)" 
 * til any l[i] is empty. 
 * returns nil.
 */
register int i;
char **s;
register struct cons *p, *q;

for (s=evalsp; ; evalsp = s)
	{
	for (i=1; i<cnt; ++i)
		{
		p = args[i];
		if(p == nil)
			return(nil);
		*evalsp++ = p;
		args[i] = p->cdr;
		}
	apply(ARG1,cnt-1,s);
	}
}

SUBR(_mapc)						/* _mapc	*/
{
register int i;
register char **s;
register struct cons *p;

for (s=evalsp; ; evalsp = s)
	{
	for (i=1; i<cnt; ++i)
		{
		p = args[i];
		if(p == nil)
			return(nil);
		*evalsp++ = p->car;
		p = p->cdr;
		args[i] = p;
		}
	apply(ARG1,cnt-1,s);
	}
}

SUBR(_maplist)						/* _maplist	*/
{
register int i;
char **s;
register struct cons *q, *p;
struct cons c;

q = &c;
q->cdr = nil;
for (s=evalsp; ; evalsp = s)
	{
	for (i=1; i<cnt; ++i)
		{
		p = args[i];
		if(p == nil)
			return(c.cdr);
		*evalsp++ = p;
		args[i] = args[i]->cdr;
		}
	q = q->cdr = cons(apply(ARG1,cnt-1,s),nil);
	}
}

SUBR(_mapcar)						/* _mapcar	*/
{
register int i;
char **s;
register struct cons *q, *p;
struct cons c;

q = &c;
q->cdr = nil;
for (s=evalsp; ; evalsp = s)
	{
	for (i=1; i<cnt; ++i)
		{
		p = args[i];
		if(p == nil)
			return(c.cdr);
		*evalsp++ = p->car;
		args[i] = args[i]->cdr;
		}
	q = q->cdr = cons(apply(ARG1,cnt-1,s),nil);
	}
}


SUBR(_mapcon)						/* _mapcon	*/
{
register int i;
char **s;
register struct cons *q, *p;

q = nil;
for (s=evalsp; ; evalsp = s)
	{
	for (i=1; i<cnt; ++i)
		{
		p = args[i];
		if(p == nil)
			return(q);
		*evalsp++ = p;
		args[i] = args[i]->cdr;
		}
	q = nconc(q,apply(ARG1,cnt-1,s));
	}
}

SUBR(_mapcan)						/* _mapcan	*/
{
register int i;
char **s;
register struct cons *q, *p;

q = nil;
for (s=evalsp; ; evalsp = s)
	{
	for (i=1; i<cnt; ++i)
		{
		p = args[i];
		if(p == nil)
			return(q);
		*evalsp++ = p->car;
		args[i] = args[i]->cdr;
		}
	q = nconc(q,apply(ARG1,cnt-1,s));
	}
}

nconc(a,b) struct cons *a, *b;
{
/*
 * tack list b onto list a (assuming neither is nil).
 */
register struct cons *p;

if( (p = a) == nil)
	return(b);
while (p->cdr != nil)
	p = p->cdr;
p->cdr = b;
return(a);
}

SUBR(_mapob)						/* _mapob	*/
{
register struct cons *p;

SCANLIST(oblist,p)
	{
	if(p->car == undef)
		continue;
	*evalsp++ = p->car;
	apply(ARG1,1,evalsp-1);
	--evalsp;
	}
return(nil);
}
