#include "lisp.h"
/*		Copyright 1976 by Bill Webb. 		*/


struct cons *_length();
struct cons *scanatom();
int attn();
int buserr();
int fpterr();
int memerr();
int reset();
int gotattn;
struct {char **CHAR; };
struct { int (*fn)();};

main(dargc,dargv)
char **dargv;
{

argc = --dargc;
argv = ++dargv;
initalloc();
init();
printf("Lisp/Unix\n");
setexit();
gotattn = (signal(2,1)&1) == 0;
setsigs();
for (EVER)
	{
	pfx = '*';
	print(eval(rd()),NORMAL);
	}
}

cons(a,b) struct cons *a, *b;
{
register struct cons *p;

p = alloc(CONSSIZE);
p->type = CONSTYPE;
p->car = a;
p->cdr = b;
++cons_cnt;
return(p);
}


init()
{
register char **p;
register int i;

initio();
memnext = membottom;
curstk = 0;
cons_cnt = atom_cnt = num_cnt = 0;
gen_cnt = 0;
tlevel = 2;
oblist = nil = 0;
badptr = 1;
evalsp = &evalstack;
nil = makeatom(0,0,"nil");
nil->car = nil->cdr = nil;
oblist->cdr = nil;
undef = makeatom(nil,nil,"*undef*");
t = makeatom(0,nil,"t");
t->car = t;
for (p=atoms; *p; p =+ 2)
	*(p->addr) = makeatom(undef,nil,*p);
for (p=subrs; *p; p =+ 3)
	makeatom(undef,nil,p[0]) -> cdr = cons(subr,cons(p,nil));
for (p=nsubrs; *p; p =+ 3)
	makeatom(undef,nil,p[0]) -> cdr = cons(nsubr,cons(p,nil));
for (p=fsubrs; *p; p =+ 3)
	makeatom(undef,nil,p[0]) -> cdr = cons(fsubr,cons(p,nil));
if(argc > 0)
	{
	--argc;
	if((fin = open(argv[0],0))<0)
		{
		printf("can't open %s\n",argv[0]);
		exit(1);
		}
	++argv;
	}
defprop = t;
for (i=0; i<MAXNUM; ++i)
	numatoms[i] = makenum(i+0.0,INT);
}

prin1(p,flag) struct cons *p;
{
if(ATOMP(p))
	if(NUMP(p))
		if(REALP(p))
			printf("%f",p->realval);
		else
			printf("%.0f",p->realval);
	else
		{
		if(flag&PQUOTE)
			pquoted(p->pname);
		else
			printf("%s",p->pname);
		}
else
	printf("&");
return(p);
}

makeatom(carval,cdrval,name) char *name;
{
/*
 * build an atomic cell with pname "name".
 */
register struct cons *p;
register struct cons *o;

if(o = scanatom(name))
	return(o);
p = newatom(carval,cdrval,name);
oblist = cons(p,oblist);
return(p);
}

newatom(carval,cdrval,name) char *name;
{
register struct cons *p;
register int l;

++atom_cnt;
l = length(name)+1;
p = alloc(CONSSIZE+l);
copy(p->pname,name);
p->car = carval;
p->cdr = cdrval;
p->type = ATOM;
return(p);
}

print(p,flag) struct cons *p;
{
prin(p,flag,MAXINT);
terpri();
return(p);
}

prin(p,flag,n) struct cons *p;
{
/*
 * print s-expr "p" according to the print flags in "flag".
 * if the level "n" goes below zero then force a call to prin1.
 */
register struct cons *x, *j;
register char **s;
extern char *end;

x = p;
if(x < &end || x >= memnext)
	{
	printf("*");
	return(x);
	}
if(--n <= 0 || ATOMP(x))
	{
	prin1(x,flag);
	return(x);
	}
if(!(flag&NOMACRO) && PMACROP(x->car))
	{
	j = getprop(x->car->cdr,pmacro,nil);
	if(j != nil)
		{
		s = evalsp;
		*evalsp++ = cons(x,nil);
		j = apply(j,1,s);
		evalsp = s;
		if(j != nil)
			return(x);
		}
	else
		error("missing pmacro");
	}
j = x;
putchar('(');
do
	{
	prin(j->car,flag,n);
	if(j->cdr == nil)
		goto c;
	putchar(' ');
	j = j->cdr;
	}
while (! ATOMP(j));
putchar('.');
putchar(' ');
prin1(j,flag);
c:	putchar(')');
return(x);
}




error(s,d1,d2,d3,d4)
char *s;
{
register struct cons *tp;

sp_level = level = 0;		/* in case error in read */
if(col)
	{
	col = 0;
	putchar(' ');
	}
terpri();
printf("error ... ");
printf(s,d1,d2,d3,d4);
terpri();
terread();
fin = 0;
setsigs();
if(tp = curstk)
	{
	print(tp->sform,NOMACRO);
	brkloop();
	}
toplevel();
}

attn()
{
sleep(1);
error("attn");
}

memerr()
{
error("mem error");
}

buserr()
{
error("bus error");
}

fpterr()
{
error("fpt error");
}


setsigs()
{
signal(10,&buserr);
signal(8,&fpterr);
signal(11,&memerr);
if(gotattn)
	signal(2,&attn);
}

struct cons *scanatom(name) char *name;
{
register struct cons *o;

for (o=oblist; o != nil; o=o->cdr)
	{
	if(equal(o->car->pname,name))
		return(o->car);
	}
return(0);
}

SUBR(_putob)
{
register struct cons *p;

while (--cnt >= 0)
	{
	p = *args++;
	CHKLIT(p);
	if(scanatom(p->pname) != p)
		oblist = cons(newatom(undef,nil,p->pname),oblist);
	}
return(nil);
}

SUBR(_remob)
{
register struct cons *p, *o;
register char *q;

while (--cnt >= 0)
	{
	p = *args++;
	CHKLIT(p);
	q = 0;
	SCANLIST(oblist,o)
		{
		if(o->car == p)
			{
			if(q)
				q->cdr = o->cdr;
			else
				oblist = o->cdr;
			break;
			}
		q = o;
		}
	}
return(nil);
}

NSUBR(_status)					/* _status */
{
register struct cons *p;
register struct cons *a;
register int n;

while (--cnt >= 0)
	{
	p = *args++;
	n = integer(p->car);
	p = p->cdr;
	a = p->car;
	p = p->cdr;
	switch (n)
		{
	case 4:		/* pmacro status of atom */
		CHKLIT(a);
		if(p == nil)
			return(BOOL(PMACROP(a)));
		if(p->car == nil)
			a->type =& ~PMACRO;
		else
			a->type =| PMACRO;
		}
	}
return(nil);
}

pquoted(name) char *name;
{
/*
 * if name contains any significant characters then quote the name.
 */
register char *p;

for (p=name; *p; )
	if(delim(*p++))
		{
		printf("\"%s\"",name);
		return;
		}
printf("%s",name);
}
