#include "lisp.h"
/*			Copyright 1976 by Bill Webb.	 		*/

struct free
{
int type;
struct free *freenext;
int freelen;
} *freelist;
int free_cnt;		/* # of bytes on the free list */
int free_cons;		/* # of cons cells collected */

#define	FREEMIN	(CONSIZE)/2
#define	FREEMAX	(NUMSIZE)/2
struct free *freevec[FREEMAX];
#define	FREETYPE	0100
#define	GCMASK	(FREETYPE|ATOM|NUMBER)

#define	MARK(x)	x->type =| GC
#define	UNMARK(x)	x->type =& ~GC;
#define	MARKED(x)	(x->type & GC)

#define	MEMINCR	4096
#define	MAXMEM	0157776

alloc(n)
{
register char *p;
register char **q;
register int i;

if(n&1)
	++n;
i = (n-CONSSIZE)>>1;
if(i < FREEMAX)
	{
	q = freevec+i;
	p = *q;
	if(p)
		{
		*q = p->freenext;
		return(p);
		}
	}
/*
 * code should be placed here to allocate off of "freelist".
 */
p = memnext;
if(p+n > memtop)
	{
	memtop =+ MEMINCR;
	if(memtop > MAXMEM || brk(memtop) < 0)
		error("out of space");
	}
memnext =+ n;
return(p);
}

initalloc()
{
memnext = membottom = memtop = sbrk(0);
}

mark(l) struct cons *l;
{
register struct cons *p;

p = l;
if(p < membottom || p >= memnext || MARKED(p))
	return;
MARK(p);
if(!NUMP(p))
	{
	mark(p->car);
	mark(p->cdr);
	}
}

memscan()
{
/*
 * scan all of allocated memory for unmarked cons cells.
 * return unmarked ones to the free list.
 */
register char *p;
register int l;

for (p=membottom; p<memnext; p =+ l)
	{
	switch(p->type & GCMASK)
		{
	case CONSTYPE:
		l = CONSSIZE;
		break;
	case ATOM:
		l = CONSSIZE + 1 + length(p->pname);
		if(l&1)
			++l;
		break;
	case ATOM|NUMBER:
		l = NUMSIZE;
		break;
	case FREETYPE:
		l = p->freelen;
		break;
	default:
		error("bad cell type %o at %o",p->type,p);
		}
	if(!MARKED(p))
		free(p,l);
	UNMARK(p);
	}
}

free(p,l)
char *p;
{
/*
 * free a chunk of memory pointed to by "p" of "l" bytes.
 * if it's size is less than FREEMAX put it into individual
 * freelists, otherwise into general freelist "frelist".
 */
register int n;
register char **q;

n = (l-CONSSIZE)>>1;
q = n < FREEMAX ? freevec+n : &freelist;
p->type = FREETYPE;
p->freenext = *q;
p->freelen = l;
*q = p;
free_cnt =+ l;
++free_cons;
}


collect()
{
register char **p, **q;
register int l;
int j;

mark(oblist);
markstack();
for (p=freelist; p; p=p->freenext)
	MARK(p);
for (q = freevec; q<freevec+FREEMAX; )
	for (p = *q++; p; p=p->freenext)
		mark(p);
for (p=numatoms; p<numatoms+MAXNUM; )
	mark(*p++);
for (p=atoms; *p; p =+ 2)
	mark(p[1]);
l = free_cnt;
j = free_cons;
memscan();
l = free_cnt-l;
j = free_cons-j;
printf("collected: %d byte%s %d cell%s\n",l,pl(l),j,pl(j));
return(j);
}

SUBR(_collect)
{
return(makenum(collect()+0.0,INT));
}

markstack()
{
register char **p, **q, **limit;

/*
 * scan through the stack marking all cons cell pointers.
 * stack is organized so that all non-pointers are at the
 * front.
 */

limit = evalsp;
for (p = curstk; p; p = p->slast)
	{
	mark(p->sform);
	for (q = p->arglist; q < limit; )
		mark(*q++);
	limit = p;
	}
}
