#include "link.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define V 2
#define N 4
#define NV 6 

char rld_len[]
{0,V,N,V,N,NV,NV,NV,V,0,N,0,NV,NV,NV};
/*
 * process rld info 
 */
rld(line,linecnt)
char *line;
int linecnt;
{
register char *linep;
int value;
register struct psect *p;
register struct symbol *s;
char *linemax;
int disp;

linep = line;
linemax = line+linecnt;

while (linep < linemax)
{

rel_cmd = *linep++; /* cmd character */
disp = *linep++ & 0377; /* displacement */
rel_addr = rel_base + disp;
if(debflg && (rel_cmd < 7 || rel_cmd > 010 ))
	printf("rld %o at %o",rel_cmd&0377,rel_addr);

switch(rel_cmd&0177)
	{
case 01:	/* internal relocation */
	put(cur_reloc + *linep.INT++);
	break;

case 02:	/* global relocation */
	put(getsym(linep));
	linep =+ 4;
	break;

case 03:	/* internal displaced relocation */
	put(*linep.INT++ - (rel_addr+2));
	break;

case 04:	/* global displaced relocation */
	put(getsym(linep)-(rel_addr+2));
	linep =+ 4;
	break;

case 05:	/* global additive relocation */
	value = getsym(linep);
	linep =+ 4;
	put(value + *linep.INT++);
	break;

case 06:	/* global additive displaced relocation */
	value = getsym(linep);
	linep =+ 4;
	value =+ *linep.INT++;
	put(value - (rel_addr+2));
	break;

case 07:	/* location counter definition */
	cur_psect = getpsect(linep);
	if(debflg)
		printf(" psect %.8s",cur_psect->p_name);
	linep =+ 4;
	cur_reloc = cur_psect->p_reloc;
	rel_base = cur_reloc;
case 010:	/* location counter modification */ 
	rel_base =+ *linep.INT++;
	rel_off = (cur_psect->p_flags & SHR) ? 0 : data_off;
	if(debflg)
		printf(" rel_base=%o",rel_base);
	break;

case 011:	/* program limits */
	put(low_limit);
	put(high_limit);
	break;

case 012:	/* psect relocation */
	p = getpsect(linep);
	linep =+ 4;
	put(p->p_reloc);
	break;

case 014:	/* psect displaced relocation */
	value = getpsect(linep)->p_reloc;
	linep =+ 4;
	value =+ *linep.INT++;	/* ??? */
	put(value - (rel_addr+2));
	break;

case 015:	/* psect additive relocaton */
	value = getpsect(linep)->p_reloc;
	linep =+ 4;
	put(value + *linep.INT++);
	break;

case 016:	/* psect additive displaced relocaton */
	value = getpsect(linep) -> p_reloc;
	linep =+ 4;
	put( value+ *linep.INT++ - (rel_addr+2));
	break;

	}	/* of switch */
if(debflg)
	putchar('\n');
}	/* of while */
}

put(value)
{
register int len;

pseek(rel_addr);	/* seek to right place */
if (rel_cmd&0200)
	{
	putch(value.lo);
	len=1;
	}
else
	{
	len=2;
	putwd(value);
	}
rel_addr =+ len;
}

getsym(linep)
char *linep;
{
register struct symbol *s;
char name[8];

cvtname(linep,name);
s = findsymbol(name);
return(s==0 ? 0 : s->s_addr);
}

getpsect(linep)
char *linep;
{
register struct psect *p;
char name[8];

cvtname(linep,name);
p = findpsect(name);
if(p->p_flags==0)
	{
	warn("psect <%.8s> undefined",p->p_name);
	p->p_flags = DEFINED | REL | LCL | PRV | CON;
	}

return(p);
}


tmpwrite(code,line,linecnt)
int code;
int *line;
int linecnt;
{
register int *linep;
register int l;

putw(code,&tmp);
putw(linecnt,&tmp);
l = (linecnt + 1)>>1;
linep = line;
if(l>0)
	do
		putw(*linep++,&tmp);
	while (--l);
}


/*
 * during pass1 just write rld info directly into the tmp file 
 * after marking psects with rld info in them.
 */
rld1(line,linecnt)
char *line;
int linecnt;
{
register char *linep;
register int len;
char *linemax;
int disp;
char name[8];

linep = line;
linemax = line+linecnt;

while (linep < linemax)
	{
	
	rel_cmd = *linep++ & 0377; /* cmd character */
	disp = *linep++ & 0377; /* displacement */
	len = rld_len[rel_cmd&0177];
	
	if(debflg)
		{
		printf("rld %o disp %o",rel_cmd,disp);
		if(len&4)
			{
			cvtname(linep,name);
			printf(" '%s'",name);
			}
		if(len&2)
			printf(" %o",(linep+len-2)->INT);
		putchar('\n');
		}
	switch(rel_cmd&0177)
		{
	case 01:	/* internal relocation */
	case 03:	/* internal displaced relocation */
	case 02:	/* global relocation */
	case 04:	/* global displaced relocation */
	case 05:	/* global additive relocation */
	case 06:	/* global additive displaced relocation */
	case 010:	/* location counter modification */
	case 011:	/* program limits */
	case 012:	/* psect relocation */
	case 014:	/* psect displaced relocation */
	case 015:	/* psect additive relocation */
	case 016:	/* psect additive displaced relocation */
		break;
	case 07:	/* location counter defintion */
		cur_psect = getpsect(linep);
		cur_psect->p_flags =& ~ BSS;
		break;
	
	default:
		err("bad rel code %o",rel_cmd);
		}
	linep =+ len;
	}
tmpwrite(RLD,line,linecnt);
}
