#include "link.h"
/*		Copyright 1976 by Bill Webb. 		*/

#define STATS "/mnt/webb/linker.stats"
int jmp 0137;		/* jmp @# ... */

char line[512];
int cur_reloc;
int cur_rflag;
int ccflg;
int pos; /* current # of character in line */
char blank[8];		/* blank (nul) name */
char libname[20];	/* /lib/ftnlibx.a */

main(argc,argv)
int argc;
char *argv[];
{
register int i;


pgname = *argv++;
init();
do_arg(argc,argv);
argp = 0;		/* no longer reading file */
if(debflg || scan)
	dumpsym("Symbol table before allocation\n");

defpsects();		/* define psect symbols */
allocate();
pass = 2;
if(debflg || scan)
	map();		/* output psect map */
if(debflg || scan)
	dumpsym("Symbol table after allocation\n");
pass2();	/* finish up */
if(scan || debflg)
	printf("\n%s complete.\n",pgname);
flush();
#ifdef	STATS
if((i=open(STATS,1)) > 0)
	{
	seek(i,0,2);
	write(i,&nsymbols,2);
	write(i,&npsects,2);
	close(i);
	}
#endif
exit(0);
}

do_arg(argc,argv)
int argc;
char *argv[];
{


while (--argc > 0)
{
argp = *argv++;
if (*argp == '-')
	{
	switch(*++argp)
		{
		case 'a':
			++aflg;
			break;
		case 'c':
			++ccflg;
			break;
		case 'd':
			++debflg;
			break;
		case 'o':
			++scan;
			break;
		case 's':
			++sflg;
			break;
		case 'n':
			++sharing;
			break;

		case 'i':		/* i/d space separation */
			++sharing;
			++idsep;
			break;
		case 'l':
			copy(libname,"/lib/ftnlib");
			append(libname,++argp);
			append(libname,".a");
			argp = libname;
			goto doopen;

		case 'w':		/* warn about common differences */
			++wflg;
			break;

		case 'z':		/* include all of library */
			++zflg;
			break;
		default:
			printf("bad switch\n");
			break;
		}
	continue;
	}

doopen:
if (filopen(argp)<0)
	err("on open");

switch(getwd())
	{
case ARMAGIC:
	library();
	zflg = 0;		/* reset after each library */
	break;

case 0407:		/* normal unix obj */
	gseek(-2);	/* back up so we can read the who header */
	unixobj();
	break;

case 0410:
case 0411:
	err("unix load module");

case -1:	/* end of file */
	err("empty file");

default:
	gseek(-2);
	while(do_obj())
		;
	}

fclose();
}

}

do_obj()
{
register char *linep;
register char c;
register int linecnt;

cur_psect = 0;
defining = 1;
c = END;	/* make it right */
while ((linecnt=fbread(line))>0)
	{
	linep=line;
	c = *linep++;
	if (*linep++)
		err("fb fmt 3");
	linecnt =- 2;
	switch(c)
		{
		case GSD:
			print("gsd ");
			gsd(linep,linecnt);
			break;
		case ENDGSD:
			print("end gsd");
			break;
		case TXT:
			txt1(linep,linecnt);
			break;
		case MTXT:
			err("Harvard obj module");
			break;
		case RLD:
			rld1(linep,linecnt);
			break;
		case ISD:
			print("isd");
			break;
		case END:
			sprint("end\n");
			++module;		/* count module */
			tmpwrite(MODULE,0,0);	/* mark end of module */
			return(1);	/* got an object module - maybe more */
		default:
			err("bad code %o",c);
		}
	}

/* end of input file - must also be end of object */
if(c==END)
	return(0);
else
	err("incomplete object module");

}


gsd(buff,len)
char *buff;
{
register char *linep;
register char c;
char name[8];
register int flags;
int value;

linep=buff;
for (;len>0;len=- 8)
	{
	c = linep[5]; /* get type */
	flags = linep[4]; /* get flags */
	cvtname(linep,name); /* convert name to ascii */
	value = word(linep+6);
	if(scan && c!=GLOBL && (pos&3)!=0)
		{
		putchar('\n');
		pos = 0;
		}
	switch(c)
		{
		case TITLE:
			if(scan)
				{
				printf(".title	%.8s		file: %s",name,argp);
				if(libmod[0])
					printf("	module %s",libmod);
				putchar('\n');
				}
			break;
		
		case CSECT:
			print("csect <%.8s>",name);
			flags = REL | OVR | PRV | LCL;
			if(name[0]==0)	/* blank psect */
				flags =& ~OVR;
			else
				if(eqstr(name,". abs."))
					flags =& ~(REL|GBL); /* make it abs */
			do_psect(name,flags,value);
			break;
		
		case INTERNAL:
			printf("internal");
			break;
		
		case TRANSFER:
			if((value&1)==0)
				{ /* got a transfer address */
				tr_psect = findpsect(name);
				if(tr_psect->p_def != module)
					warn("transfer psect <%.8s> undefined",
						tr_psect->p_name);
				tr_addr = value + tr_psect->p_reloc;
				sprint("transfer <%.8s> %o",name,value);
				}
			else
				print("transfer <%.8s> %o",name,value);
			break;
		
		case GLOBL:
			do_globl(name,flags,value);
			break;
		
		case PSECT:
			do_psect(name,flags,value);
			break;
		
		case IDENT:
			if(scan)
			printf(".ident %.8s",name);
			break;
		
		default:
			printf("(%o)",c&377);
		}
	linep=+ 8;
	}
}

do_header()
{
aa_out.a_magic = sharing && text.p_size > 0 ?  ( idsep ? 0411 : 0410 ) : 0407;
aa_out.a_tsize = text.p_size;
aa_out.a_dsize = data.p_size;
aa_out.a_bsize = bss.p_size;
aa_out.a_ssize = 0; /* no symbol table */
aa_out.a_entry = 0; /* always */
aa_out.a_dummy = 0; /* unused */
aa_out.a_rflag = 1; /* no relocation */

seek(out.fildes,0,0); /* to start of file */
write(out.fildes,&aa_out,aa_len);
}


init()
{
extern fout;
int stop();
register char *p;
int n;

fout = dup(1);
if((signal(SIGINT,1)&1)==0)	/* not ignored */
	signal(SIGINT,&stop);
if((signal(SIGHUP,1)&1)==0)	/* not ignored */
	signal(SIGHUP,&stop);
pass = 1;
n = getpid();
copy(tempfile,"/tmp/l000000");
for (p= &tempfile[12]; p > &tempfile[6]; )
	{
	*--p = (n & 07) + '0';
	n =>> 3;
	}
if(fcreat(tempfile,&tmp)<0)
	err("creating %s",tempfile);
tmp_des = open(tempfile,0);		/* open for later input */
if (tmp_des < 0)
	err("reopening %s",tempfile);
unlink(tempfile);			/* get rid of name */
module = 1;
}


pass2()
{
register int linecnt;
register int l;
register int *linep;
int code;

prundef();


pass = 2;
module = 1;		/* current module number */
defining = 0;	/* in second pass no auto defs */
fflush(&tmp);
if(seek(tmp.fildes,0,0)<0)
	err("while seeking");
out.fildes = creat(outfile,0666);
if(out.fildes < 0)
	err("creating %s",outfile);
chmod(outfile,0666);
do_header();

if(tr_psect!=0)
	{
	tr_addr =+ tr_psect->p_reloc;
	pseek(0);
	putwd(jmp);
	putwd(tr_addr);
	sprint("transfer address: %o",tr_addr);
	}

argp = tempfile;
close(tmp.fildes);
inp.count = 0;
inp.nleft = 0;
inp.fildes = tmp_des;		/* tmp file descriptor */

while ((code=getwd())>0)
	{
	linecnt = getwd();
	l = linecnt;
	if(l & 1)
		++l;		/* must be even */
	linep = line;
	if(l>0)
		gettxt(linep,l);		/* read the text */
	switch(code)
		{
		case TXT:
			txt(linep,linecnt);
			break;
	
		case RLD:
			rld(linep,linecnt);
			break;
	
		case MODULE:
			++module;		/* count object modules */
			break;
	
		case PSECT:
			psect2(linep,linecnt);
			break;
	
		default:
			err("internal error");
		}
	}
close(inp.fildes);
if(!sflg)
	outsymtab();
if(!debflg)
	unlink(tempfile);
if(errcnt==0)
	chmod(outfile,0777);
pflush();
close(out.fildes);
}
