#
/*
 * NOTE:  do not compile this file with the -O (optimize) switch. it will
 * fail.
 */

#define	BLANK	' '
#define	TAB	'\t'
#define	COMMA	','
#define	NL	'\n'
#define	NULL	0
#define	QUOTE	'`'

#define	RC_OK	0
#define	RC_EOL	1
#define	RC_EOF	2
#define	RC_ERR	3
#define	I_REAL		020
#define	I_CONTINUE	040
#define	I_BUFFER	256
#define	I_STREAM	128
#define	I_EOF		0100000
#define	I_ERROR		8192
#define	I_STRING	2048
#define	I_NOZERO	64
#define	I_LENGTH	4096
#define	I_DOUBLE	512
#define	I_TRUNCATE	1024
#define	I_QUOTE		16384

#ifdef LONG
#define	INTEGER long
#else
#define	INTEGER int
#endif

struct { INTEGER INT; };
struct { char CHAR; };
struct { float FLOAT; };
struct { double DOUBLE; };

struct in_free
{
int in_opts;
char *in_ptr;
int in_n;
char **in_args;
char *in_start;
int in_leng;
int in_len;
char in_buff[256];
} in_info;

#define	buff	(in_info.in_buff)
#define	start	in_info.in_start
#define	leng	in_info.in_leng
#define	len	(in_info.in_len)
#define	argp	in_info.in_args
#define	ptr	(in_info.in_ptr)
#define	n	in_info.in_n
#define	opts	(in_info.in_opts)

struct inopts {
char *in_ops;
int in_bits;
} in_opttab[]
{
"con",	I_CONTINUE,
"rea", I_REAL,
"eof",	I_EOF,
"err",	I_ERROR,
"stri",	I_STRING,
"quot",	I_STRING+I_QUOTE,
"tru",	I_STRING+I_TRUNCATE,
"len",	I_STRING+I_LENGTH,
"noz",	I_NOZERO,
"nob",	I_STRING+I_NOZERO,
"stre",	I_STREAM,
"buf",	I_BUFFER,
"pre",	I_DOUBLE,
"scar",	10,
0, 0};

INTEGER inbits(na,args) char *args;
{
int nargs;
register int opt;
register char **argptr;
register struct inopts *q;
char *p;

argptr = &args;
nargs = na;
p = *argptr;
opt = p->INT;
if (opt >= 0 && opt < 16)
	{
	++argptr;
	--nargs;
	}
else
	opt = 0;
while (--nargs >= 0)
	{
	p = *argptr++;
	for (q=in_opttab; q->in_ops; ++q)
		{
		if (eq(p,q->in_ops))
			{
			opt =| q->in_bits;
			q = 0;
			break;
			}
		}
	if (q)
		r_err(23);
	}
return((INTEGER) opt);
}

double in_cvt();
double atof();
infree(nargs,args) char *args;
{
register char *p;
register int l;
register int c;
extern char *atofp;
int unit;
double result;


n = nargs-1;
argp = &args;
opts = (*argp++)->INT;
unit = opts&017;
if (opts&I_BUFFER)
	{
	n =- 2;
	if (n < 0)
		return(in_err("too few arguments"));
	p = *argp;
	++argp;
	len = (*argp)->INT;
	++argp;
	move(len,p,buff);
	buff[len]=0;
	ptr = buff;
	}
else if ((opts&I_CONTINUE)==0)
	{
read:
	ptr = buff;
	len = 128;
	if (inrd2(3,&unit,buff,&len) > 0)
		{
		in_zero();
		if (opts&I_EOF)
			return(RC_EOF);
		else
			return(in_err("unexpected eof"));
		}
	}
while (n > 0)
	{
	while ((c = *ptr) == BLANK || c==TAB)
		++ptr;
	if (c == NULL)
		{
		if (opts&I_STREAM)
			goto read;
		in_zero();
		return(RC_EOL);
		}
	start = ptr;
	if ((opts&I_STRING) && ((opts&I_QUOTE) || *ptr == QUOTE))
		{
		c = in_string();
		if (c)
			return(c);
		}
	else
		{
		while ((c = *ptr) && c!=BLANK && c!=TAB && c!=COMMA)
			++ptr;
		l = ptr-start;
		if (opts&I_STRING)
			{
			if (n < 2)
				return(in_err("length missing"));
			leng = argp[1]->INT;
			if (l > leng)
				{
				if (opts&I_TRUNCATE)
					l = leng;
				else
					return(in_err("string too long"));
				}
			p = *argp++;
			move(l,start,p);
			if ((opts&I_NOZERO) == 0)
				set(p+l,leng-l,' ');
			if (opts&I_LENGTH)
				(*argp)->INT = l;
			++argp;
			n =- 2;
			}
		else
			{
			result = in_cvt(start,l);
			if (atofp != ptr+1)
				return(in_err("conversion error"));
			in_store(result);
			}
		}
	while ((c = *ptr) == BLANK || c==TAB)
		++ptr;
	if (c == COMMA)
		++ptr;
	}
return(RC_OK);
}

in_zero()
{
register int l;
register char *p;
if (opts & I_NOZERO)
	return;
while (n > 0)
	{
	if (opts&I_STRING)
		{
		if ((n =- 2) >= 0)
			{
			p = *argp++;
			l = (*argp++)->INT;
			set(p,l,' ');
			}
		}
	else
		in_store(0.0);
	}
}

in_store(value) double value;
{
register char *p;

p = *argp++;
if ((opts&I_REAL) == 0)
	p->INT = value;
else if (opts&I_DOUBLE)
	p->DOUBLE = value;
else
	p->FLOAT = value;
--n;
}

in_err(s) char *s;
{
register char *p;

in_zero();
if (opts&I_ERROR)
	return(RC_ERR);
p = "infree error: ";
in_wrt(p,length(p));
in_wrt(s,length(s));
in_wrt("\n",1);
r_err(22);
}

in_string()
{
register char *p;
register int l;
register int c;

if (*ptr++ != QUOTE)
	in_err("quoted string required");
p = argp[0];
l = argp[1]->INT;
while ((c = *ptr++))
	{
	if (c == QUOTE && *ptr++ != QUOTE)
		{
		--ptr;
		if ((opts&I_NOZERO) == 0 && (l =- leng) > 0)
			set(p,l,' ');
		++argp;
		if (opts & I_LENGTH)
			(*argp++)->INT = leng;
		return(0);
		}
	else
		{
		if (leng >= l)
			{
			if ((opts&I_TRUNCATE) == 0)
				return(in_err("string too long"));
			}
		else
			{
			++leng;
			*p++ = c;
			}
		}
	}
return(in_err("string not terminated"));
}

double in_cvt(buffer,l) char *buffer;
{
double x;
register char c;

c = buffer[l];
buffer[l] = 0;
x = atof(buffer);
buffer[l] = c;
return(x);
}

in_wrt(bf,ln) char *bf;
{
int fd;
int write();

fd = 2;
f(&write,3,&fd,bf,&ln);
}
