
#define NOTHING 0
#define LN 1
#define EXP 2
#define SQRT 3
#define SQUARE 4
#define SIN 5
#define LOG10 6
#define MULT 7
#define RECIP 8
#define ADD 9
		
/* transf a vector of double k is a constant to add */
/* if bad trans type is used, transf returns a zero, num of trans otherwise */

int transf(data,ndata,type,k)
double *data, k;
int ndata,type;
{
	double log(), exp(), sqrt(), sin();

	register int i;

	for(i=0; i < ndata; i++, ++data){
		switch(type){
			case NOTHING:
				return(0);
				break;
			case LN:
				*data = log(k + *data);
				break;
			case EXP:
				*data = exp(k + *data);
				break;
			case SQRT:
				*data = sqrt(k + *data);
				break;
			case SQUARE:
				*data = (k + *data)*(k + *data);
				break;
			case SIN:
				*data = sin(k + *data);
				break;
			case LOG10:
				*data = log(k + *data) / 2.30258509;
				break;
			case MULT:
				*data = (k * *data);
				break;
			case RECIP:
				*data = 1.0 / (k + *data);
				break;
			case ADD:
				*data += k;
				break;

			default: return(0);
				 break;
		} /* switch */
	} /* for */
	return(i);
} /* routine */
