#include <ctype.h>

#ifdef DEBUG
#include <stdio.h>

char *arglist[]={"ARG0", "ARG1", "ARG2",
		 "ARG3", "ARG4", "ARG5",
		 "ARG6", "ARG7", "ARG8",
		 "ARG9", "ARG10", "ARG11"};
char buf[128];
char tmpbuf[128];
main(){
	int argc;
	while(scanf("%d", &argc) != -1){
		printf("argc=%d\n", argc);
		fgets(buf,128,stdin);
		substitute(buf, tmpbuf, arglist, argc);
		printf("%s", buf);
	}
}
#endif

	/* given a buffer optionally containing args of the form $1, $2 ... $n, 
	 * substitute these args with tabled strings.
	 * INPUT:
	 *	line:buffer w/wo $args
	 *	tmpbuf:scratch buf with at least strlen(line)+1 elements
	 *		after arg substitutions.
	 *	arglist:vector of char *, each pointing to substitution
	 *		strings. e.g. arglist[1] --> subst for $1.
	 *		the char ptrs reside on arglist[1]...arglist[maxargc]
	 *	maxargc:last accessible element in arglist.
	 *	ignore:a flag. if true then subst nulls for undef vars.
	 *		(not implemented)		
	 * OUTPUT:line contains expanded arg strings if substitutions were made
	 */
#define OB	'{'
#define CB	'}'
substitute(line, tmpbuf, arglist, maxargc)
register char *tmpbuf;
char *line, *arglist[];
int maxargc;
{
register char *buf=line;
register int n;
char *tmpbase=tmpbuf, *tmp;
char *strcat();

	while(*buf) {
		if(*buf == '$') {
			for(n = 1; *buf == '$'; buf++)
				if(++n % 2)
					*tmpbuf++ = '$';
			if(!(n % 2)) {
				tmp = buf;
				if(*buf == OB)
					++tmp;
				n = cvtint(&tmp);

				if(*buf == OB && *tmp != CB
					|| (*buf != OB && !isdigit(*buf)) ) {
					*tmpbuf++ = '$';
					*tmpbuf++ = *buf++;
					continue;
				}

				else if(*buf==OB && *tmp==CB && tmp-buf==1)
					err("empty ${}");

				if(0 <= n && n <= (maxargc-1) ) {
					*tmpbuf = '\0';
					tmpbuf=(strcat(tmpbuf,arglist[n])
						+ strlen(arglist[n]));
				}
				if(*(buf=tmp) == CB)
					++buf;
				continue;
			}
		}
		*tmpbuf++ = *buf++;
	}

	*tmpbuf = '\0';
	copy(line, tmpbase);
}
