/*
 * Seek for the stdio library, but modified to not read in a new
 * buffer when the seek is relative and within the current iobuf.
 */

#include	<stdio.h>

/*
main(){
	int c;
	long int x;
	FILE *fp, *fopen();
	fp=fopen("/usr/dict/words","r");
	if(!fp)
		err("noop");
	for(;;){
		scanf("%ld", &x);
		rfseek(fp, x, 1);
		do {
			c = getc(fp);
			putc(c,stdout);
		}
		while(c != '\n' && c != EOF);
	}
}
*/
rfseek(iop, offset, ptrname)
FILE *iop;
long offset;
{
	register n, resync;

	if (iop->_flag&_IOREAD) {
		resync = 0;
		if (ptrname==1) {	/* relative */
			if(offset <= iop->_cnt && offset > iop->_base-iop->_ptr)
				{	/* do not read another io buffer */
				iop->_cnt -= offset;
				iop->_ptr += offset;
				return;
				}
			n = iop->_cnt;
			if (n<0)
				n = 0;
		} else {
			n = offset&01;
			resync = n;
		}
		n = lseek(fileno(iop), offset - n, ptrname);
		iop->_cnt = 0;
		if (resync)
			getc(iop);
		iop->_flag &= ~_IOEOF;	/* clear eof on seek */
		return(n);
	}
	if (iop->_flag&_IOWRT) {
		fflush(iop);
		return(lseek(fileno(iop), offset, ptrname));
	}
	_error("fseek\n");
}
