
#include <stdio.h>
#define true (1)
#define false (0)


/* get nodes:usage GSPACE(ptr,cast,nunits) */
char *calloc(); 
#define GSPACE(p,t,n) if((p=(t *)(calloc(n,sizeof(*p))))==NULL){fprintf(stderr,"nospace\n");exit(1);}

/* ordered binary tree which stores keys to linked data */
typedef struct datanode {
	char *skey;			/* key of data node */
	int ikey;			/* the return index value */
	int bal;			/* balance marker for avl tree */
	struct datanode *ltd, *rtd;	/* next */
} DTNODE;

int scmp;
int ht;		/* boolean to mark node addition on avl tree */
int nnodes=0;
DTNODE *ndptr, *root=NULL;

/* TEST main==>
main(){
	char buf[256];
	int myprint();
	int scantree();
	int scanf();
	int ix(), ntree();
	extern DTNODE *root;
	while (scanf("%s", buf) != EOF)
		printf("indx=%d\n", ix(buf) );
	printf("\nTREEDUMP:\n"); 
	printf("scantre=%d\n", scantree( myprint ));
	printf("ntree()=%d\n", ntree());

}
int myprint(str, indx)
char *str;
int indx;
{
	printf("skey=%-20s key=%2d\n", str, indx);
}
==>END TEST */

int ix(c)
char *c;
{
	ixfind(&root, c);
	return(ndptr->ikey);
}

int ntree()
{
	return(nnodes);
}

int scantree ( routine )	/* set up usr routine for tree perusal */
int (*routine)();
{
	if (root == NULL) /* empty tree */
		return (0);	
	ixtree(root,routine);
	return ( nnodes );
}

ixtree(tree, routine)		/* inorder tree perusal, invoke usr routine */
DTNODE *tree;
int (*routine)();
{
	if (tree->ltd)
		ixtree(tree->ltd, routine);

	(*routine)(tree->skey, tree->ikey);

	if (tree->rtd)
		ixtree(tree->rtd, routine);
}
	
	
ixfind(tree, xcase) 
DTNODE **tree;
char *xcase;
{
	char *strsave();
	int strcmp();
	register DTNODE *p, *p1, *p2; 	/* p=fast root, p1&p2 are for avl bal */
	
	p = *tree; 
	if (p == NULL){			/* notfound, mk a data node */
		GSPACE (p,DTNODE,1);
		ht = true;
		p->skey = strsave(xcase);
		p->ikey = nnodes++;
		p->rtd = p->ltd = NULL;	/* left & rigth ptrs */
		p->bal = 0;
		ndptr = p;
	} /* if */
		
	else if ( (scmp=strcmp ( p->skey, xcase)) > 0) {
		ixfind (&((*tree)->ltd), xcase);
		if ( ht ) {	/* lft branch higher */
			switch ( p->bal ) {
				case 1 :
					p->bal = 0;
					ht = false;
					break;
				case 0 :
					p->bal = -1;
					break;
				case -1 : {
					p1 = p->ltd;
					if( p1->bal == -1 ){	/* ll rotate */
						p->ltd = p1->rtd;
						p1->rtd = p;
						p->bal = 0;
						p = p1;
					}
					else {		/* doubl lr rotate */
						p2 = p1->rtd;
						p1->rtd = p2->ltd;
						p2->ltd = p1;
						p->ltd = p2->rtd;
						p2->rtd = p;
						if (p2->bal == -1)
							p->bal = 1;
						else
							p->bal = 0;
						if ( p2->bal == 1)
							p1->bal = -1;
						else
							p1->bal = 0;
						p = p2;
					} /* else */
					p->bal = 0;
					ht = false;
					break;
				} /* case -1 */
			} /* switch */
		} /* if ht */
	} /* else */
						
	else if (scmp < 0) {
		ixfind (&((*tree)->rtd), xcase);
		if ( ht ) {	/* rt branch higher */
			switch ( p->bal ) {
				case -1:
					p->bal = 0;
					ht = false;
					break;
				case 0:
					p->bal = 1;
					break;
				case 1: {
					p1 = p->rtd;
					if ( p1->bal == 1) {
						p->rtd = p1->ltd;
						p1->ltd = p;
						p->bal = 0;
						p = p1;
					} 
					else {
						p2 = p1->ltd;
						p1->ltd = p2->rtd;
						p2->rtd = p1;
						p->rtd = p2->ltd;
						p2->ltd = p;
						if ( p2->bal == 1)
							p->bal = -1;
						else
							p->bal = 0;
						if ( p2->bal == -1 )
							p1->bal = 1;
						else
							p1->bal = 0;
						p = p2;
					} /* else */
					p->bal = 0;
					ht = false;
					break;
				} /* case +1 */
			} /* switch */
		} /* if rt higher */
	} /* else */
	else{				/* found */
found:
		ht = false;
		ndptr = p;		/* set global node ptr to found node */
	}
	*tree = p;	/* set root to register tmp root */
}
