
#include <stdio.h>

/* number of words to alloc per block */
#define BIGALLOC 8192
#define SMALLALLOC 512

unsigned int allocsiz = BIGALLOC;

struct datalist {	/* link list of data areas for later freeing */
	char *data;
	struct datalist *next;
};

struct datalist *head=NULL;
char *dataptr=NULL, *end_data=NULL;

#define WORDSIZ 2

char *myalloc(n)
int n;
{
	static struct datalist *tmp;
	unsigned int one=1;
	char *calloc();

	n += (n % WORDSIZ);

	if (dataptr + n >= end_data){
			/* get node for link list */
		if (!(tmp=(struct datalist *) calloc(one,sizeof(*tmp))))
			return(NULL);

			/* get a data block */
tryagain:
		if ((dataptr=calloc(allocsiz, sizeof(char))) == NULL) {
			if ( allocsiz == SMALLALLOC )
				return(NULL);
			allocsiz = SMALLALLOC;	/* try again, but less space */
			goto tryagain;
		}


		end_data = dataptr + allocsiz; /* ptr to end of data area */
		tmp->data = dataptr;	/* save addr of data area */
		tmp->next = head;	/* link */
		head = tmp;
	}

	dataptr += n;		/* parcel out pieces of space blocks */
	return(dataptr - n);
}

myfree(){
	struct datalist *tmp;

	while(head){
		cfree(head->data);	/* dump the data area */
		tmp = head;		/* get ready for dissapearing act */
		head = head->next;	/* new head */
		cfree((char *) tmp);		/* dissapear */
	}
	dataptr = end_data = NULL;
	allocsiz = BIGALLOC;
}
