/* specialized parser for the herbarium data base. fast, but good for
	FS=| only. fparse has a compliment function called unfparse */

#include <stdio.h>
#define EOS ('\0')
#define NL ('\n')
#define NO 0
#define YES 1
#define SEP ('|')
#define BLANK (' ')

		/* HANDY TESTER 
main() {
	int  k, nf, fparse();
	char buf[1024], *bp[50];

	while ( (nf = fparse(stdin, buf, bp)) != EOF){
		printf("fields=%d\n", nf);
		for (k=0; k<nf; k++)
			if ( *bp[k] )
				printf("%s\n",bp[k]);
			else
				printf("(n)\n");

		printf("\n");
	}
}
	  END TESTER */

int fparse(fp, str, split)
FILE *fp;
char *str, **split;
{
	register int startfld=YES, blank=YES;
	register char **bp;

	bp = split;
	while (( *str = getc(fp) ) != EOF){
		if (startfld)
			*bp++ = str;
		switch (*str) {
			case NL: *str = EOS;
				 *bp = NULL;		/* nf+1 bufptr null */
				 if ( blank )		/* null line */
					return(0);
				 return (bp-split);
			case SEP:
				*str = EOS;
				if ( blank )		/* at least one fld */
					blank = NO;
				startfld = YES;
				break;
			default:
				if ( blank && *str != BLANK)
					blank = NO;
				startfld = NO;
		}	/* sw */
		++str;
	}
	return ( EOF );
}
