.globl	ioerr,ioeof
indir	=	0
/
/ copyright 1972 bell telephone laboratories inc.
/

/ io3 --  Fortran I/O

.globl	getbuf
.globl	chkunit
.globl	creatf
.globl	openf
.globl  updatef

setio:
	mov	r1,unit
	jsr	r5,chkunit
	movb	utable(r1),r0
	beq	1f
	bpl	2f
	mov	r1,r0
	asl	r0
	mov	btable(r0),r0
	mov	r0,r2
	br	4f
2:
	cmp	(r5),r0
	beq	3f
	jsr	r5,rerr; 101.		/ inconsistent use of unit
	sys	exit
1:
	clrb	filnam		/no name given
	jsr	r5,getbuf
	mov	$filnam,r0
4:
	jsr	r5,chkasn		/check if assigned on cmd
	movb	(r5),utable(r1)
	bit	$1,(r5)
	bne	2f
	jsr	r5,creatf
	br	3f
2:
	bit	$2,(r5)		/test if indexed
	bne	2f		/yes
	jsr	r5,openf
3:
	tst	(r5)+
	asl	r1
	mov	btable(r1),buffer
	rts	r5

2:
	jsr	r5,updatef
	br	3b

/
/ open random access file for update
/ first try an open for update, if that fails,
/ if reason was permission, then try opening for reading,
/ otherwise do a
/ creat, close, then try the open for update again
/
updatef:
	mov	r0,0f		/file name
	sys	indir;1f	/try an open
.data
1:	sys	open; 0: 0; 2	/for update
.text
	jcc	openok		/got it
/
	mov	0b,0f		/copy name
	cmp	r0,$13.		/no permission?
	bne	2f		/something else, try creat
	sys	indir; 3f	/try opening for reading
	bcs	5f		/oops, no good
	jbr	openok
.data
3:	sys	open; 0: 0; 0	/for reading
.text
2:	mov	0b,0f		/copy name
	sys	indir; 2f	/creat it
.data
2:	sys	creat; 0: 0; 666	/create it
.text
	bcs	5f
	sys	close		/close fdes from creat
	sys	indir; 1b	/open it again
	jcc	openok
/ give up, cannot open it
5:	jsr	r5,ioerr; 118.	/can't open random file
	rts	r5		/just in case
/
/ get a buffer.
/ (1) scan for an un-used buffer (utable entry=0)
/ (2) get space for buffer from system (via sbrk)
/
getbuf:
	mov	r1,r0
	asl	r0
	mov	btable(r0),r2
	bne	5f		/already got a buffer
	mov	$utable,r0
	mov	$btable,r2
1:
	tstb	(r0)+
	beq	2f
	tst	(r2)+
	br	3f
2:
	tst	(r2)+
	beq	3f
	mov	-(r2),r0
	clr	(r2)
	mov	r0,r2
	br	2f
3:
	cmp	r0,$utable+20.
	blo	1b
/ no unused buffer, get one via sbrk
	mov	r1,-(sp)
	mov	buflen,-(sp)
	.globl	_sbrk
	jsr	pc,_sbrk	/get space
	tst	(sp)+
	mov	r0,r2
	mov	(sp)+,r1
2:
	mov	r1,r0
	asl	r0
	mov	r2,btable(r0)
5:
	mov	r2,buffer
	rts	r5

chkunit:
	cmp	r1,$20.
	blo	1f
	jsr	r5,rerr; 100.		/ illegal unit number
	sys	exit
1:
	rts	r5

/ open for output file pointed to by r0
/ if @r0 = '!' then create pipe to it
/ if (r0) = '>' then append to the end of the file
creatf:
	cmpb	$'+,(r0)	/asa?
	bne	0f		/nope
	mov	$1f,r0		/use !asa
.data
1:	<!asa\0>
.even
.text
0:
	cmpb	$'!,(r0)
	bne	2f
	inc	r0
	jsr	r5,cpipef
	br	1f
2:
	cmpb	$'>,(r0)
	bne	2f
/
/ >file: open file for writing at the end
/ if file does not exist, then creat it
/
	inc	r0
	jsr	r5,appendf
	bcc	1f		/all set
2:
	tstb	(r0)		/test if file given
	bne	2f
	mov	$1,r0
	br	1f
2:
	mov	r0,0f
	sys	indir;7f
.data
7:	sys	creat; 0:..; 666
.text
	bec	1f
	jsr	r5,ioerr; 102.		/ create error
	sys	exit
1:
	mov	r2,-(sp)
	beq	1f		/no buffer
	mov	r0,(r2)+
	clr	(r2)+
	clr	(r2)+
	mov	r2,-(r2)
1:	mov	(sp)+,r2
	rts	r5

/ open file for writing. if it exists seek to the end
/ otherwise return with C bit set
appendf:
	mov	r0,-(sp)	/save initial r0
	mov	r0,2f
	sys	indir;1f
.data
1:	sys	open; 2: 0
.text
	bcs	1f		/oops, didn't open ok
	mov	r0,(sp)		/save file des

	mov	$2,-(sp)	/how = relative to end of the file
	clr	-(sp)		/pos = 0
	clr	-(sp)
	mov	r0,-(sp)	/set r0
.globl	lseek
	jsr	pc,lseek	/use lseek
	add	$8.,sp		/pop stack
	cmp	$-1,r0
	bne	1f		/normal exit

	jsr	r5,ioerr; 97.	/seek failed on open for append
1:
	mov	(sp)+,r0	/return appropriate r0
	rts	r5
/ open file (or pipe) for input 
openf:
	cmpb	$'!,(r0)
	bne	2f
	inc	r0
	jsr	r5,ipipef
	br	1f
2:
	tstb	(r0)	/test if file given
	bne	2f
	clr	r0
	br	1f
2:
	mov	r0,0f
	sys	indir;7f
.data
7:	sys	open; 0:..; 0
.text
	bec	1f
	jsr	r5,ioerr; 103.		/ open error
	sys	exit
1:
openok:
	mov	r2,-(sp)
	mov	r0,(r2)+
	clr	(r2)+
	clr	(r2)+
	mov	(sp)+,r2
	rts	r5

fputc:
	mov	r1,-(sp)
	mov	buffer,r1
	dec	2(r1)
	bge	1f
	mov	r0,-(sp)
	jsr	pc,flush1
	dec	2(r1)
	mov	(sp)+,r0
1:
	movb	r0,*4(r1)
	inc	4(r1)
	mov	(sp)+,r1
	rts	r5

fflush:
	mov	r1,-(sp)
	mov	buffer,r1
	jsr	pc,flush1
	mov	(sp)+,r1
	rts	r5

flush1:
	mov	r1,r0
	add	$6,r0
	mov	r0,-(sp)
	mov	r0,0f
	neg	r0
	add	4(r1),r0
	bhis	1f
	mov	r0,0f+2
	beq	1f
	mov	(r1),r0
	bpl	6f
	jsr	r5,*strio
6:
	sys	indir;7f
.data
7:	sys	write; 0:..; ..
.text
	bes	2f		/write error
1:
	mov	(sp)+,4(r1)
	mov	linelen,2(r1)
	rts	pc
2:	jsr	r5,ioerr; 113.		/write error
	br	1b

fgetc:
	inc	col
	tst	nlflg
	bne	4f
	mov	r1,-(sp)
	mov	buffer,r1
	dec	2(r1)
	bge	1f
	mov	r1,r0
	add	$6,r0
	mov	r0,0f		/set buff pointer
	mov	r0,4(r1)
	mov	linelen,0f+2	/set read length
	mov	(r1),r0
	bpl	6f
	jsr	r5,*strio	/string io
6:
	sys	indir;7f
.data
7:	sys	read; 0:..; 128.
.text
	bes	2f
	tst	r0
	bne	3f
2:
	jsr	r5,ioeof; 104.		/ EOF on input
	sys	exit
3:
	dec	r0
	mov	r0,2(r1)
1:
	clr	r0
	bisb	*4(r1),r0
	inc	4(r1)
	mov	(sp)+,r1
	tst	binflg
	bne	1f
	cmp	r0,$'\n
	bne	1f
4:
	mov	pc,nlflg
	mov	$' ,r0
	inc	nspace
1:
	rts	r5

gnum:
	cmpb	$'?,*formp	/quest??
	beq	gquest
	mov	r1,-(sp)
	clr	r1
1:
	jsr	r5,fmtchr
	cmp	r0,$'  /
	beq	1b
	sub	$'0,r0
	cmp	r0,$9.
	bhi	1f
	mpy	$10.,r1
	add	r0,r1
	br	1b
1:
	mov	r1,r0
	mov	(sp)+,r1
	dec	formp
	rts	r5

/ found a ? instead of a number, get value of next argument instead
gquest:
	inc	formp
	jsr	r5,getitm
		br	1f
	jsr	r5,getarg
	movfi	r0,r0
	tst	nflg
	beq	0f
	neg	r0
	clr	nflg
0:
	rts	r5
1:	jbr	err1

switch:
	mov	(r5)+,r1
1:
	tst	(r1)
	beq	1f
	cmp	r0,(r1)+
	bne	1b
	tst	(sp)+
	jmp	*(r1)
1:
	rts	r5

fmtchr:
	movb	*formp,r0
	inc	formp
	rts	r5

getitm:
	tst	itmflg
	bne	1f
	mov	r5,-(sp)
	jmp	*(r4)+
1:
	clr	itmflg
	tst	(r5)+
	rts	r5

/ just a fake, there's no carriage control

fputcc:
	inc	col		/count columns
	cmp	$' ,r0
	bne	1f
	inc	nspace
	rts	r5
1:
	mov	r0,-(sp)
1:
	dec	nspace
	blt	1f
	mov	$' ,r0
	jsr	r5,fputc
	br	1b
1:
	clr	nspace
	mov	(sp)+,r0
	beq	1f
	jsr	r5,fputc
1:
	rts	r5

eorec:
	clr	col
	clr	nspace
	tst	rdflg
	bne	1f
	mov	$'\n,r0
	jsr	r5,fputc
eorec1:
	clr	r0
	jsr	r5,fputcc
/	cmp	unit,$6			/ tty output
/	bne	2f
	jsr	r5,fflush
2:
0:
	clr	col
	clr	nspace
	rts	r5
/ end of input line
1:
	tst	nlflg
	bne	1f
	jsr	r5,fgetc
	br	1b
1:
	clr	nlflg
	br	0b

spaces:
	add	r1,nspace
	add	r1,col
	rts	r5

/
/ put character back into the buffer
/
fungetc:
	dec	col
	mov	buffer,r1
	tst	(r1)+
	inc	(r1)+	/count
	dec	(r1)	/ptr
	rts	r5
