#
#define	MAXBUFF	128	/* the buffer size */

#define	BCKERR	93
#define	SEEK_RELATIVE	1
#define	SEEK_ABS	0
#define	SEEK_EOF	2
#define	NL	'\n'

#define	read(a,b,c) _indir(a,3,b,c)
#define	seek(a,b,c) _indir(a,19,b,c)

/*
 * Backspace routine for Fortran I/O
 * written in C for simplicity.
 */
struct iobuf
{
int fdes;		/* the file descriptor */
int nleft;		/* number of chars in the buffer */
char *buffp;		/* buffer pointer */
char buffer[MAXBUFF];	/* the actual buffer */
};

_bcksp(bp,unit) char *bp;
{
/*
 * for now, just scan backwards thru the buffer looking for
 * the NL that terminates the record we are looking for.
 * when it is found advance past it so that we can read
 * that record next.
 * only usable for input at the moment.
 */
register char *b;
register int c;

b = bp;
c = _bckgc(b);		/* get previous character */
if (c != NL)
	return(BCKERR);		/* return the error code */
while ((c = _bckgc(b)) != NL)
	if (c < 0)
		return(BCKERR);
--b->nleft;		/* consume the NL */
++b->buffp;
return(0);		/* all ok */
}

_bckgc(bp) char *bp;
{
register char *b;
register int n;

b = bp;
n = b->buffp-b->buffer;		/* # of characters in buffer */
if (n <= 0)
	{
	n = b->nleft;
	if (n == 0)
		return(-1);	/* no read was done */
	if (seek(b->fdes,-(n+MAXBUFF),SEEK_RELATIVE) < 0)
		return(-1);
	n = read(b->fdes,b->buffer,MAXBUFF);
	if (n <= 0)
		{
		seek(b->fdes,0,SEEK_ABS);
		return(-1);
		}
	b->nleft = 0;
	b->buffp = b->buffer+n;
	}
++b->nleft;
return(*--b->buffp);
}
