#
/*
 * FS2FS  FS to FS tape "copy" program
 */
#define OFF	0
#define ON	1
#define EMPTY	2
#define MAGIC   0123456
#define VERBOSE	(!terse)
#define CPLEN 4096
#define DIRLEN  sizeof(pdir)

#define WTM 0
#define FSF 1
#define BSF 2
#define FSR 3
#define BSR 4
#define REW 5

#define OLDTDATE0 05456	/* To accommodate old FS Tapes */
#define OLDTDATE1 0120157

#define SAVE	1
#define LIST	2
#define STOP	3
#define INIT	4
#define REWIND	5
#define UNIX	6
#define PRESERVE 7
#define HELP	8
#define LPLIST	9
#define SLIST	10
#define SORTLIST 11
#define SET	12

#define PEX 0
#define PER 1
#define PFX 2
#define PFR 3

char *cmds[]
	{"save","list","stop","init","rewind","unix",
	"preserve","help",
	"lplist","slist","sortlist","setdate",0};

char	*labelname	" Label/directory: ";
char	trouble[]	"Trouble. Retry.\n";
char	failed[]	"Failed 5 tape positioning attempts. Your baby.";
char	expect[]	"Expected DIRLEN. got %d bytes\n";
char    labl[16];
char	labl2[16];
char	*tapename	"/dev/rmt?";
char	*tape2name	"/dev/rmt#";
char	*timename;
char	*argpp[32];
char	**argp;
char	*dirname;
char	*dir2name;
int	dir;
int	tape;
int	dir2;
int	tape2;
int	argc;
char	argl[160];
char	lastch;
int	terse;
int	filecnt;
int	file2cnt;
int	labeled;
int	lab2ed;
int	needir;
int	need2dir;
int     update 1;
char	*cpbuf;
int	tapeposn;
int	tape2posn;
int	oldtdate[2];	/* Old Tapes */
int	reset();
int	dirinum[2];
char	*dbuf;
char	*corend;
int	subing;
int	orig;
int	added;
int	freshstart 1;
int	dsw;
int	skipobjs;
int	based;
int	basedtime[2];
char	subdat[58];
char	*exstring;
int	subtab[12][2];
int	sizelimit;

struct	nmstr {
	int c_mrecnt;
	char c_name[];
	};

struct ldirstr	{
	int	d_magic;
	int	d_no;
	char	d_name[58];
	char	d_ids[2];
	int	d_sdate[2];
	int	d_vers;
	int	d_mdate[2];
	int	d_flags;
	int	d_size[2];
	};

struct cdirstr	{
	int	c_magic;
	int	c_no;
	char	c_ids[2];
	int	c_sdate[2];
	int	c_vers;
	int	c_mdate[2];
	int	c_flags;
	int	c_size[2];
	struct	nmstr *c_nmloc;
	char	*c_next;
	};

struct	ldirstr pdir;
struct  ldirstr p2dir;
struct  cdirstr *gdir;
struct  cdirstr *dbufptr;

main(argcc,argv)						/* main */
char **argv;
{
	register file;
	char cppbuf[CPLEN];
	cpbuf = cppbuf;


	if(argcc < 3) error(PFX,"Not enough args\n");

	argv++;
	--argcc;
	tapename[8] = **argv++;
	--argcc;
	if(numrc(*argv)) {
		tape2name[8] = **argv++;
		--argcc;
		goto nn;
	}
	dirname = *argv++;
	--argcc;
	tape2name[8] = **argv++;
	--argcc;
	nn:
	if(argcc > 0 && !eq(*argv,"-b")) {
		dir2name = *argv++;
		--argcc;
	}
	if(argcc > 0) {
		timename = argv[1];
		based++;
		if((file = open(argv[1],0)) < 0) error(PEX,argv[1]);
		read(file,basedtime,4);
		close(file);
	}
	setexit();
	if(freshstart) startup();
	buffer(EMPTY);

	for(;;) {
		signal(2,reset);
		signal(3,0);
		terse = dsw = skipobjs = sizelimit = subing = 0;
		update = 1;
		write(1,"= ",2);
		if(!(argc=getline())) continue;
		switch(cmd()) {

			case	SAVE:
				chkargs();
				if(argc < 2) break;
				if(argc==2)argp[2]=argp[1];
				locat(argp[1]);
				save(OFF,argp[1],argp[2]);
				break;

			case	PRESERVE:
				chkargs();
				preserve();
				break;

			case	LIST:
				buffer(ON);
				list();
				buffer(OFF);
				break;

			default:
				write(1,"Invalid command\n",16);
				break;

			case	STOP:
				exit();

			case	INIT:
				init();
				break;

			case	UNIX:
				signal(2,1);
				signal(3,1);
				if(fork()) while(wait()>=0);
				else {
					close(dir);
					close(dir2);
					close(tape);
					close(tape2);
					execl("/bin/sh","sh",0);
					exit();
				}
				break;

			case	LPLIST:
				lplist();
				break;

			case	SLIST:
			case	SORTLIST:
				slist();
				break;

			case	SET:
				setdate();
				break;

		}
	}
}

startup()							/* startup */
{
	int blanktp;
	struct ldirstr tdir;

	freshstart = blanktp = 0;
	if((dbuf = dbufptr = gdir = sbrk(4096)) < 0) error(PEX,"sbrk");
	corend = sbrk(0);
	oldtdate[0] = OLDTDATE0;	/* Old Tapes */
	oldtdate[1] = OLDTDATE1;

	if((tape = open(tapename,0)) < 0) error(PEX,tapename);
	if((tape2 = open(tape2name,2)) < 0) error(PEX,tape2name);

	rew(tape);
	rew(tape2);
	if(read(tape,&tdir,DIRLEN) < DIRLEN) error(PFX,"Trouble reading %s\n",tapename);
	if(keywd(labelname,tdir.d_name)) labeled++;
	if(!dirname && labeled) {
		cp(tdir.d_name+18,labl);
		dirname = labl;
	}  else if(!dirname) dirname = "fs.dir";
	if((dir = open(dirname,0)) < 0) {
		close(creat(dirname,0666));
		if((dir = open(dirname,2)) < 0) error(PEX,dirname);
		needir++;
	}
	if(!needir) {
		if(read(dir,&pdir,DIRLEN) < 0) error(PEX,dirname);
		if(!eq(tdir.d_name,pdir.d_name)
			|| dpcmp(tdir.d_mdate,pdir.d_mdate) || dpcmp(tdir.d_sdate,pdir.d_sdate))
				error(PFX,"Input tape and directory don't match\n");
	}

	if(read(tape2,&tdir,DIRLEN) < DIRLEN) {
		printf("Output appears empty, type 'y' to confirm  ");
		if(!getline() || argp[0][0] != 'y') exit();
		blanktp++;
	}
	if(keywd(labelname,tdir.d_name)) lab2ed++;
	if(!dir2name && !blanktp) if(lab2ed) {
		cp(tdir.d_name+18,labl2);
		dir2name = labl2;
	}
	if(!dir2name && !blanktp) dir2name = "fs.dir";
	if(!dir2name) askdname();
	if(eq(dirname,dir2name)) error(PFX,"Both directorys cannot have same name: %s = %s\n",dirname,dir2name);
	if((dir2 = open(dir2name,2)) < 0) {
		close(creat(dir2name,0666));
		if((dir2 = open(dir2name,2)) < 0) error(PEX,dir2name);
		need2dir++;
	}
	if(!need2dir && !blanktp) {
		if(read(dir2,&pdir,DIRLEN) < DIRLEN) error(PFX,"Trouble reading %s\n",dir2name);
		if(!eq(tdir.d_name,pdir.d_name)
			|| dpcmp(tdir.d_mdate,pdir.d_mdate) || dpcmp(tdir.d_sdate,pdir.d_sdate))
				error(PFX,"Output tape and directory don't match\n");
	}
	if(blanktp && !need2dir) error(PFX,"Good directory for blank tape?? Sorry.\n");
	if(blanktp) label();
	rew(tape);
	rew(tape2);
	if(needir) tapesearch();
	else dircnt();
	if(!blanktp && need2dir) tape2search();
	else if(!blanktp) dir2cnt();
}

dircnt()                                                         /* dircnt */
{
	register len;

	seek(dir,0,0);
	filecnt = gdir = 0;

	while((len=read(dir,&pdir,DIRLEN))>0) if(pdir.d_magic != MAGIC) {
		error(PFX,"Can't find MAGIC, file number %d\n",filecnt+1);
	} else packdir();
	if(len < 0) error(PEX,dirname);
	if(len > 0) error(PFX,"Directory file not multiple of dirlen\n");
	printf("%d files on input tape\n",filecnt);
	return(1);
}

getline()							/* getline */
{
	register char *line, **ptr, i;

	lastch = 0;
	argp = argpp;
	line=argl;
	for(i=0;i<32;)argp[i++]=0;
	ptr=argp;

	while((*line++ = getch())!='\n');
	if(line > argl+1) if(!(*(line =- 2))) *line = '\n';
	if(*argl == '\n') return(0);
	line=argl;
	do {
		*ptr++ =line;
		while(*line!=0 && *line !='\n')line++;
	} while(*line++!='\n');
	*--line=0;
	return(ptr - argp);
}

getch()								/* getch */
{
	char c;

	do {
		if(read(0,&c,1) <= 0) exit();
		if(c == '\\') {
			if(read(0,&c,1) <= 0) exit();
			if(c == '\n') c = ' ';
		}
	} while(c==' ' && lastch==0);
	if(c==' ')c=0;
	return(lastch=c);
}

cmd()								/* cmd */
{
	char **c;

	c=cmds;
	while(*c) if(keywd(argp[0],*c++))return(c-cmds);
	return(0);
}

keywd(ar,cm)							/* keywd */
{
	register char *a, *c;

	a = ar;
	c = cm;

	while(*a++ == *c && *c++);

	return(!*--a);
}

chkargs()							/* chkargs */
{
	while(argc > 1 && argp[1][0] == '-') {
		if(keywd(argp[1],"-ask")) dsw++;
		else if(keywd(argp[1],"-objects")) skipobjs++;
		else if(keywd(argp[1],"-terse")) terse++;
		else if(keywd(argp[1],"-update")) update = 0;
		else if(keywd(argp[1],"-sub")) setsub();
		else if(argp[1][1] == '+' || argp[1][1] == '-') getsize(argp[1]);
		argp++;
		--argc;
	}
}

list2()								/* list2 */
{
	register char *pattern;
	int tvec[2], nulint[2], i;
	register size, t;
	char tba[16];
	char tbb[16];
	extern ldivr;

	if(!file2cnt) return;
	tba[0] = tbb[0] = nulint[0] = nulint[1] = 0;
	time(tvec);
	i = 1;
	if(argc > 1 && keywd(argp[1],"-long")) {
		--argc;
		argp++;
	}
	if(argc > 1 && keywd(argp[1],"-terse")) {
		argp++;
		--argc;
		terse++;
	}
	if(VERBOSE && argc == 1)
		printf(" No.   Name                          Vers  Size  Date Saved       Last Modified\n");
	do	{
		seek(dir2,0,0);
		pattern=argp[i++];
		for(t= -1; ++t<file2cnt && (read(dir2,&p2dir,DIRLEN) == DIRLEN);) {
			if(pattern && !match(p2dir.d_name,pattern))continue;
			if(VERBOSE){
				size=ldiv(p2dir.d_size[0],p2dir.d_size[1],512);
				if(ldivr)size++;
				if(dpcmp(p2dir.d_sdate,oldtdate)<0 || dpcmp(p2dir.d_sdate,tvec)>0)	/* Old Tapes */
					tba[0]=0;
				else cctime(ctime(p2dir.d_sdate),tba);
				if(!t && lab2ed)
					tbb[0] = 0;
				else cctime(ctime(p2dir.d_mdate),tbb);
				printf("%4d %-32.32s %3d %4d  %15.15s  %s\n",
					t,p2dir.d_name,p2dir.d_vers,size,tba,tbb);
			} else printf("%4d %s(%d)\n",t,p2dir.d_name,p2dir.d_vers);
		}
	} while(i < argc);
}

cctime(cline,tline)						/* cctime */
char *cline, *tline;
{
	register char *tc, *tl;
	tc=cline;
	tl=tline;
	tc =+ 8;
	*tl++ = *tc++;
	*tl++ = *tc;
	*tl++ = ' ';
	tc =- 5;
	*tl++ = *tc++;
	*tl++ = *tc++;
	*tl++ = *tc;
	*tl++ = ' ';
	tc =+ 5;
	*tl++ = *tc++;
	*tl++ = *tc++;
	*tl++ = *tc++;
	*tl++ = *tc++;
	*tl++ = *tc;
	*tl++ = ' ';
	tc =+ 7;
	*tl++ = *tc++;
	*tl++ = *tc;
	*tl = 0;
	return(tline);
}

save(up,tosave,saveas)						/* save */
char *tosave, *saveas;
{
	int tvec[2];
	int intg, len, t, sign;
	struct { char lo; char hi; };
	struct ldirstr tdir;
	register fildes, size, fsferr;
	extern ldivr;
	fsferr = 0;
	if(labeled && gdir->c_no == 0) return;
	pdir.d_vers = getvers(saveas);
	again:
	posn(tape,gdir->c_no);
	if((t=read(tape,&tdir,DIRLEN))!=DIRLEN) error(PEX,tapename);
	if(dpcmp(gdir->c_mdate,tdir.d_mdate) || dpcmp(gdir->c_sdate,tdir.d_sdate)) {
		if(gdir->c_no != tdir.d_no) {
			if(fsferr++ > 4) error(PFR,failed);
			bsf(5);
			t=read(tape,&tdir,DIRLEN);
			if(t != DIRLEN || tdir.d_magic != MAGIC) {
				rew();
				error(PFR,trouble);
			}
			tapeposn=tdir.d_no;
			goto again;
		} else error(PFR,"Directory not for input tape\n");
	}
	if(sizelimit) {
		if(sizelimit > 0) sign = 1;
		else sign = -1;
		size = ldiv(gdir->c_size[0],gdir->c_size[1],512);
		if(ldivr) size++;
		size =* sign;
		if(size > sizelimit) {
			if(VERBOSE) printf("%s: size\n",tosave);
			return;
		}
	}
	if(skipobjs) {
		if((len = read(tape,cpbuf,CPLEN)) < 0) error(PEX,tapename);
		if(len == 0) {
			if(VERBOSE) printf("%s: zero length\n",tosave);
			tapeposn++;
			return;
		}
		intg.lo = cpbuf[0];
		intg.hi = cpbuf[1];
		if(intg == 0407 || intg == 0410 || intg == 0411 || intg == 01) {
			if(VERBOSE) printf("%s: object\n",tosave);
			fsf(tape,1);
			return;
		}
	}
	if((based && dpcmp(basedtime,gdir->c_mdate) > 0) ||
		(up && pdir.d_vers > 1 && dpcmp(gdir->c_mdate,p2dir.d_mdate) <= 0)){
			if(VERBOSE) printf("Not updated: %s\n",tosave);
			return;
	}
	if(dsw && !dswask(tosave,gdir->c_vers)) return;
	cp(saveas,pdir.d_name);
	pdir.d_magic=MAGIC;
	pdir.d_no=file2cnt;
	pdir.d_ids[0] = gdir->c_ids[0] ;
	pdir.d_ids[1] = gdir->c_ids[1] ;
	pdir.d_mdate[0]= gdir->c_mdate[0];
	pdir.d_mdate[1]= gdir->c_mdate[1];
	pdir.d_flags= gdir->c_flags;
	pdir.d_size[0]= gdir->c_size[0];
	pdir.d_size[1]= gdir->c_size[1];
	pdir.d_sdate[0] = gdir->c_sdate[0];
	pdir.d_sdate[1] = gdir->c_sdate[1];
	posn(tape2,file2cnt);
	t=read(tape2,&tdir,CPLEN);
	bsr(tape2,1);
	if(t > 0) error(PFR,"Either directory for output tape not current or fsf failed\n");
	if(write(tape2,&pdir,DIRLEN)<DIRLEN) error(PEX,tape2name);
	tp2tp(len);
	putdir();
	added++;
	if(VERBOSE) printf("Copied: %s(%d) as %32.32s(%d)\n",
		tosave,gdir->c_vers,saveas,pdir.d_vers);
}

tp2tp(ln)						/* tp2tp */
{
	register len, i;
	int tot[2];
	signal(2,1);
	tot[0] = tot[1] = 0;
	len = ln;
	if(skipobjs) goto writeit;
	while((len=read(tape,cpbuf,CPLEN))>0){
		writeit:
		if(len != CPLEN)
			if(len < 32) {
				for(i = len; i < 32; i++) cpbuf[i] = 0;
				len = 32;
			} else if(len&1) cpbuf[len++] = 0;
		if(write(tape2,cpbuf,len)!=len){
			rew(tape2);
			error(PER,tape2name);
		}
		dpadd(tot,len);
	}
	if(len<0) error(PER,tapename);
	weot();
	if(dpcmp(tot,pdir.d_size)<0)
		error(PFR,"Failed to read anticipated byte count\n");
	tapeposn++;
	signal(2,reset);
}

error(n,arg1,arg2,arg3,arg4)					/* error */
{
	if(n==PEX || n==PER) {
		perror(arg1);
		if(n==PEX) exit();
		reset();
	}
	buffer(EMPTY);
	printf(arg1,arg2,arg3,arg4);
	if(n==PFX) exit();
	reset();
}

getvers(nam)							/* getvers */
char *nam;
{
	register i;
	register char *n;

	n = nam;
	seek(dir2,0,2);
	seek(dir2,-DIRLEN,1);

	for(i=file2cnt;i;--i) {
		if(read(dir2,&p2dir,DIRLEN) != DIRLEN) error(PEX,dir2name);

		if(eq(p2dir.d_name,n)) return(p2dir.d_vers + 1);

		seek(dir2,-(DIRLEN * 2),1);
	}

	if(!i) return(1);
}

putdir()							/* putdir */
{
	seek(dir2,0,2);

	if(write(dir2,&pdir,DIRLEN) != DIRLEN) error(PEX,dir2name);
	file2cnt++;
}

cp(a,b)								/* cp */
{
	register char *aa, *bb;
	aa=a;
	bb=b;
	while(*bb++ = *aa++);
}

posn(tpn,file)							/* posn */
{
	register tapp;

	if(file==0) {
		rew(tpn);
		return;
	}
	if(tpn == tape) tapp = tapeposn;
	else tapp = tape2posn;
	if(file==tapp) return;
	if(file > tapp) {
		fsf(tpn,file-tapp);
		return;
	}
	if(file<<1 > tapp)
		bsf(tpn,tapp-file);
	else {
		rew(tpn);
		fsf(tpn,file);
	}
}

rew(tpn)								/* rew */
{
	dostty(tpn,REW,1);
	if(tpn == tape) tapeposn = 0;
	else tape2posn = 0;
}

fsf(tpno,n)								/* fsf */
{
	dostty(tpno,FSF,n);
	if(tpno == tape) tapeposn =+ n;
	else tape2posn =+ n;
}

bsf(tpno,n)								/* bsf */
{
	dostty(tpno,BSF,n+1);
	dostty(tpno,FSR,1);
	if(tpno == tape) tapeposn =- n;
	else tape2posn =- n;
}

wtm(tpno,n)							/* wtm */
{
	dostty(tpno,WTM,n);
	if(tpno == tape) tapeposn =+ n;
	else tape2posn =+ n;
}

weot()								/* weot */
{
	dostty(tape2,WTM,3);
	dostty(tape2,BSF,2);
	tape2posn++;
}

bsr(tpno,n)							/* bsr */
{
	dostty(tpno,BSR,n);
}

dostty(tpno,fn,n)						/* dostty */
{
	int arg[3];
	arg[0]=fn;
	arg[1]=n;
	if(stty(tpno,arg) <0) error(PER,tapename);
}

init()								/* init */
{
	register char c;

	printf("Type 'y' to erase output tape ");
	if(!getline() || argp[0][0] != 'y') return;
	needir = file2cnt = orig = 0;
	close(dir2);
	unlink(dir2name);
	askdname();
	close(creat(dir2name,0666));
	dir2=open(dir2name,2);
	gdir = dbufptr = dbuf;
	rew(tape2);
	wtm(tape2,3);
	rew(tape2);
	label();
}

eq(ar,cm)							/* eq */
{
	register char *a, *c;

	a = ar;
	c = cm;

	while(*a++ == *c && *c++);

	return((c != cm) && (!*--a && !*--c));
}

buffer(n)							/* buffer */
{
	extern int fout;
	if(n == ON) fout=dup(1);
	else {
		if(fout <= 1) return;
		if(n == OFF) {
			flush();
			close(fout);
		} else {
			close(fout);
			flush();
		}
		fout=1;
	}
	flush();
}


lplist()							/* lplist */
{
	int pip[2], oldone;
	extern int fout;

	pipe(pip);
	if(fork()) {
		fout=pip[1];
		close(pip[0]);
		list();
		flush();
		close(fout);
		fout=1;
		flush();
	} else	{
		close(0);
		dup(pip[0]);
		close(pip[0]);
		close(pip[1]);
		signal(2,1);
		signal(3,1);
		close(tape);
		close(tape2);
		close(dir);
		close(dir2);
		execl("/bin/lpr","lpr",0);
	}
}

slist()								/* slist */
{
	int pip[2], oldone;
	extern int fout;

	printf("Sorting - ");
	pipe(pip);
	if(fork()) {
		fout=pip[1];
		close(pip[0]);
		list();
		flush();
		close(fout);
		fout=1;
		flush();
		while(wait()>=0);
		printf("Sorted list sent to lpr\n");
		if(!fork()) {
			signal(2,1);
			signal(3,1);
			close(tape);
			close(tape2);
			close(dir);
			close(dir2);
			execl("/bin/lpr","lpr","-r","fs.sort",0);
			printf("Couldn't exec lpr\n");
			exit();
		}
	} else	{
		close(0);
		dup(pip[0]);
		close(pip[0]);
		close(pip[1]);
		close(dir2);
		close(tape);
		close(tape2);
		close(dir);
		signal(2,1);
		signal(3,1);
		execl("/bin/sort","sort","-u","+0.4","-0.36","-o","fs.sort",0);
		exit();
	}
}

setdate()							/* setdate */
{
	register file;
	register char *tname;

	if(argc > 1) tname = argp[1];
	else tname = timename;
	if(tname == 0) error(PFR,"No time-file name\n");
	if((file = creat(tname,0666)) < 0) error(PER,tname);
	time(basedtime);
	write(file,basedtime,4);
	close(file);
}

match(s, p)							/* match */
char *s, *p;
{
	if (*s=='.' && *p!='.')
		return(0);
	return(amatch(s, p));
}

amatch(as, ap)							/* amatch */
char *as, *ap;
{
	register char *s, *p;
	register scc;
	int c, cc, ok, lc;

	s = as;
	p = ap;
	if (scc = *s++)
		if ((scc =& 0177) == 0)
			scc = 0200;
	switch (c = *p++) {

	case '[':
		ok = 0;
		lc = 077777;
		while (cc = *p++) {
			if (cc==']') {
				if (ok)
					return(amatch(s, p));
				else
					return(0);
			} else if (cc=='-') {
				if (lc<=scc && scc<=(c = *p++))
					ok++;
			} else
				if (scc == (lc=cc))
					ok++;
		}
		return(0);

	default:
		if (c!=scc)
			return(0);

	case '?':
		if (scc)
			return(amatch(s, p));
		return(0);

	case '*':
		return(umatch(--s, p));

	case '\0':
		return(!scc);
	}
}

umatch(s, p)							/* umatch */
char *s, *p;
{
	if(*p==0)
		return(1);
	while(*s)
		if (amatch(s++,p))
			return(1);
	return(0);
}

label()								/* label */
{
	int tvec[2];

	gdir = 0;
	rew(tape2);
	signal(2,1);
	signal(3,1);
	lab2ed++;
	cp(labelname,pdir.d_name);
	cp(dir2name,pdir.d_name+18);
	pdir.d_no = pdir.d_size[0] = pdir.d_size[1] = 0;
	pdir.d_vers = 1;
	pdir.d_magic = MAGIC;
	time(tvec);
	pdir.d_sdate[0]=tvec[0];
	pdir.d_sdate[1]=tvec[1];
	if(write(tape2,&pdir,DIRLEN) != DIRLEN) error(PEX,tape2name);
	weot();
	putdir();
}

askdname()							/* askdname */
{
	printf("Enter label/directory name. Suggested format: fs.NAME\n");
	if(!getline()) exit();
	if(keywd(argp[0],"stop")) exit();
	cp(argp[0],labl2);
	dir2name=labl2;
}

getname()                                               /* getname */
{
	register int t;
	register char *n, *o;

	if(gdir || ((dbufptr->c_vers > 1) && findup(pdir.d_name))) {
		dbufptr->c_nmloc = gdir->c_nmloc;
		(dbufptr->c_nmloc)->c_mrecnt = dbufptr->c_no;
		dbufptr = dbufptr->c_next = dbufptr + 1;
		gdir = 0;
		return;
	}

	dbufptr->c_nmloc = dbufptr + 1;
	n = (dbufptr->c_nmloc)->c_name;
	o = pdir.d_name;
	while(*n++ = *o++);
	(dbufptr->c_nmloc)->c_mrecnt = dbufptr->c_no;
	dbufptr = dbufptr->c_next = n + (n&1);
}

preserve()							/* preserve */
{
	register int t, f, mth;
	int all;
	char *new, newpath[58];

	if(argc == 1) all = 1;
	else all = 0;
	added = mth = 0;
	gdir = dbuf;
	for(f=0;f < filecnt;f++) {
		for(t=argc;t > 1 || (all && t-- == 1);)
			if(all || match((gdir->c_nmloc)->c_name,exstring=argp[--t]))
				if(update && (gdir->c_nmloc)->c_mrecnt != gdir->c_no) continue;
				else {
					if(subing) new = makesub((gdir->c_nmloc)->c_name,new);
					else new = (gdir->c_nmloc)->c_name;
					save(update,(gdir->c_nmloc)->c_name,new);
					mth++;
				}
		gdir = gdir->c_next;
	}
	if(!mth) printf("No match\n");
	else printf("%d added, now %d files on output tape\n",added,file2cnt);
}

findup(nam)							/* findup */
char *nam;
{
	register i;
	register struct cdirstr *cd;

	cd = dbuf;

	for(i=filecnt;i;--i)
		if(eq(nam,(cd->c_nmloc)->c_name)) return(gdir = cd);
		else cd = cd->c_next;

	return(0);
}

locat(nam)							/* locat*/
char *nam;
{
	register i;
	register struct cdirstr *cd;

	cd = dbuf;
	for(i=filecnt;i && !eq((cd->c_nmloc)->c_name,nam);--i) cd = cd->c_next;
	if(!i) {
		error(PFR,"%s not on input tape\n",nam);
	}

	i = (cd->c_nmloc)->c_mrecnt;

	while(cd->c_no != i) cd = cd->c_next;
	gdir = cd;
}

dir2cnt()
{
	seek(dir2,0,0);

	for(file2cnt = 0; read(dir2,&p2dir,DIRLEN) == DIRLEN;file2cnt++)
		if(p2dir.d_magic != MAGIC) error(PFX,"Missing magic, file # %d, out directory\n",file2cnt);
	printf("%d files on output tape\n",file2cnt);
}

packdir()							/* packdir */
{
	struct {char c;};
	register int *w, *p, t;

	if(corend - &(dbufptr->c) < 80) {
		if(((t = sbrk(256)) == -1) && ((t = sbrk(128)) == -1)) {
			error(PFR,"Out of memory, file maximum reached\n");
		}
		corend = sbrk(0);
	}
	w = &dbufptr->c_magic;
	p = &pdir;
	*w++ = *p++;	/* copy magic */
	*w = *p;	/* copy file number */
	w = dbufptr->c_ids;
	p = pdir.d_ids;
	for(t = 0; t++ < 9;) *w++ = *p++;
	getname();
	filecnt++;
}

dswask(na,nu)
{
	register char c;

	printf("%s(%d)  ",na,nu);
	c = getch();
	if(c != '\n') while(getch() != '\n');
	if(c == 'y') return(1);
	return(0);
}

numrc(ar)
char *ar;
{
	if((ar[0] >= '0' && ar[0] <= '7') && ar[1] == 0) return(1);
	return(0);
}

tapesearch()						/* tapesearch */
{
	register len, fsferr;

	fsferr = 0;
	gdir = 0;
	printf("Input tape directory update - ");
	rew(tape);
	retry:
	while((len=read(tape,&pdir,DIRLEN))>0) {
		if(len!=DIRLEN) {
			printf(expect,len);
			rew(tape);
			error(PER,tapename);
		}
		if(pdir.d_magic!=MAGIC)
			error(PFX,"Missing magic, filecnt=%d\n",filecnt);
		if(pdir.d_no != filecnt) {
			if(fsferr++ > 4) error(PFR,failed);
			bsf(tape,5);
			len=read(tape,&pdir,DIRLEN);
			bsr(tape,1);
			if(len != DIRLEN || pdir.d_magic != MAGIC) {
				rew(tape);
				filecnt=0;
				error(PFR,trouble);
			}
			filecnt=tapeposn=pdir.d_no;
			goto retry;
		}
		packdir();
		fsf(tape,1);
	}
	if(len<0) {
		rew(tape);
		error(PER,tapename);
	}
	tapeposn++;
	needir=0;
	dumpdir();
	printf("%d files\n",filecnt);
}

tape2search()						/* tape2search */
{
	register len, fsferr;

	fsferr = 0;
	gdir = 0;
	printf("Output tape directory update - ");
	rew(tape2);
	retry:
	while((len=read(tape2,&pdir,DIRLEN))>0) {
		if(len!=DIRLEN) {
			printf(expect,len);
			rew(tape2);
			error(PER,tape2name);
		}
		if(pdir.d_magic!=MAGIC)
			error(PFX,"Missing magic, file2cnt=%d\n",file2cnt);
		if(pdir.d_no != file2cnt) {
			if(fsferr++ > 4) error(PFR,failed);
			bsf(tape2,5);
			len=read(tape2,&pdir,DIRLEN);
			bsr(tape2,1);
			if(len != DIRLEN || pdir.d_magic != MAGIC) {
				rew(tape2);
				file2cnt=0;
				error(PFR,trouble);
			}
			file2cnt=tape2posn=pdir.d_no;
			goto retry;
		}
		putdir();
		fsf(tape2,1);
	}
	if(len<0) {
		rew(tape2);
		error(PER,tape2name);
	}
	tape2posn++;
	need2dir=0;
	printf("%d files\n",file2cnt);
}

dumpdir()							/* dumpdir */
{
	register int *p, *l, t;
	int i;
	char *pp, *ll;

	gdir = dbuf;
	for(p=0;p < orig;p++) gdir = gdir->c_next;
	for(i=orig;i < filecnt;i++) {
		p = &gdir->c_magic;
		l = &pdir;

		*l++ = *p++;
		*l = *p;

		p = gdir->c_ids;
		l = pdir.d_ids;
		for(t=0;t++ < 9;) *l++ = *p++;

		pp = (gdir->c_nmloc)->c_name;
		ll = pdir.d_name;
		while(*ll++ = *pp++);

		gdir = gdir->c_next;
		if(write(dir,&pdir,DIRLEN) < DIRLEN) error(PER,dirname);
	}
	orig = filecnt;
	gdir = 0;
}

list1()								/* list1 */
{
	register char *pattern;
	int longlst;
	int tvec[2], i, nulint[2];
	register size, t;
	char tba[16];
	char tbb[16];
	extern ldivr;

	if(!filecnt) return;
	tba[0] = tbb[0] = nulint[0] = nulint[1] = 0;
	time(tvec);
	if(argc > 1 && keywd(argp[1],"-long")) longlst = 1;
	else longlst = 0;
	if(argc > 1 && keywd(argp[1],"-terse")) {
		--argc;
		argp++;
		terse++;
	}
	i = 1+longlst;
	if(VERBOSE && (argc == 1 || (argc == 2 && longlst)))
		printf(" No.   Name                          Vers  Size  Date Saved       Last Modified\n");
	do	{
		gdir = dbuf;
		pattern=argp[i++];
		for(t= -1; ++t<filecnt;gdir = gdir->c_next) {
			if(pattern && !match((gdir->c_nmloc)->c_name,pattern))continue;
			if(!longlst && (gdir->c_nmloc)->c_mrecnt != gdir->c_no) continue;
			if(VERBOSE){
				size=ldiv(gdir->c_size[0],gdir->c_size[1],512);
				if(ldivr)size++;
				if(dpcmp(gdir->c_sdate,oldtdate)<0 || dpcmp(gdir->c_sdate,tvec)>0)	/* Old Tapes */
					tba[0]=0;
				else cctime(ctime(gdir->c_sdate),tba);
				if(!t && labeled)
					tbb[0] = 0;
				else cctime(ctime(gdir->c_mdate),tbb);
				printf("%4d %-32.32s %3d %4d  %15.15s  %s\n",
					t,(gdir->c_nmloc)->c_name,gdir->c_vers,size,tba,tbb);
			} else printf("%4d %s(%d)\n",t,(gdir->c_nmloc)->c_name,gdir->c_vers);
		}
	} while(i < argc);
}

list()								/* list */
{
	if(!keywd(argp[1],"-input")) {
		list2();
		return;
	}
	argp++;
	--argc;
	list1();
}

setsub()							/* setsub */
{
	register char *a, *sb;
	register t;
	int sti;

	if(argc < 4) error(PFR,"Arg cnt\n");
	for(t = 0;t < 12;) subtab[t++][0] = 0;
	argp++;
	--argc;
	subing++;
	a = argp[1];
	sb = subdat;

	if(*a == '|') a++;
	while((*sb = *a++) && *sb != '|') sb++;
	if(*sb == '|') *sb = 0;
	sti = 0;
	for(t = 2; t < argc; t++) {
		a = argp[t];
		if(*a++ != '|') continue;
		sb = argp[t];
		while((*sb = *a++) && *sb != '|') sb++;
		if(*sb == 0) error(PFR,"Syntax\n");
		subtab[sti][0] = argp[t];
		subtab[sti++][1] = sb - argp[t];
		while(*sb++ = *a++);
	}
}

makesub(matched,new)					/* makesub */
char *matched, *new;
{
	register t;
	register char *a, *n;

	for(t = 0;t < 12; t++) if(exstring == subtab[t][0]) goto go;
	return(matched);

	go:
	a = subdat;
	n = new;
	while(*n = *a++) n++;

	a = matched + subtab[t][1];

	while(*n++ = *a++);

	if(*new == 0) error(PFR,"Very funny\n");
	return(new);
}
getsize(szz)							/* getsize */
char *szz;
{
	register char *sz;
	register sign;

	sizelimit = 0;
	sz = szz;

	sz++;
	if(*sz++ == '+') sign = 1;
	else sign = -1;

	while(*sz) sizelimit = sizelimit * 10 + *sz++ - '0';

	sizelimit =* sign;
}
