#include <stdio.h>
#include <ctype.h>

#define	SPECIAL "\\@ \t,!|'()"	/* not allowed in unquoted argument */
#define	flush() fflush(stdout)
#define	BSLASH	'\\'
#define	DOT	'.'

#define	YES	1
#define	NO	0

char tempfile[32];
char macro[32];
char line[512];
char arg[256];
int uflg;
int done;
char special[128];
char sp_chars[] = { '!', '@', '|', ')', '\'', 0 };
char sp_codes[] = {  51,  46,  33,  40,  42 , 0 };

main(argc,argv) char **argv;
{
register char *argp;
register int i;
/*
 * nroff front end for fmt
 * change nroff macro invokations into fmt macro invokations
 * e.g. .macro arg1 ... argn
 * ==> !macro(arg1,...,argn)
 */

init();
for (i=1; i<argc; ++i)
	{
	argp = argv[i];
	if (*argp == '-')
		{
		switch(argp[1])
			{
		case 'u':
			++uflg;
			break;
		case 'm':
			sprintf(tempfile,"/usr/lib/fmac/tmac.%s",argp+2);
			dofile(tempfile);
			break;
		default:
			printf("%s: option %s ignored\n",argv[0],argp);
			}
		}
	else
		dofile(argp);
	}
if (done == 0)
	doit(stdin);
}

init()
{
register int i, j;
for (i=0; j = sp_chars[i]; ++i)
	special[j] = sp_codes[i];
}


setout();

dofile(name) char *name;
{
register FILE *f = fopen(name,"r");

if (f == (FILE *) NULL)
	err("can't open %s",name);
++done;
doit(f);
fclose(f);
}

doit(f) register FILE *f;
{
register char *n;
char *p;
int i;

while (fgets(line,sizeof line,f))
	{
	i = strlen(line);
	if (i > 0 && line[--i] == '\n')
		line[i] = 0;
	if (line[0] != '.')
		{
		putstr(line,NO);
		printf("\n");
		continue;
		}
	if (line[1] == DOT)
		{		/* .. */
		putstr(line+2,NO);
		printf("\n");
		continue;
		}
		
	for (n=macro,p = line+1; (isalnum(*p)); ++p)
		{
		*n++ = *p;
		if (uflg && isupper(*p))
			*n++ = '.';	/* use . after upper case letters */
		}
	*n = 0;
	printf("!%s",macro);
	for (i=0; getarg(&p,arg); ++i)
		{
		if (i==0)
			printf("(");
		else
			printf(",");
		putarg(arg);
		}
	if (i != 0)
		printf(")");
	printf("\n");
	}
}

getarg(ptr,arg) char **ptr; char *arg;
{
register char *n = *ptr;
register char *p;

while (isspace(*n))
	++n;
if (*n == 0)
	return(0);
p = n;
if (*n == '"')
	{
	++n;
	while (*n && *p != *n)
		*arg++ = *n++;
	}
else
	{
	while (*n && !isspace(*n))
		*arg++ = *n++;
	}
if (*n)
	++n;
*arg = 0;
*ptr = n;
return(1);
}

putarg(str) char *str;
{
if (any(str,SPECIAL))
	{
	printf("'");
	putstr(str,YES);
	printf("'");
	}
else
	printf("%s",str);
}

putstr(str,flag) register char *str;
{
/*
 * flag indicates if we are in the middle of an argument, in which case
 * we will always expand ')' into !nn codes.
 */
register int c;
register int lastc = ' ';

for (; c = *str; lastc = c)
	{
	if (c == ')' && lastc != ' ')
		putchar(*str++);
	else if (c == '\'' && !flag)
		putchar(*str++);
	else if (special[c])
		printf("!%02d",special[*str++]);
	else if (c == '\\')
		{
		++str;
		switch(c = *str++)
			{
		case '\'':
			if (flag)
				printf("!42");
			else
				putchar(c);
			break;
		case '`':
		case '-':
			putchar(c);
			break;
		case '"':
			str = endstr(str);
			break;
		case '(':
			printf("!char.%.2s!",str);
			str += 2;
			break;
		case '*':
			if (*str == '(')
				{ printf("!%.2s!",++str); str += 2; }
			else
				printf("!%c!",*str++);
			break;
		case '&':
		case '|':	/* zero width character */
		case '^':
			break;
		case ' ':
		case '0':
			putchar('~');
			break;
		case '$':
			printf("!par.%c!",*str++);
			break;
		case '.':
			putchar('.');
			break;
		default:
			--str;
			if (isalnum(*str))
				printf("!sp.%c",*str++);
			else
				printf("!sp.%02x",*str++);
			if (index("shv",c) && (*str=='+' || *str=='-' || isdigit(*str)))
				{
				printf("(");
				do
					putchar(*str++);
				while (isdigit(*str));
				printf(")");
				}
			printf("!");	/* trailing macro delimeter */
			c = ' ';	/* force delimeter */
			}
		}
	else
		putchar(*str++);
	}
}
