)rv comment 
set hd = ' )w5l2ru !par.1 )i1p ' 
special keypunch 
TRANSLATE INPUT '_' '_' 
set p = ' )ri1p ' 
set p2 = ' )ri2p ' 
set t = ' )w5l2ri1ph1 ' 
set longex = ' )w5l2ri2a '
set endex = ' '
set it = ' )w5l2ri1o1 !par.1 )i2 '
set sw = ' )w5l2ri1o1 -!par.1 )i2 '
indents (3,0) (6,0) (9,0) 
no page 
paragraph indent 0 
set ex = ' )w5l2ri2o1 !par.1 !p ' 
no listing 
PAGE 
title 
)m UNIX BCPL User's Manual )ml2e 
GO
)s 
!hd(Introduction)
        This  manual  is  to  be  used with the UBC BCPL Manual.  It 
    describes only those things which are different when using  BCPL 
    on the PDP~11 under UNIX. 
    !p  It is important to realize that there are two BCPL compilers 
    at UBC producing code for the PDP~11.  They are: 
!t       1) the standard BCPL compiler running under MTS  which 
         may be coaxed to produce UNIX Assembler code; 
!t       2)  the  compiler running on the PDP~11 under UNIX whose 
         end product is UNIX relocatable binary code. 
!p  The user may find it convenient to do program development on the  370.
     On the other hand, maintenance of BCPL  programs  for 
    the PDP~11 is perhaps most conveniently done using the compiler on 
    the minicomputer. 
!hd('Three Compilers') 
There are currently three BCPL compilers in use at UBC. the most commonly 
used compiler is that of the 370 under MTS. it is also the original source 
of the other two compilers. the other two compilers are quite similar and 
run on the NOVA and the PDP~11 (under UNIX). the code generators for all 
three machines are completely different. 
!p      The compiler on the 370 under MTS is that used by other BCPL 
    users at UBC.  It normally produces code for the 370 but, if the 
    user requests that the MTS compiler produces OCODE or MCODE 
    acceptable to the code generator, and then runs it thru the code generator
    then UNIX Assembler may be produced.
     This can then be transported to the PDP~11  to 
    be assembled, loaded and run. 
!p      The  compiler  on  the PDP~11  under  UNIX also produces UNIX 
    assembler  code,  but  only  as  an   intermediate   step.    It 
    automatically  calls  the PDP~11  assembler and the end result is 
    an executable program produced by assembling and linkeditting the
    assembler produced by the code generator. 
!p      The major  difference  between  the  two  compilers  is  the 
    smaller  memory  size  of  the PDP~11.  This means that large BCPL 
    source programs, when compiled on  the PDP~11,  may  have  to  be 
    broken  into  smaller sections (the maximum tree size is #017400 
    cells). 
!hd('Essential differences') 
        The  user  with  a small single section program will observe 
    little difference between BCPL on the 370 and that on the PDP~11. 
    The  compiler  on  the PDP~11 is essentially a copy of that on the 
 
    370 except for the code generation part.  It must be  remembered 
    however that: 
!p       1) with a 16 bit cell size, integer values on the PDP~11 
         should lie in the range -32768 to 32767; 
!p       2) character encoding on  the PDP~11  is  ASCII  (e.g., 
         'A'=65)  whereas  on  the  370  it  is  EBCDIC  (e.g., 
         'A'=193); 
!p       3) floating point arithmetic is not available with 
         BCPL  on  the PDP~11 and could not be conveniently 
implemented with a 16 bit word size. this is very unfortionate
as it limits BCPL to "systems" applications. 
!p       4) certain recent language extensions now available on 
         the 370 are not available on the PDP~11 (e.g., 
    S +:= 1 may have to be written as S := S + 1.
        The  user  with  a  large  multisection program must observe 
    other differences, which will be explained later. 
!hd('The MTS command')
        The  full  details of this command are given in the UBC BCPL 
    manual.  It is sufficient to say  here  that,  to  produce  UNIX 
    assembler code on the 370, the commands should be: 
!longex
        $RUN CS:BCPL SCARDS=sourceprogram PAR=BOZA 
        $RUN WEB:PDP11GEN SCARDS=-OC#
) !endex
!p  The  UNIX  assembler  will then appear in the MTS file -ASM#.  An 
    intermediate scratch file, -OC#, will also be created. 
!hd('The UNIX BCPL Command') 
        The  UNIX  command for running the BCPL compiler on the PDP~11 
    is 
!longex 
    BCPL -s1 ... -sn bcpl1.b ... bcpln.b 
) !endex 
!p where "-sn" are optional switches whose meanings are given later.
!p "filen.b" are the names of the BCPL source file or files to be compiled.
    example is 
!ex('BCPL -s -S myfile.b > listing ')
    which will compile the BCPL source  program  from  MYFILE.B,  will 
    produce  a program listing in the file LISTING and will save the 
    assembler code in the file MYFILE.S.   The  relocatable  binary 
     will not be produced.
 
!hd(Loading)
        The system command for loading is 
!ex('BCPL file')
    where file is the name of the file containing the  source, object, mcode, assembler or object. 
    the BCPL monitor program will do the appropriate compile, code generation,
    assembly, and linkeditting based on the suffix of the file name. 
the suffixes currently recognized are:
!it(.b) BCPL source file 
!it(.m) mcode interface file 
!it(.s) PDP~11 UNIX Assembler source file 
!it(.o) UNIX object module (a.out) file 
!hd(Switches)
        switches available with  the  command  BCPL 
    are as follows: 
!sw(s) assembler source is produced in the file "source.s". compilation 
 terminates after the source is produced.
!sw(m) mcode source is produced in the file "source.m". compilation 
 terminates after mcode is produced. 
!sw(c) object code is produced in the file "source.o". linkeditting is 
suppressed. 
!sw(S) produce a source listing (normally suppressed) on standard output.
!sw(Q) suppress the source listing (normally the default). error messages 
are still produced, along with the compile statistics. 
!sw(G) disable the GET directive. 
!sw(L) large program; use largest possible work space. 
!p if no switches are specified then the files given are compiled, code
generated, assembled, and linkeditted. the resulting load module is 
in the file "a.out" and may be directly executed. 
!p note that the files "asm", "!47mcode", "source.m", "source.s", "source.o" (where "source.b" is the BCPL source file), and "a.out" 
are produced by the BCPL compiler, and are normally deleted (except for a.out)
after use. 
!hd('Files and Streams')
UNIX file descriptors are used directly as BCPL streams. This means that 
upon startup of a BCPL program streams 0, 1, and 2 are in existence. opening
files will create file descriptors greater than 2. 
!p BCPL strings used as file names are translated to lower case and any 
trailing blanks are removed. this is done on a )u copy )u of the string 
passed to the library routines. 
!hd('the Library')
        The major part of the library which interfaces with UNIX  is 
    written  in  BCPL.   This enables the user to clarify an obscure 
    point by examining the source code.  The following are the  only 
    library  routines  written  in  UNIX  assembler: APTOVEC, LEVEL, 
    LONGJUMP, and  UNIX. 
!p      The following  is  a  list  of  those  library  routines  or 
    functions  that are available in BCPL under UNIX.  The action of 
    most of them is similar to their counterparts under MTS,  except 
    for  the  remarks  noted above.  Those whose action is otherwise 
    different or are unknown under MTS are described in full. 
!longex
 APTOVEC(F,N)       WRITES(S)           INPUT() 
 LEVEL()            WRITED(N,D)         OUTPUT() 
 LONGJUMP(P,L)      WRITEN(N)           FINDINPUT(S) 
 PACKSTRING(V,S)    WRITEOCT(N,D)       FINDOUTPUT(S) 
 UNPACKSTRING(S,V)  WRITEHEX(N,D)       SELECTINPUT(N) 
 RDCH()             WRITEO(N)           SELECTOUTPUT(N) 
 READN()            WRITEH(N)           ENDREAD() 
 UNRDCH()           NEWLINE()           ENDWRITE() 
 WRCH(C)            NEWPAGE()           WRITEF(F,A,B,C...) 
) !endex
!t  DESTROY(F) is a routine that destroys (deletes) the file F.  The 
       parameter F should be or yield a BCPL string. 
!hd('System Errors')
        Many of  the  above  system  interface  routines  will  call 
    UNIX_ERROR if there is a system error.  This prints a message at 
    the console in the form 
!longex
    ERROR: s1 s2 CODE n
) !endex
!p where s1 is the error message; s2 is (optional) extra information, such
as the file name or stream number, and n is the error code number returned 
from the relevent UNIX call. See the UNIX Programmer's Manual Section II 
for the detailed description of n. 
!p 
        In addition to the above there is  another  routine 
    written  in  UNIX  assembler.   it  may  be  used by the more 
    sophisticated programmer who finds  the  above  set  inadequate. 
    it  should make complete communication with the system 
    possible. 
!t  UNIX(NARGS,CMMD,P1,P2,...,Pn,R0) is a function which generates  an  UNIX  system 
       command,  yielding -1 if it fails.  The 
       parameter CMMD is the system command code (an integer)  which 
       may  be  expressed  conveniently  by a manifest constant (see        PHDR). 
!p2 The  parameters P1, P2, ..., Pn are  the  values 
of the n inline arguments to the UNIX system call. 
!p2 R0 is the (optional) 
value to be stored in R0 at the time of the system call. R0 normally 
contains the file descriptor for I/O calls. 
!p upon return from the system call R0 will contain the results (if any)
of the UNIX system call, or -1 if an error occurred. the global 
ERRCODE will contain the error code number (returned in R0 by UNIX) in 
the case of an error. 
for example:
!longex
UNIX(2,SYS.SEEK,0,0,IN_STREAM)
) !endex )l2 will seek to the beginning of the current input stream. note that 
IN_STREAM is the actual UNIX file descriptor. 
!hd('Globals and Manifest Constants')
        Global identifiers, where they differ from those  with  BCPL 
    under MTS are listed below (see PHDR). 
