#

#include <stdio.h>
#include "fmt.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "fmtmac.h"
#include "fmtfns.h"

FILE *include;		/* include file ptr */
FILE *standin;		/* input file ptr */
int null();
int inputfn();		/* read input */
int exist();
int date();
int filedate();
int count();
int countv();
int fninclude();
int library();
int pagefn();
int centerfn();
int justfn();
#ifndef RT11
int fnunlink();
int contents();
int index();
int stack();
int fnblock();
#endif
int fntest();
int fnfor();
int ccfn();

struct fntab fntab[] IS
{
"null", null,
"input", inputfn,
"exist", exist,
"date", date,
"filedate", filedate,
"count", count,
"countv", countv,
"include", fninclude,
"library", library,
"page", pagefn,
"center", centerfn,
"just", justfn,

#ifndef RT11		/* exclude big functions under RT-11 */
"unlink", fnunlink,
"contents", contents,
"index", index,
"stack", stack,
"block", fnblock,
#endif

"test", fntest,
"for", fnfor,
"!", ccfn,		/* must be last ... dummy control card function */
0
};

struct { int INT; };

null()
{
/*
 * null function: !null(param,yes,no) 
 * test if the given parameter number (or actual string) is
 * null. 
 * return the next parameter if it is, otherwise the following one. 
 */

register int l;

if(fn_par((char *) NULL,0) > 0)
	{
	/* got an actual parameter ... ignore following string.  */
	fn_str((char *) NULL,0);
	}

l = fn_str(buff_1,MAXBUFF);
fn_put(buff_1,l);
return(OK);
}

inputfn()
{
/*
 * input(prompt,pfx,eof,null)
 * prompt with "prompt", set prefix to "pfx"
 * and read an input line.
 * return "eof" on eof, and "null" on null input line.
 */
char pfx[2];
register int l;

if (fn_str(buff_1,MAXBUFF) > 0)
	fprintf(stderr,"%s\n",buff_1);
fflush(stdout);
fn_str(pfx,1);		/* ignore the prefix field */
l = input(standin);
DEBUGF(("inputfn line '%s' length %d\n",buff_1,l));
if (l < 0)
	fn_str(buff_1,MAXBUFF);		/* eof */
if (l == 1 && buff_1[0] == ' ')
	{
	fn_str(buff_1,MAXBUFF);		/* null */
	fn_str(buff_1,MAXBUFF);		/* null */
	}
if (buff_1[0])
	fn_put(buff_1,strlen(buff_1));
return(OK);
}

exist()
{
/*
 * function exist: !exist(name,yes,no)
 * if the requested function exists then return "yes" otherwise
 * return "no". 
 */

char name[MAXMAC];
register int l;

if(fn_word(name,sizeof name) > 0)
	{
	lctran(name);
	if(!find_mac(name))
		fn_str((char *) NULL,0);
	}
if((l = fn_str(buff_1,MAXBUFF)) > 0)
	fn_put(buff_1,l);
return(OK);
}

char *months[] IS
{"january", "february", "march", "april", "may", "june", 
 "july", "august", "september", "october", "november", "december"};

char *days[] IS
{
"sunday", "monday", "tuesday", "wednesday", "thursday", "friday",
 "saturday"};


date()
{
long tvec;
time(&tvec);
return(datefn(&tvec));
}

filedate()
{
long tvec;
getindate(&tvec);		/* get the input file date */
return(datefn(&tvec));
}

datefn(tvec) long *tvec;
{
/*
 * return more general date manipulations than allowed 
 * with !d and !t operators. 
 * see fmt writeup for more detailed specs. 
 */

#define second i[0]
#define minute i[1]
#define hour  i[2]
#define day   i[3]
#define month i[4]
#define weekday i[6]
#define year i[5]

register int *i;
register char *p;
register char *q;
char *m;
int n;
char mask[64];
char name[8];
char c;
int *localtime();

if(*fn_ptr==0)
	fn_ptr = "' * @* * *',year,month,day,time";
fn_str(mask,sizeof mask);
m = mask;
p = buff_1;

i = localtime(tvec);

while (c = *m++)
	{
	if( c != '*' )
		*p++ = c;
	else
		{
		fn_word(name,8);
		lctran(name);
		switch(lookup2(name,"yeyywedaddmommsesstiampmhohhmimn"))
			{
		case 1: /* 'ye' */
			n = year+1900;
			goto put_int;

		case 2: /* 'yy' */
			n = year;
			goto put_int;

		case 3: /* 'we' */
			q = days[weekday];
		put_str:
			while (*q)
			     *p++ = *q++;
			break;

		case 4: /* 'da' */
			n = day;
		put_int:
			p += i_cvt(p,n);
			break;

		case 5: /* 'dd' */
			n = day;
		put_2d:
			*p++ = n/10 + '0';
			*p++ = n%10 + '0';
			break;

		case 6: /* 'mo' */
			q = months[month];
			goto put_str;

		case 7: /* 'mm' */
			n = month+1;
			goto put_2d;

		case 8: /* 'se' */
			n = second;
			goto put_int;

		case 9: /* 'ss' */
			n = second;
			goto put_2d;

		case 10: /* 'ti' */
			*p++ = hour/10 + '0';
			*p++ = hour%10 + '0';
			*p++ = ':';
			*p++ = minute/10 + '0';
			*p++ = minute%10 + '0';
			*p++ = ' ';
		case 11: /* 'am' */
		case 12: /* 'pm' */
			q = hour >= 12 ? "p.m." : "a.m.";
			goto put_str;

		case 13: /* 'ho' */
			n = hour;
			goto put_int;

		case 14: /* 'hh' */
			n = hour;
			goto put_2d;

		case 15: /* 'mi' */
			n = minute;
			goto put_int;

		case 16: /* 'mn' */
			n = minute;
			goto put_2d;

		default:
			err("date: bad keyword %s",name);
			}
		}
	}
*p = 0;
fn_put(buff_1,p-buff_1);
return(OK);
}

int lookup2(name,names) register char *name, *names;
{
/*
 * look up two character string "name" inside "names" which 
 * consists of a number of possible 2 character strings.
 * return its index value (1= first)
 * or 0 if not found.
 */
register int i;

for (i=1; *names; ++i, names += 2)
	if (name[0] == names[0] && name[1] == names[1])
		return(i);
return(0);
}

fn_put(buff,length)
char *buff;
{
/* output the given string into the generated text stream 
 * of the current macro or function.
 */

if(length > 0)
	{
	rem_append(rd_next,buff,length);
	DEBUGF(("fn_put %d bytes ==> '%.*s'\n",length,length,buff));
	}
}

fn_str(buff,length)
char *buff;
{
/*
 * pick up a string from the current input scan. 
 * the string may be enclosed in quotes or not depending
 * upon the presence of special characters. 
 * if "buff" is NULL then don't return anything.
 * return -1 if no string present.
 */ 

register char *old;
register int l;

old = ptr_1;

ptr_1 = fn_ptr;

if(*ptr_1 == QT)
	l = get_str(buff,length);
else
	l = scan_word(buff,length);
if(l >= 0)
	{
	fn_ptr = ptr_1;
	if(*fn_ptr == ',')
		++fn_ptr;
	if(buff)
		buff[l] = 0;
	}
ptr_1 = old;
return(l);
}




fn_par(buff,length)
char *buff;
{
/*
 * routine to return either the parameter referred to by an 
 * integer number (1...9) or the parameter itself if its quoted. 
 * used for contents, null, etc. 
 */

register int c;
register struct macro *m;
register int l;

c = *fn_ptr;
if(c >= '1' && c<= '9')
	{
	++fn_ptr;
	m = rd_next;
	while (m->m_type != T_MACRO)
		{
		m = m->m_next;
		if(m == 0)
			return(-1);
		}
	c -= '1';
	l = m->m_pars[c].l_length;
	if(buff)
		move(l,m->m_pars[c].l_ptr,buff);
	if(*fn_ptr == ',')
		++fn_ptr;
	}
else
	l = fn_str(buff,length);
DEBUGF(("fn_par ==> %d bytes '%.*s'\n",l,l,buff));
return(l);
}



fn_word(buff,length)
char *buff;
{
/*
 * pick up the next word from the input line via scan_word. 
 * if we fail then return -1. 
 */

register char *old;

if(*fn_ptr == QT)
	return(-1);
old = ptr_1;
ptr_1 = fn_ptr;

if( (length = scan_word(buff,length)) >= 0)
	{
	fn_ptr = ptr_1;
	if(*fn_ptr == ',')
		++fn_ptr;
	buff[length] = 0;
	}

ptr_1 = old;
return(length);
}


fn_int(n)
int *n;
{
/*
 * convert next argument as integer number.
 * return 1 if found, 0 if none.
 */
register c;
register int sign;

*n = 0;
sign = 0;
c = *fn_ptr;
if (c == '-')
	{
	c = *++fn_ptr;
	sign++;
	}
if(DIGIT)
	{
	do
		{
		*n = *n * 10 + c - '0';
		c = *++fn_ptr;
		}
	while (DIGIT);
	if(c==',')
		++fn_ptr;
	if (sign)
		*n = - *n;
	return(1);
	}
if(c==',')
	++fn_ptr;
return(0);
}

fnunlink()
{
/*
 * unlink filename. used by contents and possibly other fuctions requiring
 * a scratch file. if file name has tfmt as a prefix use the untemp routine
 * to keep track of the temp file usage.
 */
char file[64];
register int l;
extern char tfmt[];

l = fn_str(file, sizeof file);
file[l] = 0;
if (eq(file,tfmt))
	untemp(file);
else if (unlink(file) < 0)
	{
	err("can't unlink %s",file);
	return(FAIL);
	}
return(OK);
}


fninclude()
{
/*
 * include filename.
 */

char file[64];
register FILE *i;
register int l;

l = fn_str(file, sizeof file);
file[l] = 0;
if (file[0] == '!')
	i = fdopen(pipein("/bin/sh","sh","-c",file+1,0),"r");
else 
	i = fopen(file,"r");
if(i == (FILE *) NULL)
	{
	err("can't include %s",file);
	return(FAIL);
	}
else
	{
	incl.m_next = rd_next;
	rd_next = &incl;
	include = i;
	incl.m_type = T_INCLUDE;
	}
return(OK);
}

clsinclude()
{
fclose(include);
include = (FILE *) NULL;
}

char *pgfns[] IS
/* 0		1	2	3	4	5	   6	    7	   8  */
{ "add", "continue", "set", "reset", "insert", "normal", "value", "save", "real",0 };

pagefn()
{
register struct cvt *p;
register int i;
register char *s;
char *q;
char word[10];
int n;

/*
 * page function, set up the font according to the allowed formats
 * (same as for the count function)
 */

fn_word(word,8);
for (p = cvts; p->cv_name; ++p)
	if(equal(p->cv_name,word))
		{
		v_page = p->cv_rtn;
		if (fn_int(&n))
			page.p_page = n;
		return(OK);
		}
for (i=0; pgfns[i]; ++i)
	if (equal(word,pgfns[i]))
		{
		switch(i)
			{
		case 0:		/* add */
			fn_int(&n);
			page.p_page += n;
			break;
		case 2:		/* set new incr n */
			if (fn_int(&n))
				page.p_page = n;
			if (fn_int(&n))
				page.p_incr = n;
			if (fn_int(&n))
				page.p_page += n;
			break;
		case 3:		/* reset page number */
			page.p_page = page.p_save;
			break;
		case 7:		/* save page number */
			page.p_save = page.p_page;
			break;
		case 8:		/* !page(real,pattern,delim) */
		case 6:		/* !page(value,pattern,delim) */
			fn_str(temp,sizeof temp);
			if (fn_str(word,sizeof word) <= 0)
				word[0] = '*';
			for (s=temp, q=buff_1; *s; ++s)
				{
				if (*s == word[0])	/* got delimeter */
					{
					if (i == 6)
						q += i_cvt(q,page.p_page-page.p_incr);
					else
						{
						move(page.p_len,page.p_addr,q);
						q += page.p_len;
						}
					}
				else
					*q++ = *s;
				}
			fn_put(buff_1,q-buff_1);
			break;
		default:
			err("page: option %s not implemented",word);
			}
		return(OK);
		}
err("page: invalid option %s",word);
return(FAIL);
}

centerfn()
{
/*
 * !center(par,length,pad)
 * center "par" in a field "length" long with a pad character of "pad".
 */
static padch;
static length;
register int l;
int n;
register int i;
register char *p;

l = fn_par(buff_1,MAXBUFF);
if (fn_int(&n))
	length = n;
if (padch == NULL)
	padch = NTB;
if (fn_char(&n) && n)
	padch = n;
n = (length-l)/2;
for (p=temp, i=0; i < n; ++i)
	*p++ = padch;
move(l,buff_1,p);
i += l; p += l;
for (; i < length; ++i)
	*p++ = padch;
fn_put(temp,i);
return(OK);
}

justfn()
{
/*
 * !just(par,length,pad)
 * justify "par" in a field "length" long with a pad character of "pad".
 */
static padch;
static length;
register int l;
int n;
register int i;
register char *p;

l = fn_par(buff_1,MAXBUFF);
if (fn_int(&n))
	length = n;
if (padch == NULL)
	padch = NTB;
if (fn_char(&n))
	padch = n;
n = abs(length);
if (n < l)
	n = l;
n -= l;
p=temp;
if (length >= 0)
	for ( i=0; i < n; ++i)
		*p++ = padch;
move(l,buff_1,p);
p += l;
if (length < 0)
	for (i=0; i < n; ++i)
		*p++ = padch;
fn_put(temp,n+l);
return(OK);
}

fn_char(n) int *n;
{
/*
 * if integer specified, return the value of the integer,
 * otherwise return the 1 character string.
 */
*n = 0;
if (*fn_ptr == QT)
	return(fn_str(n,2));
else
	return(fn_int(n));
}

fntest()
{
register int l, l1, l2;
#define	temp1	temp
#define	temp2	(temp+128)
#define	temp3	(temp+256)

l = fn_str(temp,128);
temp[l] = 0;
while ((l1 = fn_str(temp2,128)) > 0 && *fn_ptr != ')' )
	{
	l2 = fn_str(temp3,128);
	temp2[l1] = 0;
	if (equal(temp,temp2))
		{
		fn_put(temp3,l2);
		return(OK);
		}
	}
if (l1 > 0)
	fn_put(temp2,l1);
return(OK);
}

fnfor()
{
int i;
register char *p1, *p3;
int i1, i2, i3;

i2 = fn_str(temp2,128);
temp2[i2] = 0;
i3 = fn_str(temp3,128);
temp3[i3] = 0;
if(!fn_int(&i1))
	i1 = 1;
if (!fn_int(&i2))
	i2 = i1;
if (!fn_int(&i3))
	i3 = 1;
for (i=i1; i<=i2; i += i3)
	{
	for (p1 = temp1, p3 = temp3; *p3 && *p3 != temp2[1]; ++p3)
		{
		if (*p3 == temp2[0])
			{
			sprintf(p1,"%d",i);
			p1 = endstr(p1);
			}
		else
			*p1++ = *p3;
		}
	fn_put(temp1,p1-temp1);
	}
return(OK);
}

#ifndef RT11
fnblock()
{
fn_str(temp2,128);
fn_f(")l2a");
fn_f("!include('!banner ''%s'' ')",temp2);
fn_f(") ");
return(OK);
}
#endif

/*VARARGS1*/
fn_f(fmt,d1,d2,d3,d4,d5,d6) char *fmt;
{
sprintf(temp,fmt,d1,d2,d3,d4,d5,d6);
fn_put(temp,length(temp));
}
