#include "fmt.h"
#include <assert.h>

/*			Copyright 1977 by Bill Webb.	 		*/

int col_top;			/* top of column (1 st line in buffer) */
int col_bot;			/* bottom of column (last line) */
int col_size;			/* total buffer size */
int col_len;			/* size of a line in the buffer */
char *col_buff;			/* column buffer pointer */
int col_prev;			/* previous column */
int col_disp;			/* displacement from line start of 
				 * the current column.
				 */

#ifdef SMALL
char col_file[20];		/* name of the column temp file */
int col_fd;			/* file descriptor */
#define	CORELINES 1		/* only keep 1 in memory */

#else	/* it isn't SMALL */

#define	CORELINES line_max
#define	col_io()		/* no I/O */
#endif	/* SMALL */

int fmt_put();
int col_put();

col_init(n)
{
/*
 * restart column processing after a "n" control card. 
 * if number of columns is 1 (or less) then turn off 
 * column processing.
 * if number of columns is > 1 then start column 
 * processing.
 */
register int i;

if(columns <= 1)
	{
	col_num = columns = 1;
	width = col_width;
	DEBUGV(columns); DEBUGV(width);
	out_addr = fmt_put;
	col_chk();
	return;
	}

if(n == 4)
	col_fix();
out_addr = col_put;

width = - gaps[columns-1];	/* remove last gap */
for (i=0; i<columns; ++i)
	{
	DEBUGV(widths[i]);
	DEBUGV(gaps[i]);
	width += widths[i] + gaps[i];
	}
col_len = width + text_col;
DEBUGV(col_len);
col_chk();
col_size = col_len * CORELINES;
DEBUGV(columns); DEBUGV(width); DEBUGV(col_size);
if ((col_buff = alloc(col_size)) == NULL)
	error("cannot allocate column buffer");
DEBUGV(col_buff);
set(col_buff,col_size,NTB);
col_io();			/* allocate file if need be */
col_top = physline;
col_bot = physline;

new_col(1);
}

col_eject()
{

/*
 * called at the end of a page eject to start 
 * multi_column processing again. 
 */

if(columns <= 1)
	{
	col_num = columns = 1;
	}

else
	{
	col_top = col_bot = physline;
	col_num = 1;
	col_width = widths[col_num-1];
	new_col(col_num);	/* start new column up */
	}
}

/*ARGSUSED*/
end_col(n)
{
/* 
 * end column processing as a control card of type "n" has
 * been encounterd. 
 */

out_addr = fmt_put;

if(columns <= 1)
	{
	width = col_width;
	return;
	}

c_flush;
col_dump();		/* output any pending stuff */
if(col_buff)
	free(col_buff);
col_buff = 0;
col_num = 1;
col_width = width;
ptr_calc();		/* recalculate the buffer pointers */
}

new_col(n)
{
/* 
 * goto column "n". 
 */

register int i;
if ( n < col_num)
	col_dump();
col_prev = col_num;
col_num = n;
DEBUGV(col_num);

col_width = widths[col_num-1];
cnt_line = col_top;
col_disp = text_col;
for (i=0; i<col_num-1; ++i)
	col_disp += widths[i] + gaps[i];
DEBUGV(col_width); DEBUGV(col_num); DEBUGV(col_disp);
ptr_calc();	/* recalcuate length */
}


col_dump()
{
/*
 * dump out the column buffer. 
 */

register char *p;
register int l = col_len;
register int posn = col_len * (physline -1);	/* line position in buffer */

if(columns <= 1 || col_buff==NULL)
	return;

#ifdef SMALL
lseek(col_fd,(long) posn,0);
p = col_buff;
#endif
for ( ;physline < col_bot; posn += l)
	{
#ifdef SMALL
	read(col_fd,p,col_len);		/* read the text */
	fmt_put(p,l);			/* output it */
	set(p,l,NTB);
	lseek(col_fd,(long) posn,0);
	write(col_fd,p,col_len);	/* blank out the file */
#else
	p = col_buff + posn;
	fmt_put(p,l);
	set(p,l,NTB);
#endif
	}

col_top = col_bot = physline;
}

col_put(buff,length) char *buff;
{
/*
 * output "buff" of "length" into the current output column. 
 */

register char *p;
register int l;
register int posn IS (col_len * (cnt_line - 1) ) + col_disp;

DEBUGF(("col_put('%.*s',%d)\n",length,buff,length));
l = length - text_col;
p = buff + text_col;

ASSERT(l + col_disp <= col_len);

#ifdef SMALL
if (l > 0)
	{
	lseek(col_fd,(long) posn,0);
	write(col_fd,p,l);
	}
#else

if(l > 0)
	move(l,p,col_buff + posn);
#endif
if(col_bot <= cnt_line)
	col_bot = cnt_line+1;
}

col_fix()
{
/* 
 * fix up widths after a column control card. 
 */

register int k,i,w;

k = width;

for (i=0; i<columns-1; ++i)
	k -= gaps[i];

w = k/columns;
k = k%columns;

for (i=0; i<columns; ++i)
	widths[i] = w + (i < k ? 1 : 0);

}

col_chk()
{

if(width + text_col > MAXBUFF)
	error("maximum column used > %d",MAXBUFF);
if(width < 5)
	error("total width too small (%d)",width);
}

#ifdef SMALL
col_io()
{
/*
 * create the column buffer file if necessary, and initialize it to
 * non-trivial blanks.
 */
register int i;

if (col_fd == 0)
	{
	mktemp(col_file);
	if (close(creat(col_file,0600)) < 0 || (col_fd = open(col_file,2)) < 0)
		error("cannot open column file %s",col_file);
	}
lseek(col_fd,0L,0);
for (i=0; i<line_max; ++i)
	write(col_fd,col_buff,col_len);
}
#endif
