#
#include <stdio.h>

#define	DELIM	';'
#define	NL	'\n'
#define	INDEXPARS	5	/* number of fields in original line */
#define	MAXTAG	8		/* maximum number of levels */
#define	LC(x) ('A' <= (x) && (x) <= 'Z' ? (x)-'A'+'a' : (x))

FILE *f, *inf;
char tfile[32];			/* temp file name */
int status;
#define	MAXLINE	256

struct line
{
char *next;		/* next location we can use in line */

char *entry;		/* the entry itself */
char *page;		/* page number */
char *tagptr;		/* tag number */
char *prefix;
char *postfix;		/* preceeding INDEXPARS must stay together */

int start, end;		/* current line range */
int tag;
int prtag;		/* counts fields that compared equal to previous entry */
char *outpage;
char *entries[MAXTAG];
char buff[MAXLINE];
} data1, data2;
struct line *ptr1 = &data1, *ptr2 = &data2;
struct line *temp;

char *file;
int dflg 0;		/* debugging flag */
int sflg;		/* skip when first letter changes */
int rflg;		/* ranging allowed */
int schar;
char *spacer ",";	/* spacer between entries */

main(argc,argv) char **argv;
{
/*
 * program that does most of the actual work in producing an FMT index.
 * it is given a file with the format:
 * entry;page;level;prefix;postfix
 * it sorts it and then combines like entries into the appropriate
 * FMT macro calls to IND1 ... INDn
 * the result is left in the original input file.
 *
 */
register int i;
register char *argp;
register int c;

--argc; ++argv;
while (argc > 0)
	{
	argp = *argv++;
	if (dflg)
		printf("'%s' ",argp);
	--argc;
	if (*argp == '-')
		{
		++argp;
		while (c = *argp++)
			{
			switch(c)
				{
			case 'x':
				spacer = argp;
				argp = endstr(argp);
				break;
			case 's':
				++sflg;
				break;
			case 'd':
				++dflg;
				break;
			case 'r':
				++rflg;
				break;
			default:
				printf("index: unknown option %s\n",argp-1);
				while (*argp)
					++argp;
				break;
				}
			}
		}
	else
		file = argp;
	}
if (dflg)
	printf("\n");
copy(tfile,file);
append(tfile,".i");
if ((i = fork()) == 0)
	{
	execl("/bin/sort", "sort", "-t;", file, "-o", tfile, 0);
	err("no /bin/sort");
	}
while (wait(&status) != i)
	;
if ((inf = fopen(tfile,"r")) == NULL)
	err("cannot open %s",tfile);
if (dflg > 1)
	f = stdout;
else
	if ((f = fopen(file,"w")) == NULL)
		err("cannot re-open %s",file);
if (!reads(ptr2))
	exit(0);		/* nothing to do */
while ( reads(ptr1))
	{
	for (i=0; i<MAXTAG; ++i)
		{
		if (dflg)
			printf("'%s' :: '%s' ",ptr1->entries[i],ptr2->entries[i]);
		if (!equal(ptr1->entries[i],ptr2->entries[i]))
			break;
		}
	if (dflg)
		printf("cmp: %d\n",i);
	if (i == MAXTAG)
		addpage(ptr2,ptr1->start);		/* add in new line # */
	else
		{
		output(ptr2);
		ptr1->prtag = i+1;
		temp = ptr1;
		ptr1 = ptr2;
		ptr2 = temp;
		}
	}
output(ptr2);
if (!dflg)
	unlink(tfile);		/* get rid of temp file */
}

addpage(p,n) register struct line *p;
{
/*
 * add page number "n" into the page number list for line "p".
 */
if (p->start <= n && n <= p->end)
	return;		/* already in the list */
if (rflg && n == p->end + 1)	/* if ranging and its to be added to range */
	p->end = n;
else
	{
	cvtpage(p);
	p->start = p->end = n;
	}
}

cvtpage(p) register struct line *p;
{
/*
 * convert and output the page number to the buffer.
 */
register char *s;
if (p->start == 0)
	return;
if (p->outpage[0] != 0)
	for (s=spacer; *s; )
		*p->next++ = *s++;	/* copy the spacer */
if (p->start != p->end)
	sprintf(p->next,"%d-%d",p->start,p->end);
else
	sprintf(p->next,"%d",p->start);
p->next = endstr(p->next);
p->start = p->end = 0;
}

reads(p) register struct line *p;
{
register int i;
/*
 * read in a line and then parse off the various primary fields.
 */
if (fgets(p->buff,MAXLINE,inf) == NULL)
	return(0);
parse(p->buff,&p->entry,INDEXPARS,DELIM);
p->start = p->end = atoi(p->page);
p->outpage = p->next = endstr(p->buff)+1;
p->tag = atoi(p->tagptr);
p->prtag = 1;
*p->next = 0;
i = parse(p->entry,p->entries,MAXTAG,',');
if (i < p->tag)
	p->tag = i;		/* actual tag level */
return(1);
}

parse(buffer,ptrs,maxcnt,delim) char *buffer, **ptrs, delim;
{
/*
 * take the string given in "buffer" and find all fields delimited
 * by "delim". 
 * change all NL's and delimiters into NULL's.
 * terminate on end of line.
 */
register char *s, **q;
int cnt = 0;
register char *t;

q = ptrs;
for (s=buffer; *s ; )
	{
	while (*s == ' ')
		++s;
	if (*s == 0)
		break;
	if (++cnt <= maxcnt)
		*q++ = s;
	t = s;
	while (*s && *s != delim && *s != NL)
		{
		if (*s != ' ')
			t = s;
		++s;
		}
	if (*s)
		*s++ = 0;
	if (*++t == ' ')
		*t = 0;		/* trim trailing blanks */
	}
while (--maxcnt >= cnt)
	*q++ = s;		/* return null strings for the rest */
return(cnt);
}

output(p) register struct line *p;
{
register int i;

if (sflg && LC(p->entry[0]) != schar)
	{
	schar = LC(p->entry[0]);
	fprintf(f,"!ind0('%c')\n",schar);
	}
cvtpage(p);
if (p->prtag > p->tag)
	p->prtag = p->tag;
fprintf(f,"!ind%d('%s',",
	p->prtag,p->outpage);
for (i=1; i<p->prtag; ++i)
	fprintf(f,"'%s,',",p->entries[i-1]);	/* preliminary params */
fprintf(f,"'%s ",p->prefix);
for (; i<=p->tag; ++i)
	fprintf(f,"%s, ",p->entries[i-1]);
fprintf(f,"%s')\n",p->postfix);
}

