#
#ifndef RT11

#include <stdio.h>

#include "fmt.h"
#include "fmtmac.h"

#define	COLUMNS	2

char *ind_cmds[] IS
{
"init", "gene", "pad", "on", "off", "rang", "nora", 
"manu", "auto", "roma", "alph", "name", "inte", 
"tabs", "colu", "nopa", "page", "debu", "skip",
"spac", "inde",
0};

int i_cvt();
int alpha();
int roman();
int name();

struct indx
{
int maxlevel;
int nlines;
FILE *file;
char range;
char manual;
char disable;
char padch;
char debug;
char tabmode;	/* ON = tabs, OFF = COLUMNS */
char nopage;
char skip;
int padlen;
int ind;		/* indent amount at each level */
int (*cvt)();
char spacer[20];	/* the spacing for list mode */
char tempfile[20];
} ;

/*ARGSUSED*/
index(param,plength,mac) char *param; struct macro *mac;
{
register struct indx *indx;
int i;
register int l;
int j;
register char *p;
char prefix[64], postfix[64];
char entry[128];
char word[5];
int level;
char pageno[20];
char padstr[64];
int n;
 
 
/*
 * index function ... see the writeup for details.
 */
 
if ((indx = mac->fn_work[0]) == (struct indx *)NULL)
	{				/* initialize the data areas */
	mac->fn_work[0] = indx = (struct indx *)malloc(sizeof (struct indx));
	if (indx == (struct indx *) NULL)
		error("out of memory");
	clear(indx,sizeof *indx);
	indx->ind = 2;
	indx->tabmode = ON;
	indx->nopage = OFF;
	indx->range = ON;
	indx->manual = OFF;
	indx->skip = OFF;
	indx->cvt = i_cvt;
	indx->padch = '.';
	indx->padlen = 1;
	indx->maxlevel = 0;
	indx->debug = OFF;
	sprintf(indx->spacer,"-x,");
	mktemp(indx->tempfile);		/* get temp file name */
	if ((indx->file = fopen(indx->tempfile,"w")) == NULL)
		{
		err("can't open %s",indx->tempfile);
		return(FAIL);
		}
	}
if (! (*fn_ptr == QT || ('1' <= *fn_ptr && *fn_ptr <= '9')))
	goto do_cmd;
l = fn_par(entry,sizeof entry);
if (l < 0)
	{
	err("index: invalid parameter");
	return(FAIL);
	}
entry[l] = 0;
fn_int(&level);
if(level == 0)
	level = 2;
/*
 * determine the actual level for this entry.
 */
for (p=entry, l=1; *p; ++p)
	if (*p == ',')
		++l;
if (level > l)
	level = l;
if (level > indx->maxlevel)
	indx->maxlevel = level;
fn_str(prefix, sizeof prefix);
fn_str(postfix, sizeof postfix);
l = fn_str(pageno, sizeof pageno);

++indx->nlines;
if (l <= 0)
	l = (*indx->cvt)(pageno,page.p_page-1);
pageno[l] = 0;
if (indx->nopage == ON)
	pageno[0] = 0;
i=indx->padlen-l;
for (j=0; j < i; ++j)
	padstr[j] = indx->padch;
padstr[j] = 0;
if (!indx->disable)
	fprintf(indx->file,"%s ;%s;%d;%s;%s\n",
		entry,pageno,level,prefix,postfix);
return(OK);

do_cmd:

fn_word(word,sizeof word-1);
word[4] = 0;
lctran(word);
switch(lookup(word,ind_cmds))
	{
case 0:        /* init */
	if (indx->nlines == 0)
		{
		err("index: no entries");
		return(FAIL);
		}
	fn_f(")rv");

	fn_f("call stack(push,tabs)");
	fn_f("call stack(push,indents)");
	sprintf(temp,"tabs");		/* set tab stops */
	for (i=1; i<= indx->maxlevel; ++i)
		sprintf(endstr(temp)," %d",indx->ind * (i-1) + 1);
	sprintf(endstr(temp)," %d",width-5);
	fn_put(temp,length(temp));

	fn_f("indents (5,0) ");		/* set indent columns */
	if (indx->nopage)
		entry[0] = 0;
	else if (indx->tabmode)
		sprintf(entry,"!null(1,,'' )d%d !par.1'') ",indx->maxlevel+1);
	else
		sprintf(entry,"!par.1");
	if (indx->skip)
		fn_f("%cset ind0 = ' )l%drf '",NOEXPAND,indx->skip);
	for (i=1; i <= indx->maxlevel; ++i)
		{
		fn_f("%cset ind%d = ' )lrfht%d !par.%d %s '",
			NOEXPAND,i,i,i+1,entry);
		}
	fn_f("go");
	break;
 
case 1:             /* generate */
	 fclose(indx->file);
	 doindex(indx->tempfile,indx);
	 if ((indx->file = fopen(indx->tempfile,"a")) == NULL)
		{
		err("cannot re-open %s",indx->tempfile);
		return(FAIL);
		}
	 fprintf(indx->file,"!stack(pop,tabs)\n");
	 fprintf(indx->file,"!stack(pop,indents)\n");
	 fprintf(indx->file,"!unlink(%s)\n",indx->tempfile);	/* get rid of file */
	 fn_f("!include(%s)",indx->tempfile);
	 fclose(indx->file);
	 indx->file = NULL;
	 free(indx);			/* free the work area */
	 mac->fn_work[0] = NULL;
	 break;
case 2:			/* pad */
	if (fn_int(&n))
		indx->padlen = n;
	else
		indx->padlen = 1;
	if (fn_char(&n))		/* the pad character */
		indx->padch = n;
	break;
case 3:			/* on */
	indx->disable = OFF;
	break;
case 4:
	indx->disable = ON;
	break;
case 5:
	indx->range = ON;		/* range */
	break;
case 6:
	indx->range = OFF;		/* norange */
	break;
case 7:			/* manual */
	indx->manual = ON;
	break;
case 8:			/* auto */
	indx->manual = OFF;
	break;
case 9:			/* roman */
	indx->cvt = roman;
	break;
case 10:		/* alpha */
	indx->cvt = alpha;
	break;
case 11:		/* name */
	indx->cvt = name;
	break;
case 12:		/* integer */
	indx->cvt = i_cvt;
	break;
case 13:		/* tabs */
	indx->tabmode = ON;
	break;
case 14:
	indx->tabmode = OFF;;	/* columns */
	break;
case 15:
	indx->nopage = ON;	/* nopage */
	break;
case 16:
	indx->nopage = OFF;	/* page */
	break;
case 17:			/* debug */
	indx->debug++;
	break;
case 18:
	indx->skip++;		/* generate skip codes */
	break;
case 19:			/* spacer */
	fn_str(indx->spacer+2,(sizeof indx->spacer)-2);
	break;
case 20:			/* indent,n */
	fn_int(&indx->ind);
	break;
case -1:		/* invalid option */
	err("index: bad option %.4s",word);
	return(FAIL);
default:
	err("index: option %.4s not implemented",word);
	break;
        }
return(OK);
}

doindex(file,indx) char *file; struct indx *indx;
{
int i;
register char *p;
register int argc;
int status;
char *argv[10];			/* the arguments */

argc = 0;
if ((i = fork()) == 0)
	{			/* child */
	closeall();
	p = "/usr/lib/fmt_index";
	argv[argc++] = p+9;
	if (indx->debug)
		argv[argc++] = "-d";
	if (indx->skip)
		argv[argc++] = "-s";
	if (indx->range)
		argv[argc++] = "-r";
	argv[argc++] = indx->spacer;
	argv[argc++] = file;
	argv[argc] = 0;
	if (indx->debug)
		{
		for (i=0; i<argc; ++i)
			printf("%s ",argv[i]);
		printf("\n");
		}
	if (sw_error)
		execv(p+9,argv);	/* try copy in current directory */
	execv(p,argv);
	printf("no %s\n",p+9);
	exit(1);
	}
else
	{		/* parent */
	while (wait(&status) != i)
		;
	}
}
#endif	/* RT11 */
