#
#include <stdio.h>
#include <signal.h>
#include "fmt.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "fmtmac.h"
 
#ifndef flush
#define	flush() fflush(stdout)
#endif

#define	FMAC	"/usr/lib/fmac."	/* fmt macro files */
int _RT11;			/* zero unless under RT-11 */
#define debug sw_error
int deflines = 60;		/* default lines/page */
char gen_date[];
char tfmt[20];			/* /tmp/fmtddd */
char *inptr;			/* pointer if argument is of form -text */
FILE *standin = {stdin};			/* current input source */
FILE *err_file = {stderr};
FILE *err_out = {stderr};
int argc;
char **argv;
char *argp = 0;
char *base;			/* base for dynamic memory region */

char *sbrk();
int main2();
int first;
 
main(targc,targv)
char *targv[];
{


argc = targc - 1;
argv = targv + 1;
sys_init();
init();
first = argc > 0;
for (;;)
	enter(main2,0);
}

main2()
{
init_job();
sys_job();
fprintf(err_file,
" line  page pfx		contents		*** UBC FMT Ver 10.4 (%s) ***\n\n",
	gen_date);
if(first)
	{
	first = 0;
	in_open();
	}
do_ccs();
scan();
}
 
int BLOCK;		/* allocation unit */
sys_init()
{
/*
 * do system dependent once only initializations 
 */
int stop();
 
BLOCK = 4096;				/* set allocation block size */
err_file = err_out = stderr;
setout();
deflines = lplines();
sprintf(tfmt,"/tmp/fmt%d",getpid());
if (signal(SIGHUP,SIG_IGN) != SIG_IGN)
	signal(SIGHUP,stop);
if (signal(SIGINT,SIG_IGN) != SIG_IGN)
	signal(SIGINT,stop);
signal(SIGPIPE,stop);			/* if pipe breaks */
signal(SIGTERM,stop);			/* always catch terminate */
base = sbrk(0);
}
 
#ifndef setpfx
char sw_pfx;
char pfx;
setpfx(c)
char c;
{
if(sw_pfx)
	pfx = c == ' ' ? 0 : c;
}
#endif
 
put_date()
{
/*
 * output the current date in format mm-dd-yy.
 */

register int *i;
long tvec;
int *localtime();
 
time(&tvec);

i = localtime(&tvec);
 
put_dd(i[4]+1);
putch('-');
put_dd(i[3]);
putch('-');
put_dd(i[5]);
}


put_time()
{
/*
 * routine to output current time. 
 */
 
register int *i;
long tvec;
int *localtime();
 
time(&tvec);

i = localtime(&tvec);

put_dd(i[2]);
putch(':');
put_dd(i[1]);
putch(':');
put_dd(i[0]);
}

put_dd(num)
{
/* output two decimal digits of number "num".
 */

putch(num/10 + '0');
putch(num%10 + '0');
}

end_run()
{
do_end();
leave("end");
}

do_end()
{
/*
 * end of run or job.
 * do final page eject via skip.
 * finish printing of multi-column output.
 * output statistics.
 * re-open the temp file and copy it to the output file.
 * unlink the temp file.
 */
register int l;
register int list_flag;
register int n;

list_flag = (sw_cont != 0) && (read_cnt || in_cnt || gen_cnt);
c_flush;
skip(END);
end_col(0);
if(list_flag)
	putstats();
flush();
fclose(err_file);
err_out = err_file = stderr;
if(list_flag)
	{
	if( (n = open(tfmt,0)) < 0)
		error("can't re-open %s",tfmt);
	eject();
	while ((l = read(n,temp,sizeof temp)) > 0)
		write1(temp,l);
	eject();
	close(n);
	}
unlink(tfmt);
unalltemp();		/* get rid of temp files */
flush();
}


sys_job()
{
register FILE *n;

if (err_file != stderr)
	fclose(err_file);
err_file = err_out = stderr;
if( (n = fopen(tfmt,"w")) < 0)
	error("can't creat %s",tfmt);
err_out = err_file = n;
}


stop()
{
unlink(tfmt);
unalltemp();			/* unlink any other temporary files */
exit(1);			/* and then really exit */
}

in_open()
{
char file[32];
/*
 * open the next input file. 
 * if file name begins with "-" assume that it is a control card
 * and copy into the input buffer.
 * if file name begins with "--" assume rest of the name is the suffix
 * of the FMT macro library in "/usr/lib/fmac.".
 */
inptr = NULL;
argp = *argv++;
if (standin != (FILE *) NULL && standin != stdin)
	{
	fclose(standin);
	standin = (FILE *) NULL;
	}
if (*argp == '-')
	{
	if (argp[1] == '-')
		{
		sprintf(file,"%s%.16s",FMAC,argp+2);
		argp = file;
		standin = fopen(argp,"r");
		if (standin == (FILE *) NULL)
			error("can't open %s",argp);
		}
	else if (argp[1] == 0)
		standin = stdin;	/* use standard input */
	else
		{
		standin = (FILE *) NULL;		/* mark it as literal input */
		inptr = argp+1;
		}
	}
else
	{
	standin = fopen(argp,"r");
	if (standin == (FILE *) NULL)
		error("can't open %s",argp);
	}
--argc;
line = 0;
if (standin != (FILE *) NULL)
	ccf("%s:\n",argp);
}
 
input(unit) register FILE *unit;
{
/*
 * read an input line from "unit" and store into the input buffer.
 * inptr is used to read from the parameter list. caller is responsible
 * for arranging switching of files etc.
 */
register int c;
register char *p;
 
p = buff_1;
if (inptr)
	{
	if (*inptr == 0)
		return(-1);
	while (*p++ = *inptr)
		++inptr;
	goto done;
	}
while ((c = getc(unit)) > 0)
	{
	if (c == '\r')
		continue;		/* ignore CR's */
	if (!sw_v)
		c = intrans[c];		/* do the translate input */
	if (c)
		*p++ = c;
	if(c == NL)
		 {
	done:
		 ++line;
		 p[-1] = ' ';
		 *p = 0;
		 return(len = p - buff_1);
		 }
	}
len = 0;		/* ignore partial line */
return(-1);
}
 
#ifdef V6
getindate(tvec) long *tvec;
{
/*
 * get the modification date and time of the current input file.
 * if that fails then use the current system time.
 */
#include <stat.h>
struct stat statb;

if (standin == NULL || fstat(fileno(standin),&statb) < 0 || statb.s_mtime == 0)
	time(&tvec);
else
	*tvec = statb.s_mtime;
}
#else
getindate(tvec) long *tvec;
{
/*
 * get the modification date and time of the current input file.
 * if that fails then use the current system time.
 */
#include <sys/types.h>
#include <sys/stat.h>
struct stat statb;

if (standin == NULL || fstat(fileno(standin),&statb) < 0 || statb.st_mtime == 0)
	time(&tvec);
else
	*tvec = statb.st_mtime;
}
#endif

eof()
{
/*
 * on eof on input, switch to the next input file
 * or if any, otherwise terminate the run.
 */
if(argp && argc > 0 )
	{
	in_open();
	return;
	}
do_end();
exit(0);
}

lplines()
{
register int fd;
static lines;

if (lines)
	return(lines);
lines = 60;
if ((fd = open("/etc/pagesize",0)) >= 0)
	{
	read(fd,&lines,2);
	if (lines <= 60)
		lines = 60;
	close(fd);
	}
return(lines);
}

write1(buff,length) char *buff;
{
register int l;
register char *p;
register int c;

l = length;
	{
	for (p=buff; --l >= 0; )
		{
		c = *p++;
		putchar(c);
		}
	}
if (debug)
	flush();
if (ferror(stdout))
	error("write error");
}

putstats()
{
fprintf(err_file,"\ninput: %d read, %d included, %d generated lines.\n\n",
	read_cnt,in_cnt,gen_cnt);
fprintf(err_file,"statistics: %d macro uses, %d function uses, %d control cards, %u bytes dynamic memory.\n\n",
	mac_use,fn_use,cc_cnt,sbrk(0)-base);
fprintf(err_file,"output: %d pages, %d lines, %d words, %d errors.\n",
	page_cnt,lines_cnt,word_cnt,err_cnt);
}
 
/* VARARGS1 */
err(s,d1,d2,d3,d4)
char *s;
{
register int n;

do_list(' ');
fprintf(err_out," *** error ");
n = ptr_1-buff_1+1;
if (n > 0 && n < MAXBUFF)
	fprintf(err_out,"near col # %d ",n);
fprintf(err_out,s,d1,d2,d3,d4);
fprintf(err_out,"%c",NL);
listcol = 0;
++err_cnt;
}
 
 
/* VARARGS1 */
error(s,d1,d2) char *s;
{
register FILE *i;
static errcnt;

if (errcnt++)
	{
	fprintf(stderr,"Fatal error while doing error processing\n");
	stop();
	}
i = err_out;
err_out = stderr;
err(s,d1,d2);
err_out = i;
do_end();		/* clean up and print error */
exit(1);                /* twas fatal */
}

int listcol;		/* current listing column */
do_list(ch)
char ch;
{
/*
 * if we have not already done so, list the input line.
 */
if(sw_dlist)
	return;
fprintf(err_out,"%5d %5d %c%.255s%c",
	 line,page.p_page,mac_ind,buff_1,ch);
listcol += 6 + 6 + 2 + length(buff_1) + 1;
if (ch == NL)
	listcol = 0;
sw_dlist = ON;
}

seterr(flag)
{
err_out = flag ? stderr : err_file;
}

/* VARARGS1 */
ccf(s,d1,d2,d3,d4)
char *s;
{
if(sw_cont)
	fprintf(err_out,s,d1,d2,d3,d4);
}

char tempused[26];		/* room for 26 temporary files */

mktemp(tempname) char tempname[20];
{
/*
 * make a temporary file name and return it
 */
register char *p;
register int i;

copy(tempname,tfmt);
p = endstr(tempname);
for (i='a'; i<='z'; ++i)
	{
	if (tempused[i-'a'] == 0)
		{
		*p++ = tempused[i-'a'] = i;
		*p++ = 0;
		return(i);
		}
	}
return(NULL);
}

untemp(name) char *name;
{
/*
 * delete temporary file.
 * must have been created with mktemp.
 */
register char *p;

p = endstr(name)-1;
tempused[*p-'a'] = 0;
unlink(name);
}

unalltemp()
{
char tempname[20];
register int i;
register char *p;

copy(tempname,tfmt);
p = endstr(tempname);
for (i='a'; i <= 'z'; ++i)
	{
	if (tempused[i-'a'])
		{
		*p = i;
		p[1] = 0;
		unlink(tempname);
		tempused[i-'a'] = 0;
		}
	}
}
