#include "fmt.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "fmthold.h"
 
co()
{
 
/*
 * command operand processor.
 */
 
register int i,n;
register char c;

co_no = INVERT;
for(EVER)
	{
loop:
	c = getch();
	c = LC(c);
	n = (ALPHA && *ptr_1 >= '0' && *ptr_1 <= '9') ? conv() : 0;
	switch(c)
		{
	/* group 1 command operands - no end of word implied */
	case '-':
	case '~':
		co_no = OFF;
		goto loop;
	case '+':
		co_no = ON;
		goto loop;
	case '@':
		sw_co(&sw_at);
		goto done;
	case 'f':
		sw_co(&sw_f);
		goto done;
	case 'u':
		sw_co(&sw_u);
		goto done;
	case '/':
		return;
		}
 
	if(ptr_2 != buff_2) 
		word_end(WORD_END); 	/* group 2 - end current word */
 
	switch(LC(c)) 
		{ 
	case 'a': 
		asis(n); 
		return; 
	case 'b': 
		if( n == 0) 
			{ 
			if(ptr_3 > buff_3) 
			--ptr_3; 
			} 
		else 
			box_co(n); 
		break; 
	case 'c': 
		c_flush; 
		if(n > columns)
			{
			err("only %d columns",columns);
			n = 0;
			}
		if(columns == 1)
			skip(NORMAL);
		else
			{
			if(n)
				new_col(n);
			else
				cskip();
			}
		break; 
	case 'd': 
		co_tabs(n,drop_char); 
		break; 
	case 'e': 
		c_flush;
		if (cur_hold == NULL) 
		     end_run();
		else 
		     {
		     end_hold(); 
		     return;
		     }
		break; 
	case 'g': 
		justify(); 
		l_flush(); 
		break; 
	case 'h': 
		do_indent(n,HANG); 
		break; 
	case 'i':
		do_indent(n,NORMAL); 
		if(co_no == ON)
			{
			if (ptr_3 > start_3 && !sw_nl) 
				l_flush();	/* if turned on and backwards move then flush */
			else
				SETPTRS; 
			}
		break; 
	case 'j': 
		do 
		     l_flush(); 
		while (--n > 0); 
		break; 
 
	case 'l': 
		if(sw_np) 
		     break; 
		do 
		     l_flush(); 
		while (--n > 0 && !top_line()); 
		break; 
	case 'm': 
		if(sw_m)
		    center();
		sw_co(&sw_m); 
		break; 
	case 'n':
		sw_co(&sw_just);
		break;
	case 'o':
		co_o(n);
		break;
	case 'p': 
		c_flush;
		for (i=1; i<p_sep; ++i) 
		     l_flush(); 
		ptr_3 += p_ind;
		sw_at = sw_u = sw_f = sw_x = sw_m = OFF; 
		sw_ncap = sw_cap; 
		break; 
	case 'q':
		quadright();
		break;
	case 'r': 
		co_reset(); 
		break; 
	case 's': 
		co_reset(); 
		sw_vers = OFF; 
		if(!sw_np) 
		     skip(NORMAL); 
		break; 
	case 't': 
		co_tabs(n,NTB); 
		break; 
	case 'v': 
		sw_v = ON;		/* let scan call CC processor */
		return; 
	case 'w': 
		if(cnt_line + n*spacing > eff_max)
			{
			c_flush;
			if(cnt_line + n*spacing > eff_max)
				skip(NORMAL);
			}
		break;
	case 'x':
		sw_co(&sw_x);
		break;
	case '!': 
	case '|': 
		if(n >= version) 
		     sw_co(&sw_vers); 
		break; 
	case '.':
	case ',':
	case NULL:
		--ptr_1;
	case ' ': 
	case NL: 
		if((c = ptr_1[-1]) == ')')
		     putch(c);
		return; 
	default: 
		err("'%c' is an invalid command operand",c); 
		return; 
		} 
done:
	co_no = INVERT;
	}
}
 
 
co_reset()
{
/*
 * reset most command operands to their default state. 
 */
 
c_flush;
sw_u = sw_m = sw_f = sw_at = sw_x = OFF;
sw_ncap = sw_cap;
clear(&i_indent,sizeof i_indent);
clear(&h_indent,sizeof h_indent);
ptr_calc();
SETPTRS;
}
 
sw_co(p)
char *p;
{
 
/*
 * process a command operand switch.
 * if "-x" specified turn off x.
 * if "+x" specified turn on x.
 * otherwise invert x. 
 */ 
switch(co_no)
	{
case ON:
	*p = ON;
	break;
case OFF:
	*p = OFF;
	break;
case INVERT:
	*p = ! *p;
	break;
	}
}
 
 
getch()
{
register char c;
if(c = *ptr_1)
	++ptr_1;
return(c);
}
 
 
co_tabs(n,c)
char c;
{
/*
 * put a tab at column "n" dropping character "c". 
 */
register int k;
register int i;
 
k = ptr_3 -  (buff_3 + text_col) + 1;
if( n == 0 )
	{         /* go to next tab stop */
	for (i = 0; i < MAXTAB; ++i)
		{
		if( tabs[i] == 0)
		     {
	notab:
		     err("tab stop %d not set",i+1); 
		     return;
		     }
		if( k < tabs[i] )
		     goto gottab;
		}
	err("past last tab stop");
	return;
	}
 
else
	{         /* go to requested tab stop */
	if (sw_nl)	/* if line is empty then start tab at left column. */
		{
		ptr_3 = buff_3 + text_col;
		k = 1;
		}
	i = n-1;
gottab:
	if (i >= MAXTAB)
		{
		err("only %d tab stops",MAXTAB);
		return;
		}
	if(tabs[i] == 0)
		goto notab;
	if(k > tabs[i])
		{
		l_flush();
		ptr_3 = min_3;		/* start at left margin */
		k = 1;
		}
	while (k++ < tabs[i])
		*ptr_3++ = c;
	}
/* sw_nl = sw_np = OFF; /* */
}
 
conv()
{
/*
 * convert the following number to binary. 
 * an optional "+" or "-" is allowed.
 */
register int num;
register char c;
register int sign;
 
num = 0;
sign = 0;
c = *ptr_1++;
if (c == '+' || c == '-')
	{
	sign = c;
	c = *ptr_1++;
	}
while (DIGIT)
	{
	num = num * 10 + c - '0';
	c = *ptr_1++;
	}
--ptr_1;
if (sign == '-')
	num = -num;
return(num);
}
 
l_flush()
{
/*
 * routine to flush out the output buffer.
 * only thing to be done is to center the line if
 * it needs it and then call prntline.
 */

if(sw_m)
	 center();
prntline();
}

cskip()
{
if(columns == 1 || col_num == columns)
	skip(NORMAL);
else
	new_col(col_num+1);
}
 
center()
{
/*
 * center the line in buff_3 between ptr_m and ptr_3 between 
 * ptr_m and end_3. 
 */
 
register int l1, l2, k;
 
l1 = ptr_3 - ptr_m;               /* length of text present */
l2 = end_3 - ptr_m;               /* room to put it in */
k = l2 - l1;              	  /* amount to move it */
if(k <= 0 || (k /= 2) == 0)
	return;                       /* no hope */
smartmove(l1,ptr_m,ptr_m+k);
set(ptr_m,k,NTB);
ptr_3 += k;
}
 
 
do_indent(n,type)
{
/*
 * process either a hanging or a normal indent.
 */
 
register struct indent *p;
register int c;
 
p = (type == NORMAL) ? &i_indent : &h_indent;
c = *ptr_1;
if (c == '+' || c == '-')
	{
	c = ptr_1[1];
	if (DIGIT)
		{
		n = conv();
		p->hi_num = 0;
		p->hi_sw = (p->hi_left += n) ? ON : OFF;
		ptr_calc();
		co_no = p->hi_left != 0;
		return;
		}
	}
if(n == 0)
	{
	if(co_no == INVERT)
		co_no = ! p->hi_sw;
	}
else
	--n;                     /* make it a subscript */
 
if(n >= MAXIND)
	{
	err("maximum indent is %d",MAXIND);
	return;
	}
 
if (co_no == INVERT)
	co_no = p->hi_num != n || ! p->hi_sw;
switch(co_no)
	{
case ON:
	p->hi_sw = ON;
	p->hi_num = n;
	p->hi_left = indents[n][0];
	p->hi_right = indents[n][1];
	break;
 
case OFF:
	p->hi_sw = OFF;
	p->hi_num = 0;
	p->hi_left = p->hi_right = 0;
	break;
 
	}
ptr_calc();
}

asis(n)
{
/*
 * read lines in asis mode and output them directly to 
 * the output buffer. 
 * only process )u inside the buffer.
 */
register char *p;
register int i;
register int c;

c_flush;
if(n == 0)
	n = 9999;
for (i=0; i<n; ++i)
	{
	read_in();
		if(sw_list)
			list();
	if(buff_1[0] == ')' && (buff_1[1] == 0 || buff_1[1] == ' '))
		{
		buff_1[0] = ' ';
		return;
		}

	ptr_2 = buff_2;
	while (c = *ptr_1++)
		{
		if (c == '!' || c == '|')
			{
			if (*ptr_1 == c)
				++ptr_1;
			else
				{
				macros_etc();
				continue;
				}
			}
		else if (c == ')' && *ptr_1 == 'u')
			{
			sw_u = ! sw_u;
			++ptr_1;
			if (*ptr_1 == ' ')
				++ptr_1;
			continue;
			}
		else if (c == ')' && *ptr_1 == '@')
			{
			sw_at = ! sw_at;
			++ptr_1;
			if (*ptr_1 == ' ')
				++ptr_1;
			continue;
			}
		else if (c == '@')
			{
			if ((c = SUPER(*ptr_1)) == 0)
				c = ptr_1[-1];		/* just output the @ */
			else
				++ptr_1;		/* advance */
			}
		if (sw_at)
			UPPER(c);
		if (sw_u && c != ' ')
			c = UNDER(c);
		*ptr_2++ = c;
		}
	for (p=buff_2; p < ptr_2; )
		*ptr_3++ = *p++;
	ptr_2 = buff_2;
	prntline();
	}
}

top_line()
{
if(sw_np)
	  return(OK);
if(sw_nl && cnt_line + spacing > eff_max)
	  {
	   cskip();
	   return(OK);
	   }
return(FAIL);
}

co_o(n)
{
/*
 * expanded set of command operand options.
 */

switch(n)
	{
case 1:
	sw_ncap = ! sw_ncap;
	break;
	}
}

quadright()
{
register int l,k;

while (ptr_3[-1] == ' ' && ptr_3 > start_3)
	--ptr_3;
l = end_3-ptr_3;
k = ptr_3-start_3;
if (l > 0 && k > 0)
	{
	smartmove(k,start_3,start_3+l);
	set(start_3,l,NTB);
	ptr_3 += l;
	}
l_flush();
}
