#include "fmt.h"
/*			Copyright 1977 by Bill Webb.			*/
#include "fmtcc.h"
#include "fmtmac.h"
#include "fmthold.h"
#define	CCF	if (sw_cont) ccf
struct cc *find_cc(), *is_cc();

int deflines;		/* default lines/page */
int box_num;
struct value box_val IS
{
0, 1, MAXBOX, &box_num
};

struct vec box_vec IS
{
0, -128, 128, 0, MAXBCOL, 0
};
 
do_ccs()
{
register struct cc *cc;

while (sw_v)
	{
	setpfx('@');
	read_in();
	setpfx(' ');
	if(cc = find_cc())
		cc_process(cc);
	}
}
 
struct cc *is_cc(ccname) char ccname[8];
{
/*
 * determin if ccname is a valid control card keyword.
 */
register struct cc *cc;

for (ALLCCS)
	if(eq(ccname,cc->c_name))	/* test if initial substring */
		return(cc);
return(NULL);
}

struct cc *find_cc()
{
/*
 * process the current input line in buff_1.
 * return either a pointer to the cc structure found
 * if input line begins with "!" simulate a "call" cc.
 * or "FAIL".
 */
 
register struct cc *cc;
char ccname[8];
 
cc_no = ON;					/* ON until NO encountered */
if (*ptr_1 == '!' || *ptr_1 == '|')
	{
	++ptr_1;
	return(is_cc("call"));
	}
if(!getword(ccname,sizeof ccname,NORMAL))
	return(FAIL);
if(equal(ccname,"no"))
	{
	cc_no = OFF;
	getword(ccname,sizeof ccname,NORMAL);
	}
do
	{
	if (cc = is_cc(ccname))
		return(cc);
	}
while (getword(ccname,sizeof ccname,NORMAL));

ccerr("invalid control card");
if(!sw_ccinit) 
	cc_init(); 
push_input();           /* save current input line */
sw_v = OFF;
return(0);
}

cc_process(cc)
struct cc *cc;
{
/*
 * a control card has been located and its info is pointed to
 * by "cc". process that control card. 
 */

register int i,n,k;
int t;
char word[4];
struct hold *h;
char *old;
int col_flag;
int olderr = err_cnt;

++cc_cnt;
if (sw_cont)
	do_list(sw_term ? NL : ' ');
 
t = cc->c_type % CC_DIV;
n = cc->c_type / CC_DIV; 
col_flag = n % COL_DIV;
n = n / COL_DIV;

if(col_flag)
	end_col();		/* terminate multi-col output */
if (sw_cont)
	{
	if (sw_term)
		ccf("             ===>> %s ",cc->c_comment);
	else
		{
		while (listcol < 80)
			{
			listcol = (listcol& ~07)+8;
			ccf("\t");
			}
		ccf("===>> %s ",cc->c_comment);
		}
	}
 
old = ptr_1;
switch(t)
	{
case C_sw:              /* process a switch */
case C_rv:
	if(getword(word,4,NORMAL))
		{
		if(equal(word,"off"))
			cc_no = OFF;
		else if (equal(word,"on"))
			cc_no = ON;
		}
	cc = cc_sws + n;
	* cc->c_addr = (t == C_rv) ? ! cc_no : cc_no;
	CCF("*%s* ",cc_no ? "ON" : "OFF");

	break;
 
 
case C_value:

	value(cc_values + n);
	if(n == N_lines)
		line_calc();
	break;

case C_double:
	value(cc_values + n);
	value(cc_values + ++n);
	break;

case C_triple:
	if(equal(cc->c_name,"page"))
		{
		page.p_sw = cc_no;	/* set page printing switch */
		if (eol())
			{
			CCF("*%s* ",cc_no ? "ON" : "OFF");
			break;
			}
		}
	value(cc_values + n);
	value(cc_values + ++n);
	value(cc_values + ++n);
	break;

case C_vector:

	k = vector(cc_vecs + n);
	if(n == v_width)
		{
		switch (k)
			{
		case 0:
			ptr_1 = old;
			value(cc_values+8);
			k = 1;
			break;
		case 1:
			col_width = widths[0];
			break;
			}
		columns = k;
		}
	break;
 
case C_macro:
	if(!getword(mac_name,MAXMAC,MACNAME))
		ccerr("missing macro name");
	else
		{
		CCF("!%s! ",mac_name);
		switch(n)
			{
		case 0:             /* set */
			cc_set();
			break;
		case 1:             /* define */
			cc_def();
			break;
		case 2:             /* erase */
			mac_delete(mac_name);
			break;
		case 3:           /* load */
			cc_load(mac_name);
			break;
		case 4:		/* call */
			ptr_1 = old;		/* restore line position */
			do_macro();
			break;
			}
		break;
 
case C_misc:
	switch(n)
		{
	case 0:             /* go */
		if(!sw_ccinit)
			cc_init();
		sw_v = OFF;
		break;
	case 1:             /* comment */
		break;
	case 2:        /* clear macro defintions */
		mac_clear();
		break;
	case 3:        /* end of run */
		CCF("%c",NL);
		eof();
		break;
	case 4:       /* drop character */
		ignsp;
		drop_char = intchar('.');
		CCF(" '%c' (%d)",drop_char,drop_char);
		break;
	case 5:         /* box n = columns */
		if(value(&box_val))
			{
			CCF(" = ");
			box_vec.c_vec = boxes[box_num-1];
			vector(&box_vec);
			}
		break;
	case 6:		/* translate */
		getword(word,sizeof word,NORMAL);
		if (equal(word,"inp"))
			dotrans(intrans);
		else if (equal(word,"out"))
			dotrans(outtrans);
		else if (equal(word,"und"))
			dotrans(undtrans);
		else
			err("invalid translate table '%s'",word);
		}
	break;
 
 
case C_hold:
	switch(n)
		{

	case 7:   /* title */
		h = sw_rt ? &r_title : &l_title;
		break;
	case 8:   /* footer */
		h = sw_rt ? &r_footer : &l_footer; 
		break;
 
	default:
		h = holds[n];
		}
	i = getint(0);
	hold_start(h,i,getint(0));
	if (h == &footnote && i && h->h_cnt == 0)
		{
		copy(buff_1," )j0 -|@20 )l ");
		buff_1[3] += i;
		len = 0;			/* include it in the text */
		}
	break;
		}
	}
CCF("%c",NL);
listcol = 0;
seterr(sw_error);
ptr_1 = buff_1 + len;
if(col_flag)
	col_init(col_flag);			/* start multi_col again */
return(err_cnt-olderr);			/* indicate success/failure */
}
 
 
val_chk(k,min,max)
{
/*
 * insure that value "k" is inside the allowed value range. 
 * i.e. that k >= min && k<= max. 
 */

if(k < min)
	ccerr("value < %d",min);
else if(k > max)
	ccerr("value > %d",max);
else
	return(OK);
return(FAIL);
}

getword(name,length,flag)
char *name;
{
/*
 * collect a "word" (a word started by a letter and followed by 
 * alphanumerics and dots.
 * / is allowed as it is used in unix path names.
 * flag&FOLDCASE	case is ignored (folded to lower case). 
 * flag&FILENAME	allow filename characters
 */
register char *n;
register char c;
register char *p;
int l;
 
n = name;
p = ptr_1;
clear(n,length);
while (c = *p++)
	{
	if (flag&FOLDCASE)
		c = LC(c);
	if(ALPHA || c == '*')
		{
		do 
			{
			if(--length > 0)
			*n++ = c;
			c = *p++;
			if (flag&FOLDCASE)
				c = LC(c);
			}
		while (isalnum(c) || c=='.' || ((flag&FILENAME) && isfile(c)));
		--p;
		l = p-ptr_1;
		ptr_1 = p ;
		return(l);
		}
	}
ptr_1 = p-1;
return(FAIL);
}
 
 
getint(def)
{
/*
 * scan for and pick up the next integer value from
 * the line. 
 */
 
register char c;
register char *p;
register int num;
char sign;
 
sign = OFF;
num = def;		/* set default value */
p = ptr_1;
while (c = *p++)
	{
	if(c == '-')
		sign = ON;
	if(DIGIT)
		{
		num = 0;
		do
			{
			num = num * 10 + c - '0';
			c = *p++;
			}
		while (DIGIT);
		break;
		}
	}
ptr_1 = p - 1;
if(sign)
	num = -num;
return(num);
}
 
cc_set()
{
/*
 * process the "set" control card. 
 */
 
register char c;
register int l;
 
while (c = *ptr_1++) 
	{
	if(c == QT) 
		{
		--ptr_1;
		if( ( l = get_str(temp,MAXBUFF)) >= 0)
			{
			mac_create(mac_name,T_MACRO,temp,l);
			return;
			}
		else
			break;
		}
	} 
ccerr("invalid macro string"); 
}
 
cc_def()
{
/*
 * define macros of more than 1 line in length.
 */
 
register struct macro *m;
register int i;
register int n;
 
 
CCF("%c",NL);
m = mac_create(mac_name,T_MACRO," ",1); 
n = getint(NONE); 
if (rd_next == fn_cc)
	read_line();		/* ignore rest of invoking line if !define */
if(n != NONE) 
	{
	for (i=0; i<n; ++i) 
		{ 
		read_line();
		mac_append(m,buff_1,len); 
		} 
	}
else 
	{ 
	for (EVER)
		{ 
		read_in();
		if(buff_1[0] != '!' && buff_1[0] != '|') 
			break; 
		listing();
		mac_append(m,buff_1+1,len-1); 
		} 
	push_input();	/* put back into input buffer */
	} 
}
 
cc_init()
{
/*
 * routine to do first initialization and page skip after
 * first "go" control card. 
 */
ptr_calc();
SETPTRS;
skip(START);		/* eject first page */
sw_ccinit = ON;
sw_ncap = sw_cap;
}
 
 
 
init_ccs()
{
/*
 * using the appropriate tables initialize the control
 * card settable variables to their defaults. 
 */
 
register int i;
register int k;
 
for (i=0; ; ++i)
	{
	k = cc_dsws[i];
	if(k == LAST)
		break;
	if(k != IGNORE)
		*cc_sws[i] = k;
	}
 
cc_values[N_lines].c_default = deflines;	/* default lines/page */
for (i=0; cc_values[i].c_value; ++i)
	* cc_values[i].c_value = cc_values[i].c_default;

for (i=0; cc_vecs[i].c_vec; ++i)
	for (k=0; k<cc_vecs[i].c_count; ++k)
		cc_vecs[i].c_vec[k] = cc_vecs[i].c_default;

sw_v = ON;
col_width = width = 64;
page.p_sw = ON;
}
 
vector(v)
struct vec *v;
{
/*
 * get a vector of integers as specified by the vector structure. 
 * return the number of elements found. 
 */

register struct vec *n;
register int i,k;

n = v;

for (i=0; i< n->c_count; ++i)
	n->c_vec[i] = 0;

for (i=0; i< n->c_count; ++i)
	{
	if( ( k = getint(NONE)) == NONE)
		break;
	if(val_chk(k,n->c_min,n->c_max))
		{
		n->c_vec[i] = k;
		CCF(" %d",k);
		}
	}
return(i);
}


value(v)
struct value *v;
{
/*
 * get a single value as defined by the value structure. 
 * if its missing return the default value. 
 */
register struct value *n;
register int k;

n = v;

k = getint(n->c_default);

if(val_chk(k,n->c_min,n->c_max))
	{ 
	* n->c_value = k;
	CCF("%d ",k);
	return(OK);
	} 
return(FAIL);
}

eol()
{
while (*ptr_1 == ' ')
	++ptr_1;
return(*ptr_1 == 0);
}

intchar(n)
{
/*
 * return an integer representing either a single character
 * or an integer value. "n" is the default value to return if
 * nothing is specified.
 */

while (*ptr_1 == ' ')
	++ptr_1;
if (*ptr_1 == QT)
	{
	++ptr_1;
	n = *ptr_1++;
	if (*ptr_1 != QT)
		ccerr("quote expected");
	++ptr_1;
	}
else
	n = getint(n);
return(n);
}

dotrans(ptr) char *ptr;
{
register int i,j;

i = intchar(0)&0177;
j = intchar(i)&0177;
ptr[i] = j;
}

cc_load(name) char *name;
{
char file[32];
char fn_name[16];
register int l;

getword(file,sizeof file,FILENAME);
if ((l = getword(fn_name,sizeof fn_name,MACNAME)) > 0)
	fn_name[l] = 0;
else
	copy(fn_name,name);
def_fn(name,file,fn_name);
}
