#include "fmt.h"
/*			Copyright 1977 by Bill Webb.	 		*/
 
#define  BAR     0
#define  DASH   1
#define  CROSS     2
#define  UL   3
#define  UR   4
#define  LL   5
#define  LR   6
#define  LEFT   7
#define  RIGHT   8
#define  UP   9
#define  DOWN   10        /* down join (looking up) */
 

int boxcnt;

char boxchars[] IS
/* bar  dash cross ul  ur   ll    lr  left right up  down */
{ '!', '-', '*', '*', '*', '*', '*', '*', '*', '*', '*' };
 
#ifdef UNIX
#define MAXBCHARS 3
#endif
 
#ifndef UNIX
#define MAXBCHARS sizeof boxchars
#endif
 
char startchars[] IS
{ UL, DOWN, UR }; 
 
char linechars[] IS
{ BAR, BAR, BAR };
 
char endchars[] IS
{ LL, UP, LR };
 
 
 
char boxmatrix [sizeof boxchars] [sizeof boxchars] IS
{
/*        OLD:  BAR     DASH    CROSS   UL      UR      LL      LR      LEFT    RIGHT   UP      DOWN    */
/* NEW:  */ 
/* BAR   */     BAR,    CROSS,  CROSS,  LEFT,   RIGHT,  LEFT,   RIGHT,  LEFT,   RIGHT, CROSS, CROSS,
/* DASH  */     CROSS,  DASH,   CROSS,  DOWN,   DOWN,   UP,     UP,     CROSS,  CROSS, UP,     DOWN,
/* CROSS */     CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS, CROSS, CROSS,
/* UL    */     LEFT,   DOWN,   CROSS,  UL,     DOWN,   LEFT,   CROSS,  LEFT,   CROSS,  CROSS,  DOWN,
/* UR    */     RIGHT,  DOWN,   CROSS,  DOWN,   UR,     CROSS,  RIGHT,  CROSS,  RIGHT,  CROSS,  DOWN,
/* LL    */     LEFT,   UP,     CROSS,  CROSS,  LEFT,   CROSS,  UP,     CROSS,  CROSS, UP,    CROSS,
/* LR    */     RIGHT,  UP,     CROSS,  CROSS,  RIGHT,  UP,     LR,     CROSS,  RIGHT, UP,    CROSS,
/* LEFT* */     CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS, CROSS, CROSS,
/* RIGHT**/     CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS,  CROSS, CROSS, CROSS,
/* UP    */     CROSS,  UP,     CROSS,  CROSS,  CROSS,  UP,     UP,     CROSS,  CROSS, UP,    CROSS,
/* DOWN  */     CROSS,  DOWN,   CROSS,  DOWN,   DOWN,   CROSS,  CROSS,  CROSS,  CROSS, CROSS, DOWN
};


box_co(k)
{
 
register int n;
 
n = k-1;
if(n < 0 || n >= MAXBOX)
	{
	err("invalid box # %d",k);
	return;
	}
 
switch(co_no)
	{
case ON:
	on:
	if(!boxsws[n])
		boxstart(n);
	break;
 
case OFF:
	 off:
	if(boxsws[n])
		boxend(n);
	break;
 
case INVERT:
	if(boxsws[n])
		goto off;
	else
		goto on;
	}
}
 
 
boxstart(k)
{
register int n;

n = k;
 
if(boxcnt >= MAXBOX)
	{
	err("more than %d boxes",MAXBOX);
	return;
	}
 
++boxcnt;
++boxflags[n];
++boxsws[n];
boxgen(n, startchars);
}
 
boxend(n)
{

/*
 * end of box processing.
 */

boxsws[n] = 0;
boxgen(n, endchars);
--boxcnt;
}
 
boxline()
{
register int i;

for (i=0; i<MAXBOX; ++i)
	{
	if(!boxsws[i])
		continue;
	if(boxflags[i])
		boxflags[i] = 0;
	else
		boxgen(i,linechars);
	}
}

boxgen(n,chars)
char chars[3];
{
/*
 * generate a line using the columns of box "n" and using 
 * char[0]    left margin
 * char[1]    middle columns 
 * char[2]    right margin 
 */
 
register int i;
register int n1,n2;
int *p;

 
p = boxes[n];
 
 for (i=0; i<=MAXBCOL-1; ++i)
	{
	n1 = *p++;
	n2 = *p;
	if(n2 == 0)
		break;
	if(n1 > 0)
		overlay(n1,n1, i == 0 ? chars[0] : chars[1]);
	else
		n1 = -n1;
	if(n2 < 0)
		n2 = -n2;
	if(chars[0] != BAR)
		overlay(n1+1, n2-1, DASH);
	}
 
overlay(n1,n1,chars[2]);
sw_nl = sw_np = OFF;
}
 
overlay(n1,n2,c)
char c;
{
register int j;
register char *p;
 
n1 += text_col-1;
n2 += text_col-1;

for (p = buff_3+n1; p <= buff_3+n2; ++p)
	{
	if(*p == ' ' || *p == NTB)
		{
		*p = boxchars[c];
		continue;
		}
	for (j=0; j<MAXBCHARS; ++j)
		{
		if(*p == boxchars[j])
			{ 
			*p = boxchars[ boxmatrix[ c ][ j ] ];
			break;
			}
		} 
	}
if(p > maxb_3) 
	maxb_3 = p;
}
