#
/*			Copyright 1977 by Bill Webb.				*/

#define UNIX 1		/* generate unix version */
#define	IS	=	/* for easy v6 compatibility */

#ifndef V6
#define	DUMMYVEC	(sizeof (int))
#else
#define	DUMMYVEC	0
#endif

#include <ctype.h>

#define NL '\n'
#define LC(c) (isupper(c) ? c - ('A' - 'a') : c)
#define LOWER if(isupper(c)) c -= 'A' - 'a'
#define SUPER(c) super(c)       /* return superscript of c */
#define UNDER(c)	 (c | 0200)       /* return underline of c */
#define NOUNDER(c)	 (c&0177)
#define UC_c (islower(c) ? c - ('a' - 'A') : c)
#define UPPER(c) if(islower(c)) c -= 'a' - 'A'
#define CR '\r'
#define HT '\t'
#define NTB 01
#define UCHAR '_'

#define QT '\''			/* quote character */
#define DIGIT (isdigit(c))
#define ALPHA (isalpha(c))

#define EVER ;;
#define NULL 0
#define	setpfx(ch)	/* no setpfx routine */

#define MAXBUFF 256
char buff_1[MAXBUFF];
char buff_2[MAXBUFF];
char buff_3[MAXBUFF];

int len;		/* length of line in buff_1 (w/out 0) */

char *ptr_1;		/* current position in buff_1 */
char *ptr_2;		/* current position in buff_2 */
char *ptr_3;		/* current position in buff_3 */
char *start_3;		/* current starting text position */
char *end_3;			/* current ending text position */
char *min_3;			/* starting text ptr before indents */
char *max_3;			/* ending text ptr before indents */
char *maxb_3;			/* maximum box extention of ptr_3 */
char *ptr_m;			/* current centering start pointer */

#define OFF 0
#define ON  1
#define INVERT 2
#define IGNORE 3

struct text 
{
struct text *t_next;
int t_len;
char t_text[DUMMYVEC];
};

#define HANG	1	/* hanging indent flag */
#define NORMAL	0	/* normal indent */
#define	START	1
#define	END	2
#define FAIL 0		/* couldn't do it */
#define OK   1		/* did it */

int counters[6];			/* !f counters */

char sw_super;			/* super fmt mode */
char sw_tn;			/* tn train present */
char sw_pn;			/* pn train present */
char sw_keyp;			/* special keypunch */
char sw_gene;			/* generate )l's */
char sw_list;			/* list input */
char sw_numb;			/* number printout from source */
char sw_cont;			/* control card listing */
char sw_save;			/* save macro definitions */
char sw_cycle;			/* cycle page numbers */
char sw_hyph;			/* hyphenate automatically */
char sw_rt;			/* right hand page */
char sw_rep;			/* repeat titles */
char sw_just;			/* justification */
char sw_cap;			/* automatic capitalization */
char sw_over;			/* allow overprinting */
char sw_full;			/* full source listing */
char sw_under;			/* underline blanks */
char sw_simp;			/* simple cc */
char sw_error;			/* errors in line */
char sw_debug;			/* print debug info */
char sw_short;			/* short printer */
char sw_term;			/* terminal output device */
char sw_front;			/* front page eject */
char sw_bold;			/* bold print */

char sw_at;	/* @ command operand */
char sw_u;		/* u command operand */
char sw_m;		/* m " */
char sw_x;		/* x */
char sw_f;		/* f */
char sw_scan;      /* current justify scan direction */
char sw_ncap;      /* cap next word */
char sw_v;			/* in control card mode */

char sw_nl;
char sw_np;

char sw_vers;
char sw_v2;			/* copy of version switch */

int err_cnt;			/* current number of errors */
int lines_cnt;				/* number of printed lines */
int word_cnt;				/* number of words output */
int in_cnt;
int cc_cnt;
int read_cnt;				/* input read counter */
int gen_cnt;				/* lines generated counter */
int page_cnt;			/* number of pages printed */

#define MINNN 10
#define MAXNN 55

char mac_ind;		/* input line type indicator */
char sw_dlist;		/* line has been listed */
char sw_mcase;		/* macro case is important */

int (*v_lib) ();
int (*v_page) ();

#define MAXTAB 20 
int tabs[MAXTAB];

#define MAXIND 10 
int indents[MAXIND][2];

int spacing;		/* single/double etc. */
int word_space;		/* # of blanks between words */
int version;		/* version number */
int p_ind;		/* paragraph indent */
int p_sep;		/* paragraph separation */
int sent_space;		/* # of spaces at end of sentence */
int dark;		/* number of printings for dark copy */

int col_width;
int width;

int col_num;		/* current column number */
int columns;		/* number of columns */
int physline;
int cnt_line;			/* current logical output line number */
int line_max;

int text_info[2];       /* text line, print position */
int card[2];		/* card limits */

#define text_line text_info[0]
#define text_col text_info[1]

#define card_min card[0]
#define card_max card[1]

struct indent
{
char hi_sw;		/* indent in effect */
char hi_num;		/* current indent number */
int hi_left;		/* current left indent value */
int hi_right;		/* current right indent value */
} h_indent, i_indent;

#define i_left i_indent.hi_left
#define i_right i_indent.hi_right
#define h_left h_indent.hi_left
#define h_right h_indent.hi_right

struct page 
{
int p_page;		/* current page number */
int p_line;		/* line number to put page on */
int p_disp;		/* location in line */
int p_old;		/* previous page number */
char p_sw;		/* if printing page number */
char p_osw;		/* old page switch */
#define	PAGE_SIZE	8
char p_out[PAGE_SIZE];	/* page number converted */
int p_y;		/*  where to put page number in the line */
char *p_addr;		/* address of current page text */
int p_len;		/* current page text length */
int p_oline;		/* previous line value */
int p_incr;		/* page number increment */
int p_save;		/* saved page number */
} page;


char nntab[];
int line;			/* input line number */
char drop_char;
char cc_no;
char co_no;

#define MAXCOL 6	/* number of text columns */
int widths[MAXCOL];
int gaps[MAXCOL];

#define SETPTRS ptr_m = ptr_3 = start_3
#define c_flush {if(!sw_nl) l_flush();}
#define ignsp while (*ptr_1 == ' ') ++ptr_1
#define read_line() { read_in(); listing(); }
#define listing() if((mac_ind!='+' || sw_full) && sw_list) list()
#define I_CLEAR i_left = i_right = h_left = h_right = 0

int eff_max;		/* effective maximum line on page */

#define MAXBOX 10	/* maximum box number */
#define MAXBCOL 20	/* maximum box columns */
#define	BOXSIZE (MAXBOX * MAXBCOL)	/* number of elements in boxes */

int boxes[MAXBOX][MAXBCOL];
char boxsws[MAXBOX];	/* if box is on (and the order) */
char boxflags[MAXBOX];	/* if this the first line of box */
int boxcnt;		/* number of boxes in use */

#define out_put (*out_addr)	/* to proper output routine */
int (*out_addr)();
extern ldivr;
char temp[MAXBUFF*2];		/* temporary buffer */
#define MAXCHAR	128		/* number of characters in character set */
char intrans[MAXCHAR];		/* input translate table */
char outtrans[MAXCHAR];		/* output translate table */
char undtrans[MAXCHAR];		/* output translate table */
int listcol;			/* current listing column */

#define	alloc(n)	malloc(n)
char *malloc();

#define	WORD_END	0
#define	WORD_HYPHEN	1
#define	WORD_CHYPHEN	2

#ifdef DEBUG
#define DEBUGV(var) if (sw_debug) printf("var=%d (0%o)\n",var,var)
#define	DEBUGF(x) if (sw_debug) printf x
#else
#define	DEBUGV(var)		/* nothing */
#define	DEBUGF(var)		/* nothing */
#endif
char *endstr();
#define	ccerr	err	/* use normal error routine */
