#
#include "fmt.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "fmtmac.h"
#include "fmtfns.h"

int vflag;		/* 1 if invoked as countv */

#define MAXCTR 32		/* maximum number of counters */

typedef int (*CVTFN)();

struct counter 
{
char ct_name[10];	/* name of the counter */
CVTFN ct_cvt;		/* function to do it */
int ct_value;		/* current value */
int ct_incr;		/* increment amount */
int ct_fill;	/* fill character */
int ct_length;		/* length of fill sequence */
} ctrs[MAXCTR];


#define	CVT(name,rtn) name, rtn 
struct cvt cvts[] IS
{
CVT("integer",i_cvt),
CVT("octal",o_cvt),
CVT("name",name),
CVT("alpha",alpha),
CVT("hexadec",h_cvt),
CVT("roman",roman),
CVT("dummy",dummy),
CVT(NULL,dummy)		/* null entry */
};

CVTFN getcvt(word) char *word;
{
register struct cvt *p;

for (p = cvts; p->cv_name; ++p)
	if(equal(p->cv_name,word))
		return(p->cv_rtn);
return(NULL);
}

count()
{
register struct counter *ctr;
register char *p;
struct counter *getctr();
int n;
int incr;
char word[10];
int (i_cvt)();

/*
 * count function - return the next value of the counter
 * in the appropriate format. 
 */

fn_word(word,8);
if ((ctr = getctr(word)) == NULL)
	{
	err("count: out of counters");
	return(FAIL);
	}
if (*fn_ptr != ')')
	{
	if(fn_int(&n))			/* get initial value */
		ctr->ct_value = n; 	/* set value */
	if (fn_int(&incr))
		ctr->ct_incr = incr;		/* got increment */
	if(fn_word(word,8) <= 0)
		return(OK);			/* no conversion type */
	lctran(word);
	if ((ctr->ct_cvt = getcvt(word)) == NULL)
		{
		err("count: invalid conversion type");
		return(FAIL);
		}
	if (fn_int(&n))
		ctr->ct_length = n;
	if(fn_str(word,2) > 0)
		move(2,word,&ctr->ct_fill);
	return(OK);
	}
/* output a value to input steam */
if(vflag)
	ctr->ct_value -= ctr->ct_incr;
p = buff_1 + ctr->ct_length;		/* reserve enough space */
n = (*ctr->ct_cvt)(p,ctr->ct_value);
ctr->ct_value += ctr->ct_incr;
while (n < ctr->ct_length)
	{
	*--p = ctr->ct_fill;		/* put in fill character */
	n++;
	}
fn_put(p,n);
return(OK);
}

countv()
{
register int i;

vflag = 1;
i = count();
vflag = 0;
return(i);
}

i_cvt(p,n) char *p;			/* convert integer */
{
return(num_cvt(p,n,10));
}

o_cvt(p,n) char *p;			/* convert octal */
{
return(num_cvt(p,n,010));
}

h_cvt(p,n) char *p;			/* convert hex */
{
return(num_cvt(p,n,16));
}

num_cvt(p,n,base) char *p;
{
/*
 * convert "n" to ascii in base "base" into buffer "p".
 * return the resulting length.
 */
register int k;
register int rem;

k = ldiv(0,n,base);
rem = ldivr;
if(k)
	k = num_cvt(p,k,base);
p[k] = "0123456789abcdef"[rem];
return(k+1);
}


char romanletters[] IS {'v'+0200,'m','d','c','l','x','v','i', 0 };
roman(ptr,n) char *ptr;
{
/*
 * convert "n" to roman numerals in buffer "ptr".
 * return the resulting length.
 */
register int i, j;
register char *p;
int k;

p = ptr;
k = 1000;
for (i=0; romanletters[i]; i += 2)
	{
	j = n/k;
	n = n%k;
	k /= 10;
	switch(j)
		{
	case 0:
	case 1:
	case 2:
	case 3:
		while (--j >= 0)
			*p++ = romanletters[i+1];
		break;
	case 4:
		*p++ = romanletters[i+1];	/* 1 digit */
		*p++ = romanletters[i];		/* 5 digit */
		break;
	case 5:
	case 6:
	case 7:
	case 8:
		*p++ = romanletters[i];		/* 5 digit */
		while (--j >= 5)
			*p++ = romanletters[i+1];	/* 1 digit */
		break;
	case 9:

		*p++ = romanletters[i+1];	/* 1 digit */
		*p++ = romanletters[i-1];	/* 1 digit */
		break;
		}
	}

*p = 0;
return(p-ptr);
}

alpha(p,n) char *p;				/* convert "n" to alpha */
{
register int k;

k = ldiv(0,n,26);
if(k)
	k = alpha(p,k);
p[k] = ldivr+'a'-1;
return(k+1);
}

char *digits[] IS
{ "zero", "one", "two", "three", "four", "five", "six", "seven",
"eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen",
"fifteen", "sixteen", "seventeen", "eightteen", "nineteen" };

char *tens[] IS
{ "twenty", "thirty", "forty", "fifty", "sixty", "seventy", 
"eighty", "ninety"};

name(p,n) char *p;			/* store name of number "n" */
{
register int k;
register int d;

k = n%99;
if(k >= 20)
	{
	copy(p,tens[k/10-2]);
	if(d = k%10)
		{
		append(p,"-");
		append(p,digits[d]);
		}
	}
else
	copy(p,digits[k]);
return(length(p));
}

dummy()
{
return(0);
}

struct counter *getctr(word) char *word;
{
register struct counter *ctr;

for (ctr = ctrs; ctr < ctrs + MAXCTR; ++ctr)
	{
	if (equal(word,ctr->ct_name))
		return(ctr);
	if(ctr->ct_name[0] == 0)
		{				/* new definition */
		move(8,word,ctr->ct_name);
		ctr->ct_value = ctr->ct_incr = 1;
		ctr->ct_cvt = i_cvt;
		ctr->ct_fill = NTB;
		ctr->ct_length = 0;		/* no fill length */
		return(ctr);
		}
	}

return(NULL);
}
