#include "fmt.h"
/*			Copyright 1977 by Bill Webb.	 		*/

/*
 * NOTE:
 * the routines in this file control allocation of space on the 
 * fmt parameter stack.
 * you may have to redefine the "align" macro if your system has
 * different allignment restrictions, or if the space vector
 * space is not automatically alligned so that pointers can be stored
 * into it.
 */
#define	align(ptr,size) ptr = (ptr + size - 1) & ~ (size -1)	/* align to given boundry  */

#define ralloc alloc
#define rfree free

#ifdef DEBUG
#define	tracef(x)	if(trace) printf x
#else
#define	tracef(x)	/* no tracing */
#endif

int trace IS 0;
char *palloc();

#ifdef RT11
#define PMAX	256
#else
#define PMAX	1024
#endif

char pspace[PMAX];
char *p_ptr IS pspace;
char *p_high;			/* high water mark */

pinit()
{
p_ptr = pspace;
}


char *palloc(size)
{
/*
 * allocate a parameter on the parameter stack. filo assumed.
 * store backwards pointer to allow easy popping of the top
 * entry.
 */

register char *p;

p = p_ptr;		/* save pointer to allocated space */
size = align(size,(sizeof (char *)));
p_ptr += size;
if(p_ptr > p_high)
	p_high = p_ptr;	/* keep high water mark */
if(p_ptr >= pspace + PMAX)
	error("palloc: out of p stack");
/* ### "fmtmac.c", line 891: lvalue required @@@ */
*( (char **) p_ptr)  = p;	/* keep the link pointer */
p_ptr += sizeof (char **);
tracef(("palloc: %d bytes ==> %o\n",size,p));
return(p);
}


pfree(p) register char *p;
{
/*
 * free the top of the "p" stack.
 * test to see that we free the stack in the proper order.
 */
tracef(("pfree: %o\n",p));
/* ### "fmtmac.c", line 905: lvalue required @@@ */
/* ### "fmtmac.c", line 905: warning: illegal combination of pointer and integer @@@ */
p_ptr -= (sizeof (char **));
if(*((char **) p_ptr) != p)
/* ### "fmtmac.c", line 906: warning: struct/union or struct/union pointer required @@@ */
	error("pfree: not filo (got %o not %o)",p,* (int *) p_ptr);
p_ptr = p;
}

nospace(ptr) char *ptr;
{
error("%s: out of memory",ptr);
}
