#include "fields.h"


testvalue(cnd) struct cnd *cnd;
{
register char *q;
register struct field *f;
register int i;
double d;
 
f = cnd->c_field;
q = outbuff + f->addr;
switch(f->type)
	{
case CHAR:
	i = (* (char *) q) - atoi(cnd->c_value);
	break;
case INT:
	i = (* (int *) q) - atoi(cnd->c_value);
	break;
case LONG:
case TIME:
	i = (* (long *) q) - atof(cnd->c_value);
	break;
case FLOAT:
	d = (* (float *) q) - atof(cnd->c_value);
	i = 0;
	if (d > 0.0)
		++i;
	else if (d < 0.0)
		--i;
	break;
case DOUBLE:
	d = (* (double *) q) - atof(cnd->c_value);
	i = 0;
	if (d > 0.0)
		++i;
	else if (d < 0.0)
		--i;
	break;
case STRING:
	i = strncmp(q,cnd->c_value,f->size);
	break;
default:
	err("cannot test type %d",f->type);
	}
switch(cnd->c_cmp)
	{
case EQ:
	return(i == 0);
	break;
case NE:
	return(i != 0);
	break;
case GT:
	return(i > 0);
	break;
case LT:
	return(i < 0);
	break;
case GE:
	return(i >= 0);
	break;
case LE:
	return(i <= 0);
	break;
	}
err("invalid conditional");
}


getcnd(cnd,argp) register struct cnd *cnd; char *argp;
{
register int i = -1;
char *oargp = argp;

cnd->c_var = 0;
cnd->c_flg = 0;
if (*argp == '$')
	{
	++argp;
	cnd->c_var = cvtint(&argp) - 1;
	}
switch(*argp++)
	{
case '\0':
	return;		/* no condition attatched */
case '=':
	if (*argp == '=')
		++argp;
	i = EQ;
	break;
case '!':
	if (*argp++ == '=')
		i = NE;
	break;
case '<':
	if (*argp == '=')
		{
		++argp;
		i = LE;
		}
	else
		i = LT;
	break;
case '>':
	if (*argp == '=')
		{
		++argp;
		i = GE;
		}
	else
		i = GT;
	break;
	}
if (i == -1)
	err("invalid test conditional %s",oargp);
cnd->c_cmp = i;
cnd->c_value = strsave(argp);
cnd->c_flg++;
if (cdone)
	fixcnd(cnd);		/* if already compiled then fix it up */
}

cvtint(ptr) char **ptr;
{
register int n = 0;
register char *p = *ptr;
register int base = *p == '0' ? 010 : 10;

while (isdigit(*p))
	n = n * base + *p++ - '0';
*ptr = p;
return(n);
}

fixcnd(cnd) register struct cnd *cnd;
{
/*
 * go thru the conditional and fix the field pointer.
 * note that $n is relative to the output fields only.
 */
register struct field *f;
register int i;

if (cnd->c_flg == 0)
	return;		/* not conditional */
for (f = first, i = 0; f; f = f->next, ++i)
	{
	if (cnd->c_var == i)
		{
		cnd->c_field = f;
		return;
		}
	}
err("variable $%d not in record",cnd->c_var);
}

