#include "fields.h"

printfields()
{
register struct field *p;
register char *q;
register int i;
static char temp[4];

for (p=first; p; p = p->next)
	{
	if (p->addr >= 0)
		q = outbuff + p->addr;
	else
		q = (char *) &NR;	/* handle record pointer */
	switch(p->type)
		{
	case INT:
		printf(p->outstr,* (int *)q);
		if (*p->expand)
			expand(p->expand,* (int *) q);
		break;
	case LONG:
		printf(p->outstr,* (long *)q);
		break;
	case FLOAT:
		printf(p->outstr,* (float *)q);
		break;
	case DOUBLE:
		printf(p->outstr,* (double *)q);
		break;
	case STRING:
		if (!zflg)
			btrim(q,p->size);
		printf(p->outstr,q + p->offset);
		break;
	case CHAR:
		i = * (char *)q;
		if (p->sfmt[1] != 'd')
			i &= 0377;		/* mask down to a byte */
		printf(p->outstr,i);
		if (*p->expand)
			expand(p->expand,i);
		break;
	case RAD50:
		rad50( * (int *) q, temp);
		printf(p->outstr, temp + p->offset);
		break;
	case MODE:
		printf(p->outstr, prmode(* (int *) q) + p->offset);
		break;
	case TIME:
		printf(p->outstr, ctime((long *) q) + p->offset);
		break;
	case NONE:
		printf(p->outstr);
		break;
		}
	}
}

out_build()
/*
 * build the output list, normally it is the same as the list of
 * items, but can be overriden with a -Olist.
 * list is of the form: item,item,item
 * where "item" is either $n or name
 * name is matched against name= on the record.
 */
{
}

expand(str,value) register char *str;
{
/*
 * given a list of the format: value | string, ...
 * for value = string, ...
 * scan thru and print out any matches.
 */
char *p;
register int flag, n;

for (; *str; ++str)
	{
	if (*str == '-' || isdigit(*str))
		{
		p = str;
		n = cvtint(&p);
		str = p;
		}
	else
		err("invalid encode string '%s'",str);
	switch(*str++)
		{
	case '&':
		flag = (n&value) == n;
		break;
	case '=':
		flag = n == value;
		break;
	default:
		err("invalid encode operator '%s'",str-1);
		}
	if (flag)
		putchar(' ');
	for  ( ;*str && *str != ',' && *str != ';'; ++str)
		{
		if (flag)
			putchar(*str);
		}
	if ((flag && *str == ';') || *str == 0)
		return;		/* got required value */
	}
}
