#include "fields.h"

strxcpy(to,len) register char *to; register int len;
{
/*
 * copy the string pointed to by inptr into the region
 * pointed to by "to". copy at most "len" characters.
 */
register char *p = inptr;
char delim;

if (*p == '"' || *p == '\'')
	delim = *p++;
else
	delim = ',';
while (*p && *p != delim)
	{
	if (len)
		{
		*to++ = *p++;
		--len;
		}
	else
		++p;
	}
if (*p && delim != ',')
	++p;
while (len--)
	*to++ = 0;		/* clear rest to nulls */
inptr = p;
}

struct nlist
{
char n_name[8];
int n_type;
unsigned n_value;
} nl[2];

reference(file) char *file;
{
/*
 * allow reference of the form:
 * -sfile@name
 * specifying that the offset is that of symbol "name" in file "file".
 */
register char *name = any(file,"@");

if (name == NULL)
	err("no @ in -s%s",file);
*name++ = 0;		/* make it into two strings */
if (tflg)
	printf("nlist %s %s\n",name,file);
strncpy(nl[0].n_name,name,8);
nlist(file,nl);
if (nl[1].n_type == -1)
	err("invalid namelist file %s",file);
if (nl[0].n_type == -1)
	err("no name list entry for %s",name);
if (tflg)
	printf("symbol %s: addr %o type %o\n",nl[0].n_name,nl[0].n_value,nl[0].n_type);
fileoffset = nl[0].n_value;
*--name = '@';		/* for ps */
}

#define	DIR_UPDATE	3	/* UBC kludge for root writing directories */
FILE *uopen(file) char *file;
{
/*
 * open file "file" for output.
 * normally use "fopen", unless the dflg indicates a special-purpose
 * directory update.
 */
register FILE *f;
register int i;

if (file == NULL)
	return(NULL);
if (dflg)
	{
	if ((i = open(file,DIR_UPDATE)) < 0)
		return(0);
	f = fdopen(i,"a");
	}
else
	f = fopen(file,"a");
return(f);
}

ebcasc(buff,length) register char *buff; register int length;
{
extern char etoa[];
while (--length)
	*buff++ = etoa[*buff &0377];
}

