#include "fields.h"

/*
 * fields [-f prog] -sws file ...
 * switches:
 * -Ifile	input file
 * -f prog	prog contains the program string
 * -F prog	/usr/lib/fields/prog has the program
 * -a		use all fields even if output suppressed
 * -o#		origin for edit records is "#" (default=1)
 * -icnd	ignore condition
 * -ecnd	end condition
 * -lcnd	last condition
 * -x		use blank padding
 * -z		zero pad
 * -u		update/edit mode
 * -d		open directory for update (UBC system mod required)
 * -e		record is in ebcdic translate to ascii
 * -Olist	output only those fields given in the list
 * 
 */

char *types[] IS
{ "none", "int", "long", "float", "double", "string", "char", "time", "mode",
"rad50"
};

int origin IS 1;		/* origin of the indicies */


main(argc,argv) char **argv;
{
char *argp;
extern int errno;

--argc;
++argv;
if (argc < 1)
	err("usage: %s [-f] prog [file ...]",argv[-1]);
while (argc > 0)
	{
	--argc;
	argp = *argv++;
	if (*argp == '+')
		getoffset(argp+1);
	else if (*argp == '-')
		doswitch(argp);
	else
		{
		if (!cdone)
			{
			if (fflg || Fflg)
				{
				if(Fflg || (prog = fopen(argp,"r")) == NULL)
					{
					sprintf(libfile,"/usr/lib/fields/%s",argp);
					if((prog = fopen(libfile,"r")) == NULL)
						err("Can't open %s",argp);
					errno = 0;	/* prevent spurluous complaints */
					}
				getch = getfile;
				}
			else
				{
				progp = argp;
				getch = getarg;
				}
			compile();
			if (prog)
				fclose(prog);
			prog = NULL;
			++cdone;
			}

		else
			dofile(argp);
		}
	}
if (count == 0)
	{
	if (infile[0])
		dofile(infile);
	else
		{
		if (uflg)
			err("can't -u standard input");
		if (gflg)
			err("can't -g standard input");
		process(stdin);
		}
	}
flush();
exit(0);
}

dofile(argp) char *argp;
{
/*
 * process the file in "argp"
 * and clean up afterwards.
 */
curfile = argp;
if((f = fopen(argp,"r")) == NULL)
	err("Can't open %s",argp);
if (gflg)
	getrecs(f);
else
	process(f);
++count;
fclose(f);
f = NULL;
if (outfile != NULL)
	fclose(outfile);
outfile = NULL;
}

getoffset(argp) char *argp;
{
offset = cvtint(&argp);
switch(*argp++)
	{
case '*':
case 'x':
	offset *= cvtint(&argp);
	break;
case 'k':
	offset *= 1024;
	break;
case 'b':
	offset *= 512;
	break;
case 'w':
	offset *= 2;
	break;
case 'r':
	if (reclen == 0)
		err("no record length defined");
	offset *= reclen;
	break;
case 0:
	break;
default:
	err("invalid scale factor");
	}
fileoffset = offset;
}

doswitch(argp) register char *argp;
{
/*
 * process a switch.
 */
if (*argp++ != '-')
	err("invalid switch %s",argp-1);
switch(*argp++)
	{
case 'O':
	outlist = strsave(argp);
	break;
case 'I':
	copy(infile,argp);
	break;
case 'g':		/* get particular records */
	++gflg;
	break;
case 'E':
	++eflg;			/* translate EBCDIC to ASCII */
	break;
case 'a':			 /* use all fields, even suppressed ones */
	++aflg;
	break;
case 'o':			/* edit origin */
	origin = atoi(argp);
	break;
case 'n':			/* number of records */
	nrecs = atoi(argp);
	break;
case 'x':			/* replace nulls with blanks (Fortran) */
	++xflg;
	break;
case 'd':
	++dflg;			/* directory update mode */
	break;
case 'u':			/* update (edit) mode */
	++uflg;
	break;
case 'z':			/* replace trailing blanks with nulls */
	++zflg;
	break;
case 'i':			/* ignore condition */
	getcnd(&icnd,argp);
	break;
case 'e':			/* end condition */
	getcnd(&ecnd,argp);
	break;
case 'l':			/* last condition */
	getcnd(&lcnd,argp);
	break;
case 't':			/* trace */
	++tflg;
	break;
case 'F':			/* force /usr/lib/fields/prog */
	++Fflg;
	break;
case 'f':			/* prog file follows */
	++fflg;
	break;
case 'c':			/* copy mode */
	++cflg;
	break;
case 's':			/* reference to symbol table name */
	reference(argp);	/* process the nlist */
	break;
case 'h':			/* -hheading print next string as heading */
	printf("%s\n",argp);
	break;
case 'r':
	++rflg;			/* keep the record number as $1 */
	field.addr -= sizeof NR;
	break;
default:
	err("invalid switch %s",argp-2);
	}
return(1);
}

getarg()
{
register int c;

if (c = lastch)
	{
	lastch = 0;
	return(c);
	}
c = *progp++;
if (c == 0)
	c = EOF;
return(c);
}

getfile()
{
register int c;

if (c = lastch)
	{
	lastch = 0;
	return(c);
	}
return(fgetc(prog));
}

