#include "fdb.h"
/*			Copyright 1979 by Bill Webb.	 		*/

findisn(sp,n) char *sp;
{
register char *s;
register char *p;
register int i;

s = sp;
if (s == 0)
	err("no active routine");
if (n > 0)
	{
	for (i=n; i<=s->f_maxisn;++i)
		{
		if (p = s->f_isns[i])
			return(p);
		}
	}
err("isn %d not in %s",n,s->f_name);
}

objlook(addr)
{
register char *s;

for (SCANSYM(s))
	{
	if(s->s_addr == addr)
		{
		switch(s->s_type&~GLOBAL)
			{
		case TEXT:
		case DATA:
		case BSS:
			return(s);
			}
		}
	}
return(0);
}

lookup(sname) char *sname;
{
register char *s;

for (SCANSYM(s))
	{
	if (equal(s->s_name,sname))
		return(s);
	}
return(0);
}

looksym(sname) char *sname;
{
register char *s;

if (s = lookup(sname))
	return(s->s_addr);
err("%s not found",sname);
}

lookvar(sp,sname) char *sname; char *sp;
{
/*
 * look up variable "sname" in routine "sp".
 */
register char *v;

for (SCANVAR(sp,v))
	if (equal(sname,v->v_name))
		return(v);
return(0);
}

scanisn(n)
{
/*
 * locate routine and isn # for address "n".
 */
register char *s;
register int i;

for (SCANSUBR(s))
	{
	if (n >= s->f_text && n <= s->e_text)
		{
		for (i=1; i<s->f_maxisn; ++i)
			{
			if (n == s->f_isns[i])
				{
				isnvalue = i;
				subrptr = s;
				return(1);
				}
			}
		}
	}
return(0);
}

srchsym(addr,mask,value)
{
/*
 * search symbol table for entry with address closest to
 * "addr". return its ptr.
 */
register char *s, *p;
register int diff;

diff = 32767; p = 0;
for (SCANSYM(s))
	{
	if (s->s_addr >= addr && (s->s_type&mask) == value &&
		s->s_addr-addr < diff)
		{
		p = s;
		diff = s->s_addr-addr;
		}
	}
return(p);
}

prevsym(addr,mask,value)
{
/*
 * search symbol table for entry with address closest to
 * (but not greater) than "addr".
 */
register char *s, *p;
register int diff;

diff = 32767; p = 0;
for (SCANSYM(s))
	{
	if (s->s_addr <= addr && (s->s_type&mask) == value &&
		addr-s->s_addr < diff)
		{
		p = s;
		diff = addr - s->s_addr;
		}
	}
return(p);
}
