#include "fdb.h"
/*			Copyright 1979 by Bill Webb.	 		*/

init(corefile) char *corefile;
{
register char *s;
register char *p;
register int n;
int flag;

nopsinit();			/* initialize the nops table */
symdes = open(file,0);
if (symdes < 0)
	err("can't open %s",file);
coreinit(corefile);
read(symdes,hdr,sizeof hdr);
if (hdr[0] != 0407)
	err("not object file");
if (hdr[4] == 0)
	err("no symbol table");
symtab = sbrk(hdr[4]);
symend = symtab+hdr[4];
seek(symdes,hdr[1],1);
seek(symdes,hdr[2],1);
read(symdes,symtab,hdr[4]);

readsyms();
/*
 * scan thru symbol table and pick up all fortran routine names
 * and create table entry for them.
 */
for (SCANSYM(s))
	{
	if (s->s_name[0] == '&')
		{
		copy(name,s->s_name+1);
		p = looksubr(name,CREATE);
		}
	if (pflg > 1)
		printf("%-8.8s %6o %6o\n",s->s_name,s->s_type,s->s_addr);
	}
/*
 * scan thru the symbol table and set the limits for the fortran routines.
 */
for (SCANSYM(s))
	{
	if ((s->s_type & GLOBAL))
		{
		move(7,s->s_name+1,name);
		if (p = looksubr(name,LOOKUP))
			{
			switch(s->s_name[0])
				{
			case '_':
				p->f_text = s->s_addr;
				break;
			case '&':
				p->f_data = s->s_addr;
				break;
			case '@':
				p->f_bss = s->s_addr;
				break;
				}
			}
		}
	}
fixcm();			/* fix up common blocks */
/*
 * scan thru the symbol table and pick up the ISN's that are defined by
 * the symbol table.
 */
for (flag=0; flag < 2; ++flag)
	{
	for (SCANSYM(s))
		{
		if (s->s_name[0] == '_' && s->s_name[1] == '_' &&
			(n = cvtint(s->s_name+2)) && (p = findsubr(s->s_addr)))
			{
			setisn(p,n,flag,s->s_addr);
			}
		}
	}
/*
 * scan thru the subroutine list and set the limit of each space by looking
 * for the next global symbol.
 */
for (SCANSUBR(s))
	{
	if (p = srchsym(s->f_text+1,GLOBAL,GLOBAL))
		s->e_text = p->s_addr;
	if (p = srchsym(s->f_data+1,GLOBAL,GLOBAL))
		s->e_data = p->s_addr;
	if (p = srchsym(s->f_bss+1,GLOBAL,GLOBAL))
		s->e_bss = p->s_addr;
	}
initvars();
for (SCANSUBR(s))
	{
	if (s->f_isns == 0)
		scisns(s);
	printf("%s: %d isns ",s->f_name,s->f_maxisn);
	if (pflg)
		{
		printf("text=%o data=%o bss=%o ",
		s->f_text,s->f_data,s->f_bss);
		printf(" etext=%o, edata=%o, ebss=%o",
		s->e_text,s->e_data,s->e_bss);
		}
	for (SCANVAR(s,p))
		if (pflg)
			printf(" %.7s",p->v_name);
	printf("\n");
	cursubr = s;
	}
}

initvars()
{
/*
 * search symbol table for local variables that appear inside
 * a fortran subroutine.
 */
register char *s, *p;
char *v;
register int i;
struct sbvar var;
char *subrp;
#define	SUBSIZE	(sizeof var.v_subs[0])

for (SCANSYM(s))
	{
	if ((s->s_type==DATA || s->s_type==BSS) && s->s_name[0] == '_')
		{
		if ((p = prevsym(s->s_addr,GLOBAL,GLOBAL)) &&
			(subrp = looksubr(p->s_name+1,LOOKUP)))
			{
			clear(&var,VARSIZE);
			var.v_name = s->s_name+1;
			var.v_addr = s->s_addr;
			var.v_next = subrp->f_vars;
			p = s + SYMSIZE;
			if (p->s_name[0] == '^' && equal(p->s_name+1,s->s_name+1))
				{
				var.v_mode = p->s_addr.lo;
				var.v_nsubs = p->s_addr.hi&017;
				if (p->s_addr & 0100000)
					var.v_loc = 'p';
				if (var.v_mode=='s' && (p+SYMSIZE)->s_name == '"')
					{
					p =+ SYMSIZE;
					var.v_size = p->s_addr;
					}
				s = p;
				p =+ SYMSIZE;
				for (i=0; i<var.v_nsubs; ++i)
					var.v_subs[i].lwb = var.v_subs[i].upb = 1;
				while ('1' <= p->s_name[0] && p->s_name[0] <= '9')
					{
					i = p->s_name[0]-'1';
					if (p->s_name[1] == 'u')
						var.v_subs[i].upb = p->s_addr;
					else if (p->s_name[1] == 'l')
						var.v_subs[i].lwb = p->s_addr;
					else break;
					s = p;
					p =+ SYMSIZE;
					}
				}
			i = VARSIZE+var.v_nsubs*SUBSIZE;
			v = zalloc(i);
			move(i,&var,v);
			subrp->f_vars = v;
			}
		}
	}
}


scisns(sp) char *sp;
{
/*
 * scan the executeable code for isn's.
 * and then store them.
 */
register int flag;
register int p;
register int w;

for (flag=0; flag < 2; ++flag)
	{
	curisn = 0;
	for (p=sp->f_text; p<sp->e_text; p =+ 2)
		{
		w = fetch(p);
		if (w == isn)
			{
			setisn(sp,++curisn,flag,p);
			}
		else if (w == lisn)
			{
			curisn = fetch(p+2);
			setisn(sp,curisn,flag,p);
			p =+ 2;
			}
		}
	}
}

setisn(sp,n,flag,addr) char *sp;
{
register char *p;

p = sp;
if (flag)
	{
	if (p->f_isns == 0)
		p->f_isns = zalloc((p->f_maxisn+1)*2);
	p->f_isns[n] = addr;
	}
else
	{
	if (p->f_maxisn < n)
		p->f_maxisn = n;
	}
}

readsyms()
{
isn = looksym("isn_");
lisn = looksym("lisn_");
bisn = looksym("bisn_");
blisn = looksym("blisn_");
seq = looksym("seq_");
errstop = looksym("errstop");
debug = looksym("debug");
errnum = looksym("errno");	/* error number in case of rerr call */
}

fixcm()
{
register char *p, *s;

/*
 * scan thru symbol table for common block definitions. if one is found
 * clobber it so that block data routines work properly.
 */
for (SCANSYM(s))
	{
	if (s->s_name[0] == '!')
		{
		for (SCANSYM(p))
			{
			if (p->s_name[0] == '_' && (p->s_type&GLOBAL) &&
				equal(s->s_name+1,p->s_name+1))
				{
				printf("common: %s %d\n",p->s_name+1,s->s_addr);
				clear(p,SYMSIZE);
				break;
				}
			}
		}
	}
}
