#include "fdb.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "ops.h"

long itol();
#define	DIGIT(c)	(c >= '0' && c <= '9')
#define	ALPHANUM(c)	alphanum(c)

double getrhs();	/* get value of an arg structure */

expr(arg1,side) struct arg *arg1;
{
float i1, i2;
register int op;
register int c;
struct arg arg2;

item(arg1,side);
while (op = getop())
	{
	if (side == LHS)
		badlhs();
	i1 = getrhs(arg1);
	item(&arg2,RHS);
	i2 = getrhs(&arg2);
	switch(op)
		{
	case ADD_OP:
		i1 = i1+i2;
		break;
	case SUB_OP:
		i1 = i1-i2;
		break;
	case MUL_OP:
		i1 = i1 * i2;
		break;
	case DIV_OP:
		i1 = i1 / i2;
		break;
		}
	arg1->a_type = EXPR;
	arg1->a_mode = mergemode(arg1->a_mode,arg2.a_mode);
	arg1->a_value = i1;
	}
if (side == RHS && arg1->a_type != EXPR)
	{
	arg1->a_value = getrhs(arg1);
	arg1->a_type = EXPR;
	}
return(OK);
}

mergemode(m1,m2)
{
/*
 * determine the results of merging modes "m1" and "m2".
 */
register int i1, i2;
i1 = getmode(m1);
i2 = getmode(m2);
if (m1 != m2 && (m1 == STRING || m2 == STRING))
	err("invalid mixed modes");
if (i1 > i2)
	return(m1);
else
	return(m2);
}

char modes[] "bliqfdchs";
getmode(mode)
{
register int i;

for (i=0; modes[i]; ++i)
	if (mode == modes[i])
		return(i);
err("invalid mode %c (%o)",mode,mode);
}


badlhs()
{
err("variable expected");
}

double getrhs(argp) struct arg *argp;
{
register struct arg *a;
double f;
register int i;

a = argp;
switch(argp->a_type)
	{
case CONSTANT:
	return(a->a_value);
case VARIABLE:
	i = a->a_value;
	nfetch(i,&f,typelen(a->a_mode));
	a->a_value = getv(&f,a->a_mode);
	return(a->a_value);
default:
	err("cannot de-reference");
	}
}

item(argp,side) struct arg *argp;
{
register int c;
double v;

loop:

c = *inptr++;
switch(c)
	{
case '-':
	if (side == LHS)
		badlhs();
	item(argp,RHS);
	argp->a_value = -getrhs(argp);
	argp->a_type = EXPR;
	return(OK);
case '+':
	if (side == LHS)
		badlhs();
	item(argp,RHS);
	argp->a_value = getrhs(argp);
	argp->a_type = EXPR;
	return(OK);
case ' ':
	goto loop;
case '(':
	if (side == LHS)
		badlhs();
	expr(argp,RHS);
	expect(")");
	return(OK);
case ':':
	return(getvalue(argp,cursubr));
	}
--inptr;
if (c >= '0' && c <= '9')
	{
	getnumber(argp);
	return(OK);
	}
if (c >= 'a' && c <= 'z')
	{
	symbol(argp);
	return(OK);
	}
err("invalid operand");
}

getnumber(argp) struct arg *argp;
{
register char *p;
register int n;
double atof();
#define	MAXDIGITS	32
char numbuff[MAXDIGITS];

p = notany(inptr,"0123456789");
if (p == 0)
	p = endstr(inptr);
if (*p == '.' || *p == 'd' || *p == 'e' || *p == 'l')
	{
	p = notany(p,"0123456789.ed");
	if (p == 0)
		p = endstr(inptr);
	n = p-inptr;
	if (n >= MAXDIGITS)
		err("more than %d digits",MAXDIGITS);
	move(n,inptr,numbuff);
	numbuff[n] = 0;
	inptr = p;
	if (p = any(numbuff,"d"))
		*p = 'e';
	argp->a_value = atof(numbuff);
	argp->a_mode = p ? DOUBLE : FLOAT;
	if (*inptr == 'l')
		{
		++inptr;
		argp->a_mode = LONG;
		}
	}
else
	{
	argp->a_mode = INT;
	argp->a_value = number(*inptr == '0' ? 010 : 10);
	}
argp->a_type = CONSTANT;
return(OK);
}



number(base)
{
register int c;
register int n;

n = 0;
while ((c = *inptr) >= '0' && c <= '9')
	{
	++inptr;
	c =- '0';
	if (c >= base)
		err("invalid (base %d) digit",base);
	n = n * base + c;
	}
return(n);
}

symbol(argp) struct arg *argp;
{
char sname[8];
register char *s;
register int n;
register char *save;

save = inptr;
getsym(sname);
if (*inptr == ':')
	{
	if ((s = looksubr(sname)) == 0)
		err("%s not a routine",sname);
	cursubr=s;
	++inptr;
	}
else
	inptr = save;		/* undo the get sym */
return(getvalue(argp,cursubr));
}

getvalue(argp,s) char *s; struct arg *argp;
{
/*
 * determine if the next item is a STMT # (ISN)
 * or a variable in routine "s". in either case return the filled
 * in argp structure.
 */
register int n;
register char *v;
char sname[8];

n = *inptr;
if (DIGIT(n))
	{
	n = number(10);
	n = findisn(s,n);
	argp->a_type = STMT;
	argp->a_ptr = s;
	argp->a_value = n;
	return(OK);
	}
else
	{
	getsym(sname);
	v = lookvar(s,sname);
	if (v)
		{
		argp->a_mode = v->v_mode;
		argp->a_value = itol(0,v->v_addr);
		argp->a_type = VARIABLE;
		argp->a_ptr = v;
		if (*inptr == '(')
			subscript(argp);
		return(OK);
		}
	}
err("%s not found",sname);
}

subscript(argp) struct arg *argp;
{
/*
 * routine to get a subscript for a variable. the variable
 * is already set up in "argp".
 * currently all subscripts are calculated as if they were
 * vectors, even if they are not.
 */

struct arg arg2;
register int n;
register char *v;
register int i;
int subs[7];		/* the actual subscript */

v = argp->a_ptr;	/* point to the variable entry */
if (v->v_nsubs == 0)
	err("%s not subscripted",v->v_name);
expect("(");
for (i=0; i<v->v_nsubs; )
	{
	expr(&arg2,RHS);	/* get the subscript */
	n = getrhs(&arg2);
	if (n < v->v_subs[i].lwb)
		warn("subscript less than %d",v->v_subs[i].lwb);
	if (n > v->v_subs[i].upb)
		warn("subscript greater than %d",v->v_subs[i].upb);
	subs[i] = n;
	if (++i != v->v_nsubs)
		expect(",");
	}
n = 0;
for (i=v->v_nsubs; --i >= 0; )
	{
	n =+ subs[i] - v->v_subs[i].lwb;
	n =* (i == 0) ? typelen(argp->a_mode) : v->v_subs[i].upb;
	}
argp->a_value =+ n;
expect(")");
return(OK);
}


expect(str) char *str;
{
register char *s;

for (s=str; *s; )
	if (*s++ != *inptr++)
		err("%s expected",str);
}

getop()
{
/*
 * get the operator corresponding to the next symbol.
 */
register int c, op;

for (;;)
	{
	switch((c = *inptr++))
		{
	case '+':
		return(ADD_OP);
	case '-':
		return(SUB_OP);
	case '/':
		return(DIV_OP);
	case '*':
		return(MUL_OP);
	case ' ':
		break;
	case ',':
	case ')':
	case NULL:
	case '=':
	case ';':
		--inptr;
		return(0);
	default:
		err("Invalid operator");
		}
	}
}

getsym(sname) char *sname;
{
/*
 * collect symbol "sname" consisting of alphanumerics.
 * caller has already insured that it starts with the right
 * type of letter.
 */
register char *s;
register int c;

for (s=sname; c = *inptr++; )
	{
	if (!ALPHANUM(c))
		break;
	if (s < sname+6)
		*s++ = c;
	}
*s = 0;
--inptr;
}

alphanum(ch)
{
register char c;

c = ch;
if ((c >= '0' && c <= '9') || (c >= 'a' && c <= 'z') ||
	(c >= 'Z' && c <= 'Z'))
	return(1);
return(0);
}
