#include "fdb.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "ops.h"
#include "tree.h"

decode(addr)
{
register int w;
register char *s;

w = fetch(addr);
objaddr = addr+2;
s = objlook(w);
if (s)
	printf("%.8s\n",s->s_name);
else
	printf("%o\n",w);
}

uncomp(addr)
{
register int w;
register char *s;
int op;
register int i;
char *t;

inittree();
stkptr = 0;
objaddr = addr;
w = fetch(objaddr);
switch(stmthdr(w))
	{
case ISN:
case BISN:
	objaddr =+ 2;
	break;
case LISN:
case BLISN:
	objaddr =+ 4;
	break;
default:
	err("not a statement");
	}
if (scanisn(addr))
	printf("%s:%d",subrptr->f_name,isnvalue);
s = 1;
while (!stmthdr(w=fetch(objaddr)))
	{
	w = fetch(objaddr);
	objaddr =+ 2;
	s = objlook(w);
	if (s == 0)
		{
		if (pflg)
			warn("invalid operator");
		break;
		}
	decop(s->s_name);
	}
if (stkptr == 0 && s)
	printf("\tcontinue\n");
if (stkptr == 3 && argstack[stkptr-1]->t_op == DO_OP)
	prdo();
if (stkptr > 1)
	{
	s = argstack[0];
	switch(s->t_op)
		{
	case IF_OP:
	case RIF_OP:
		s = s->t_right;
		if (s->t_op == GOTO_OP && s->t_left->t_left == objaddr)
			{
			s = argstack[0];
			s->t_op = (s->t_op == RIF_OP) ? IF_OP : RIF_OP;
			s->t_right = argstack[1];
			argstack[1] = 0;
			}
		break;
	case LEAF_OP:
		if (xflg)
			break;
		s = argstack[1];
		switch(s->t_op)
			{
		case FMTRD_OP:
		case FMTWT_OP:
		case OBJWT_OP:
		case OBJRD_OP:
		case UNFRD_OP:
		case UNFWT_OP:
		case RANWT_OP:
		case RANRD_OP:
		case FREERD_OP:
		case FREEWT_OP:
				/* re-arrange the stack properly */
			t = argstack[0];
			argstack[0] = s;	/* the I/O operator */
			s->t_right = node(0,COMMA_OP,t,NULL);
			s = s->t_right;
			t = argstack[stkptr-1];
			if (t->t_op == ENDIO_OP)
				--stkptr;
			for (i=2; i<stkptr; ++i)
				{
				s->t_right = node(0,COMMA_OP,argstack[i],NULL);
				s = s->t_right;
				}
			stkptr = 1;
			break;
			}
		}
	}
for (i=0; i<stkptr; ++i)
	{
	s = argstack[i];
	if (s)
		{
		printf("\t");
		ptree(s);
		printf("\n");
		}
	}
}

char opname[10];
decop(sname) char *sname;
{
/*
 * decop is given the name of an operator, and does the following:
 * 1.	determine from the name the mode of the result
 * 2.	determine from the name the location of the operand(s).
 * 3.	do any special fiddling required for this particular operator.
 * 4.	the result is pushed on the operand stack.
 */
register char *p;
register int op;
register char *t;

move(8,sname,opname);
op = lookop(opname);
if (op == 0)
	err("op %s not found",opname);
p = endstr(opname);
argcnt = 0;
while (--p > opname && *p != '_')
	{
	++argcnt;
	}
if (*p != '_' || argcnt > 2)
	err("bad operator");
loc1 = p[1];
loc2 = p[2];
type = *--p;
switch(type)
	{
case 'i':
case 'q':
case 'f':
case 'd':
case 'l':
case 'b':
case 's':
case 'h':
case 'c':
	break;
default:
	++p;
	type=0;
	}
*p = 0;
if (dflg)
	printf("decop %s ==> %s %c _ %c %c\n",sname,ops[op],type,loc1,loc2);
switch(op)
	{
case FMTWT_OP:
case FMTRD_OP:
	t = inline();
	t->t_left =- 8;			/* adjust for LISN, GOTO */
	t = node(0,FMT_OP,t,NULL); 
	push(node(0,op,t,NULL));
	break;
case MOV_OP:
	/*
	 * three cases:
	 * 1.	push to the stack (loc2 == 's')
	 *	leave it on the stack.
	 * 2.	pop from the stack (loc1 == 's')
	 *	generate a MOV node.
	 * 3.	otherwise it is a mov from one loc to another.
	 *	generate a MOV node.
	 */
	movop();
	if (loc2 == 's')
		{
		if (loc1 == 'a')
			{
			push(subsc(pop()));
			}
		}
	else
		{			/* move operation */
		if (loc2 == 'a' && loc1 != 's')
			{
			arg1 = pop();
			arg2 = pop();
			}
		else
			{
			arg2 = pop();
			arg1 = pop();
			}
		if (loc1 == 'a')
			arg1 = subsc(arg1);
		if (loc2 == 'a')
			arg2 = subsc(arg2);
		push(node(type,op,arg2,arg1));
		break;
		}
	break;
case CVT_OP:
	type = loc2;
	push(node(type,op,pop(),NULL));
	break;
case CALL_OP:
	arg1 = inline();
	arg2 = fetch(objaddr);
	objaddr =+ 2;
	call(arg1,arg2);
	break;
case GOTO_OP:
	push(node(NULL,op,inline(),NULL));
	if (stkptr == 1 && (fetch(objaddr)&0377) == '(')
		format();
	break;
case END_OP:
case ERR_OP:
	push(node(NULL,op,inline(),NULL));
	break;
case ENF_OP:
case BCK_OP:
	putop(op,'i',1);
	break;
case DO_OP:
	type = loc1;
	arg1 = inline();
	arg2 = inline();
	push(node(type,op,arg1,arg2));
	break;
case STOS_OP:
	putop(MOV_OP,'s',2);
	break;
case RIF_OP:
case IF_OP:
	type = loc1;
	arg2 = node(NULL,GOTO_OP,inline(),NULL);
	arg1 = pop();
	push(node(type,op,arg1,arg2));
	break;
case TR_OP:
case TRX_OP:
	putop(op,loc1,1);
	break;
case TRV_OP:
	putop(op,loc1,2);
	break;
case CAT_OP:
	putop(op,type,1);
	break;
default:
	if (loc1 == 'i')
		opand(loc1);
	putop(op,type,argcnt);
	break;
	}
if (equal(sname,"addi_is"))
         push(subsc(pop()));
}

subsc(argp) char *argp;
{
register char *s;

s = argp;
if (s->t_op == SBV_OP)
         return(s);
return(node(s->t_mode,SBV_OP,s,NULL));
}

lookop(oname) char *oname;
{
register char **o;

for (SCANOPS(o))
	{
	if (eq(oname,*o))
		return(o-ops);
	}
err("op %s not found",oname);
}

movop()
{
if (argcnt != 2)
	err("invalid move");
opand(loc1);
opand(loc2);
}

opand(locn)
{
register int argp;

argp = 0;
switch(locn)
	{
case 'a':
case 's':
	break;
case 'i':
/*
	argp = node(type,LEAF_OP,objaddr,NULL);
	objaddr =+ typelen(type);
	break;
 */
case 'm':
case 'p':
	argp = fetch(objaddr);
	objaddr =+ 2;
	break;
	}
if (argp)
	push(node(type,LEAF_OP,argp,0));
}

push(argp)
{
if (dflg)
	ttrace("push",argp);
argstack[stkptr++] = argp;
}

node(mode,op,left,right)
{
register char *t;

t = treefree;
treefree =+ NODESIZE;
if (treefree >=  treespace+MAXTREE)
	err("out of tree space");
t->t_mode = mode;
t->t_op = op;
t->t_left = left;
t->t_right = right;
if (dflg)
	ttrace("node",t);
return(t);
}

pop()
{
register char *argp;

if (--stkptr < 0)
	err("stack underflow");
argp = argstack[stkptr];
if (dflg)
	ttrace("pop",argp);
return(argp);
}

inline()
{

word = fetch(objaddr);
objaddr =+ 2;
return(node(NULL,LEAF_OP,word,NULL));
}

nfetch(ptr,valptr,n) char *ptr; int *valptr;
{
while (--n >= 0)
	{
	*valptr = fetch(ptr);
	ptr =+ 2;
	++valptr;
	}
}

typelen(mode)
{
switch(mode)
	{
case 'b':
	return(1);
case 'l':
case 'i':
	return(2);
case 'q':
case 'f':
	return(4);
case 'd':
	return(8);
case 'c':
	return(8);
case 'h':
	return(16);
	}
err("invalid mode %c",mode);
}

inittree()
{
treefree = treespace;
}

stmthdr(w)
{
/*
 * test if w is a valid statement header. if so, return its type.
 */
if (w == isn)
	return(ISN);
else if (w == bisn)
	return(BISN);
else if (w == lisn)
	return(LISN);
else if (w == blisn)
	return(BLISN);
else return(0);
}


format()
{
register int addr;
register int n;
register int fmtaddr;

fmtaddr = objaddr;
addr = fetch(objaddr-2);
n = addr-fmtaddr;
push(node(0,FORMAT_OP,fmtaddr,n));
objaddr = addr;
}

call(argp,n) char *argp;
{
register char *t;
register char *p;
register int i;
t = NULL;

for (i=stkptr-n; i<stkptr; ++i)
	{
	p = argstack[i];
	t = comma(p,t);
	}
stkptr =- n;
push(node(NULL,CALL_OP,argp,t));
}

comma(p,q) char *p, *q;
{
register char *t;

return(node(NULL,COMMA_OP,p,q));
}

strpop()
{
register char *s, *p, *t;

s = pop();	/* length */
if (s->t_op != LEAF_OP)
	return(s);
p = pop();	/* variable */
t = node('s',STR_OP,p,s);
return(t);
}

putop(op,mode,cnt)
{
/*
 * output operator "op" with mode "mode" and number of
 * operands "cnt".
 */
switch(cnt)
	{
case 0:
	push(node(mode,op,0,0));
	break;
case 1:
	if (mode == 's')
		arg1 = strpop();
	else
		arg1 = pop();
	push(node(mode,op,arg1,0));
	break;
case 2:
	if (mode == 's')
		{
		arg2 = strpop();
		arg1 = strpop();
		}
	else
		{
		arg2 = pop();
		arg1 = pop();
		}
	push(node(mode,op,arg1,arg2));
	}
}

ttrace(msg,argp) char *msg, *argp;
{
printf("%s ",msg);
ptree(argp);
printf("\n");
}

pstr(tp) char *tp;
{
register char *t;
register char *s;

t = tp;
s = t->t_left;
if (s->t_op == LEAF_OP)
	{
	s->t_right = t->t_right->t_left;
	ptree(s);
	}
}

putch(ch) char ch;
{
putchar(ch);
if (ch == '\'')
	putchar(ch);
}
