#include "fdb.h"
/*			Copyright 1979 by Bill Webb.	 		*/

#define	THREADED	0134
#define	MAXBPT	20
struct bpt
{
char *b_addr;
int b_old;
int b_bpt;
char *b_atcmds;		/* at commands */
} bpts[MAXBPT];
#define	BPTSIZE	(sizeof bpts[0])

int bptcnt;

setbpt(n,atcmds) char *atcmds;
{
register int w;
register char *p;

w = fetch(n);
if (!stmthdr(w))
	err("not a statement");
if (findbpt(n) >= 0)
	err("aleady set");
if (bptcnt >= MAXBPT)
	err("too many break points");
p = &bpts[bptcnt];
++bptcnt;
p->b_addr = n;
p->b_old = w;
p->b_atcmds = atcmds;
p->b_bpt = (w == isn) ? bisn : blisn;
if (runing)
	store(n,p->b_bpt);
}

listbpts()
{
register int i;
register char *p;
register int n;

for (i=0; i<bptcnt; ++i)
	{
	p = &bpts[i];
	n = p->b_addr;
	if (!scanisn(n))
		printf(" *%o*",n);
	else
		printf(" %s:%d",subrptr->f_name,isnvalue);
	}
printf("\n");
}

rembpt(n)
{
register char *p;
register int i;

if ((i = findbpt(n)) >= 0)
	{
	p = &bpts[i];
	if (runing)
		store(n,p->b_old);
	move(BPTSIZE*(bptcnt-i),&bpts[i+1],&bpts[i]);
	--bptcnt;
	return;
	}
err("not set");
}

putbpts()
{
register char *p;
register int i;

for (i=0; i<bptcnt; ++i)
	{
	p = &bpts[i];
	store(p->b_addr,p->b_bpt);	/* put in the break point */
	}
store(debug,BPT);
store(errstop,BPT);
isnoff = 0;
if (fetch(isn) != NOP)
	{
	if (fetch(isn+4) == THREADED && fetch(isn+6) == THREADED)
		{
		isnoff = 4;	/* after inc instr */
		store(isn+isnoff,NOP);
		store(lisn+isnoff,NOP);
		}
	else
		warn("steping not possible");
	}
}

findbpt(n)
{
register int i;

for (i=0; i<bptcnt; ++i)
	if (bpts[i].b_addr == n)
		return(i);
return(-1);
}

atcheck(n)
{
register int i;
register char **p;

if ((i = findbpt(n)) < 0)
	return(0);
if ((p = bpts[i].b_atcmds) == 0)
	return(0);
for (; p; p = *p)
	{
	printf("%s\n",p+1);
	onecmd(p+1);
	}
return(1);
}
