#

#define	NL	'\n'
#define	BLANK	' '
#define	COLON	':'

char delim NL;
char *outfile;
int outdes;
#define	ARMAGIC	0177545
int magic ARMAGIC;
int vflg;
#define	MAXNAME	10

#define	DEFINED	1
#define	UNDEFINED	0

struct file
{
char f_name[16];		/* name of the file */
char *f_next;		/* next file on chain */
char *f_entry;		/* defined routines */
char *f_ref;		/* referenced routines */
char *f_output;		/* output list */
char f_level;		/* call level */
char f_mark;		/* current mark chain */
char f_circle;		/* already on a circle */
} *files;
#define	FSIZE	(sizeof *files)

struct entry
{
char l_name[MAXNAME];
char *l_next;
char *l_file;		/* the file that defines it */
char *l_entry;		/* its brother */
} *entries;

char *outlist;
#define	LSIZE	(sizeof *entries)
#define	NSIZE	4

struct ref
/*
 * a ref connects a reference with the "entry" that it references.
 * that entry then points to a "file" if the symbol is defined.
 */
{
char  *n_entry;
char *n_ref;
};

int tflg;
lookup(name) char *name;
{
/*
 * lookup symbol in symbol list "entries".
 * add to list if not found.
 */
register char *p;

for (p=entries; p; p=p->l_next)
	if(equal(name,p->l_name))
		return(p);
p = alloc(LSIZE);
if (tflg > 1)
	tracef("alloc %o to %s\n",p,name);
clear(p,LSIZE);
copy(p->l_name,name);
p->l_next = entries;
entries = p;
return(p);
}

int maxlevel;
char buff[512];
int circle;			/* current mark circle */
main(argc,argv)
char **argv;
{
register char *p, *f, *l;
char c;

--argc;
++argv;
while (argc > 0)
	{
	--argc;
	p = *argv++;
	if (*p == '-')
		{
		while (*++p)
			{
			switch(*p)
				{
			case 't':
				++tflg;
				break;
			case 'v':
				++vflg;
				break;
				}
			}
		}
	else
		outfile = p;
	}
if (outfile == 0)
	++vflg;
while (delim && gets(buff))
	{
	if (delim != ':')
		err("input syntax error");
	f = getfile();
	delim=getch();
	while (delim == '=' || delim==' ')
		{
		while (delim == ' ')
			delim = getch();
		c = delim;
		if (!gets(buff))
			break;
		l = lookup(buff);
		if (c == '=')
			{
			if (l->l_file)
				{
				warn("%s: %s already defined by %s\n",
					f->f_name,buff,l->l_file->f_name);
				continue;
				}
			l->l_file = f;
			l->l_entry = f->f_entry;	/* link into chain */
			f->f_entry = l;
			}
		else
			{
			f->f_ref = ref(l,f->f_ref);
			}
		}
	pfile(f);
	}
dump("after input");
for (f=files; f; f=f->f_next)
	for (l=f->f_entry; l; l=l->l_entry)
		{
		l->l_file = f;
		if (tflg > 1)
			tracef("%s:%s\n",l->l_name,f->f_name);
		}
for (p=files; p; p=p->f_next)
	{
	++circle;
	mark(1,p);
	}
dump("after marking");
for (; maxlevel > 0; --maxlevel)
	{
	for (p=files; p; p=p->f_next)
		if ( p->f_level==maxlevel)
			output(p);
	}
if (outfile)
	{
	outdes = creat(outfile,0666);
	if (outdes < 0)
		err("can't creat %s",outfile);
	write(outdes,&magic,2);
	}
for (p=outlist; p; p=p->f_output)
	{
	if (vflg)
		printf("%s\n",p->f_name);
	if (outdes)
		outlib(p->f_name);
	}
}

dump(s) char *s;
{
register char *p;

tracef("\n dump: %s\n",s);
for (p=files; p; p=p->f_next)
	pfile(p);
}

gets(name) char *name;
{
register char *p;

p = name;
while (delim == BLANK || delim == NL || delim==COLON || delim == '=')
	delim = getch();
do
	*p++ = delim;
while ((delim = getch()) && delim!=':' && delim!=NL && delim!=BLANK && delim!='=');
*p = 0;
return(name[0]);
}

ref(lp,np) char *lp, *np;
{
register char *n;

n = alloc(NSIZE);
n->n_entry = lp; n->n_ref = np;
return(n);
}

pfile(fp) char *fp;
{
register char *n;

tracef("%s",fp->f_name);
tracef(" %o: ",fp->f_level);
for (n=fp->f_entry; n; n = n->l_entry)
	tracef(" = %s",n->l_name);
for (n=fp->f_ref; n; n = n->n_ref)
	tracef(" %s",n->n_entry->l_name);
tracef("\n");
}

mark(level,fp) char *fp;
{
/*
 * mark this file and all lower level files
 */
register char *p;
register int l;
register char *f;

if (fp->f_level > level)
	return;			/* already gone deeper */
fp->f_level = level;
if (maxlevel < level)
	maxlevel = level;
l = level+1;
if (tflg > 1)
	tracef("mark: %s %o\n",fp->f_name,level);
if (fp->f_mark == circle)
	{
	if (fp->f_circle == 0)
		{
		warn("circular list:");
		markcircle(fp);
		warn("\n");
		}
	return;
	}
fp->f_mark = circle;
for (p=fp->f_ref; p; p=p->n_ref)
	{
	f = p->n_entry->l_file;
	if (f)
		mark(l,f);
	}
fp->f_mark = 0;		/* no longer interested */
}

output(fp) char *fp;
{
if (fp->f_output == 0)
	{
	tracef("output "); pfile(fp);
	fp->f_output = outlist;
	outlist = fp;
	}
}

tracef(fmt,d1,d2,d3) char *fmt;
{
if (tflg)
	printf(fmt,d1,d2,d3);
}

getfile()
{
register char *f;

f = alloc(FSIZE);
clear(f,FSIZE);
copy(f->f_name,buff);
f->f_next = files;
files = f;
return(f);
}

markcircle(fp) char *fp;
{
register char *n;
register char *f;

warn(" %s",fp->f_name);
fp->f_circle++;
for (n=fp->f_ref; n; n=n->n_ref)
	{
	f = n->n_entry->l_file;
	if (f && f->f_circle == 0 && f->f_mark == circle)
		markcircle(f);
	}
}

warn(fmt,d1,d2,d3) char *fmt;
{
register int save;
extern fout;

flush();
save = fout;
fout = 2;
printf(fmt,d1,d2,d3);
flush();
fout = save;
}

outlib(name) char *name;
{
struct stat
{
char s_minor;
char s_major;
char s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
long s_modtime;
} stat;
struct ar
{
char a_name[14];
long a_time;
char a_uid;
char a_gid;
int a_mode;
long a_size;
} arhdr;
register int l;
register int in;
long itol();

in = open(name,0);
if (in<0)
	err("can't open %s",name);
fstat(in,&stat);
move(14,name,arhdr.a_name);
arhdr.a_uid = stat.s_uid;
arhdr.a_gid = stat.s_uid;
arhdr.a_size = itol(stat.s_size0&0377,stat.s_size1);
arhdr.a_time = stat.s_modtime;
arhdr.a_mode = stat.s_flags;
if (write(outdes,&arhdr,sizeof arhdr) < 0)
	err("write error");
while ((l=read(in,buff,sizeof buff)) > 0)
	{
	if (l&1)
		{
		buff[l] = 0;
		++l;
		}
	if (write(outdes,buff,l) < 0)
		err("write error");
	}
close(in);
}

int lastch;
getch()
{
register int c;

if (c = lastch)
	{
	lastch = 0;
	return(c);
	}
return(getchar());
}

ungetch(c)
{
lastch = c;
}
