#include <stdio.h>

#define NL 012
#define FF 014
#define	VT 013
#define CR 015
int tty;		/* 1 if terminal is a tty */
int dropnl = 1;		/* nl should be dropped */
int ff = FF;
int donefile;
int lastc = NL;

main(argc,argv) char **argv;
{
	register int i;
	register char *argp;
	int info[3];

	tty = gtty(1,info) >= 0;
	setout();
	for (i=1; i<argc; ++i)
		{
		argp = argv[i];
		if (*argp == '-')
			{
			++argp;
			switch(*argp++)
				{
			case 'v':
				ff = VT;
				break;
			case 'f':
				tty = 0;
				break;
			case 't':
				tty = 1;
				break;
				}
			continue;
			}
		if (freopen(argp,"r",stdin) == NULL)
			{
			fputs("asa: can't open ",stderr);
			fputs(argp,stderr);
			fputs("\n",stderr);
			exit(1);
			}
		dofile();
		}
	if (!donefile)
		dofile();	/* on standard input */

}

dofile()
{
	register int c;

	++donefile;
	if (tty)
		{ ttyfile(); return; }
	for(c=NL;c!=EOF;c=getchar()){
		if(c==NL)
			while(c==NL) switch(c=getchar()){
					case	EOF:
						putnl();
						flush();
						return;
					case	'+':
						if (lastc != '\n')
							putchar(CR);
						lastc = NL;
						break;
					case	'2':
						if (lastc != '\n')
							putchar(CR);
						dropnl = 0;
						lastc = NL;
						putchar(VT);
						break;
					case	'1':
						if (lastc != '\n')
							putchar(CR);
						dropnl = 0;
						lastc = NL;
						putchar(ff);
						break;
					case	'-':
						putnl();
					case	'0':
						putnl();
					case	' ':
					case	'9':	/* MTS ignore page skip character */
					case	NL:
						putnl();
						break;
					case	'$':	/* no spacing */
					case	'&':	/* same for MTS */
						putnl();
						dropnl++;
						flush();	/* assume tty */
						break;
					default:
						putnl();
						lastc = c;
						putchar(c);
				}
		else { lastc = c; putchar(c); }
	}
	flush();
}

putnl()
{
if (!dropnl)
	putchar(NL);
lastc = NL;
dropnl = 0;
if (tty)
	flush();
}

ttyfile()
{
	register int c;

	++donefile;
	for (;;)
		{
		c = getchar();
		dropnl = 0;
		while (c == NL)
			{ putnl(); c = getchar(); }
		switch(c)
			{
		case	EOF:
			flush();
			return;
		case	'+':
			break;
		case	'2':
			putchar(CR);
			putchar(VT);
			break;
		case	'1':
			putchar(CR);
			putchar(ff);
			break;
		case	'-':
			putnl();
		case	'0':
			putnl();
		case	' ':
		case	'9':	/* MTS ignore page skip character */
		case	NL:
			break;
		case	'$':	/* no spacing */
		case	'&':	/* same for MTS */
			dropnl++;
			break;
		default:
			putchar(c);
			}
		while ((c = getchar()) != NL && c != EOF)
			putchar(c);	/* ignore rest of line */
		if (c == EOF)
			{
			putnl();
			return;
			}
		if (dropnl)
			putchar(' ');	/* install spacer */
		putnl();
	}
	flush();
}
