/*			Copyright 1979 by Bill Webb.	 		*/
/*			Copyright 1977 by Bill Webb.	 		*/
#define	SCANSYM(s)	s=symbeg+2; s<symlast; s=+(s->s_len&0377)	/* scan symtab */
#define	s_mode	s_type
/*
 * definitions of symbol table classes.
 */
#define	SYMBOL	0	/* symbolic entry */
#define	CONST	1	/* constant */
#define	EQUIV	2	/* equivalence */
#define	COMMON	3	/* common block */
#define	IF	4	/* if block */
#define	DO	5	/* do loop info */
#define	SUBSCRIPT 6	/* subscripts */
/*
 * definitions of "loc" ==> location of variable/constant
 */
#define	NOLOC	0	/* location not known */
#define	CONST	1
#define	PARAM	2
#define	COMMON	3
#define	EXTERN	4
#define	LOCAL	5
#define	TEXT	6	/* code section */
/*
 * flag bits
 */
#define	F_TYPED		01	/* explicitly typed */
#define	F_CHANGED	02	/* modified */
#define	F_FN		04	/* function */
#define	F_USED		010	/* constant used */
#define	F_ALLOC		020	/* allocated an address */
#define	F_INTRINSIC	040	/* instrinsic function */
#define	F_GENERIC	0100	/* generic function */
#define	F_ENTRY		0200	/* entry point symbol */
#define	F_DEFINED	0400	/* if label is defined */
#define	F_DATA		01000	/* if data assigned */
#define	F_ARG		02000	/* if function/subr argument */
#define	F_DATAZ		04000	/* if data assigned zero */

#define	c_size	s_size	/* size of common block */
#define	MAXSUBS	7		/* maximum number of subscripts */
#define	LABELSIZE	(sizeof *sym_label)
#define	s_slen	s_size		/* string length */
#define	MAXSTRING	256
#define	NOSYMBOL	0		/* no symbol return */
#define	SYMSIZE	sizeof *symptr
#define	HDRSIZE	sizeof symbol.s_head
#define	sym_type	symbol.s_type
#define	sym_loc		symbol.s_loc
#define sym_flags	symbol.s_flags
#define	sym_addr	symbol.s_addr
#define	sym_len		symbol.s_len
#define	sym_nsubs	symbol.s_nsubs
#define	s_subs		s_subptr->s_subsc
#define	sym_subs	symbol.s_subs
#define	sym_float	symbol.s_float
#define	sym_int		symbol.s_int
#define	sym_common	symbol.s_common
#define	sym_equiv	symbol.s_equiv
#define	sym_class	symbol.s_class
#define	sym_next	symbol.s_next
#define	sym_slen	symbol.s_slen
#define	sym_string	symbol.s_string
#define	sym_size	symbol.s_size
#define	sym		symbol.s_name	/* current symbol name */
#define	constant(p)	((p)->s_class == CONST)
#define	variable(p)	((p)->s_class == SYMBOL)
#define	YES	1
#define	NO	0
#define	isarith	arithmode
#define	MAXHASH	64
#define	LEFT	0		/* left side of assignment */
#define	MIDDLE	1		/* function/subroutine argument */
#define	RIGHT	2		/* pure expression (for value) */
#define	IOARG	3		/* i/o argument */
#define	CALLARG	4		/* call argument */
#define	INSYM(x)	(x >= symbeg)		/* if in symtab */
#define	IFSIZE	(sizeof *if_range)
#define	CONSTEXPR(t) (INSYM(t) && (t)->s_class==CONST)

struct minhdr 		/* minimum symbol table header */
{
char s_len;		/* length of this entry */
char s_type;		/* type/mode of entry */
char s_class;		/* class of symtab entry */
char s_loc;		/* location of entry */
};

struct hdr		/* basic symbol table header */
{
struct minhdr s_minhdr;
int s_flags;			/* attribute flags */
char *s_addr;			/* address */
char *s_next;		/* next entry on chain */
int s_size;		/* allocation size of entry */
};

struct symhdr
{
struct hdr s_head;		/* header for all entries */
char s_name[NAMESIZE];		/* name of the symbol */
};

struct common
{
struct symhdr s_hdr;
int c_chain;		/* chain of common locations */
int c_last;		/* last item on chain */
int c_addr;		/* current address in common */
};

struct subs
{
char *lwb;	/* lower bound */
char *upb;	/* upper bound */
};

struct subsc
{
struct minhdr s_min;		/* minimal header */
int s_numsubs;			/* number of subscripts */
struct subs s_subsc[MAXSUBS];	/* actual subscripts */
};

struct symbol
{
struct symhdr s_hdr;
char *s_common;		/* common chain locaton */
char *s_equiv;		/* equivalence chain location */
int s_nsubs;		/* number of subscripts */
char *s_subptr;		/* pointer to subscripts */
} *symptr;			/* pointer to symbol table */

struct label
{
struct symhdr s_hdr;
} *sym_label;

struct string
{
struct hdr s_head;
char s_string[];
};

struct
{
struct string s_sym;
char s_junk[MAXSTRING];
} symbol;

struct
{
struct hdr s_head;
int s_int;			/* integer value */
};

struct qint
{
struct hdr s_head;
int s_qint[2];			/* fake long */
};

struct
{
struct hdr s_head;
double s_float;
};

struct complex
{
struct hdr s_head;		/* symbol table header */
char *s_real;			/* pointer to real constant */
char *s_imaginary;		/* pointer to imaginary part */
};



int symcount;		/* number of symtab entries */
int cm;			/* current common block */
char *locnames[];
char *cur_sym;			/* current symbol entry offset */
char ordered[];			/* if mode has ordering properties */
char align[];			/* alignment information */
char arithmode[];
char prio[];			/* priorities of operators */
char isint[];		/* YES if integer mode */
char isreal[];		/* YES if real mode */
char isbool[];		/* YES if logical */
char iscmplx[];		/* YES if complex */

struct do_
{
struct hdr s_head;	/* symtab header */
int d_nest;		/* next nested do struct */
char *d_var;		/* do loop variable */
char *d_count;		/* do count variable */
char *d_incr;		/* do increment */
char *d_addr1;		/* address to jump back to */
char *d_addr2;		/* address to junk ahead to */
char *d_label;		/* do loop label (NOLABEL==implied do) */
int d_if;		/* current if level */
};

int hashtab[MAXHASH];		/* hash table for names */
char *intchain, *fltchain, *strchain;	/* *constant *chains **/
char *cmplxchain;

struct equiv
{
struct hdr s_head;
int e_start;			/* first on chain */
int e_last;			/* last on chain */
int e_len;			/* size of all entries */
int e_common;			/* flag if in common */
} *ep;



struct ifblock
{
struct hdr s_head;
int i_else;	/* else address */
int i_end;	/* end address */
int i_save;	/* conditional flag saved */
char i_cond;	/* constant conditional */
char i_value;	/* for constant its (current) value */
} *if_range;	/* pointer for current if block */

char modematrix[MAXTYPE][MAXTYPE];		/* coersion matrix */
char *one_const;		/* constant 1 symbol table entry */
double qload();			/* cvt long to double */
