#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
#include "sym.h"
#include "char.h"
/*			Copyright 1977 by Bill Webb.	 		*/

#define	MEM_28K	0157776		/* last word in 28K */
#define	MAXMEM	0176000		/* leave 01777 for stack */
char *classnames[]
{"symbolic", "constant", "equivalence", "common", "if", "do", "subsc" };

int flags;			/* flags that have been printed */
char *flagnames[16]
/*
 *	#	defined, explicitly typed
 *	=	modified
 *	@	used in code
 *	*	allocated storage
 *	d	appears in data stmt
 *	a	argument to subr/fn
 */
{ "#", "=", "function", "@", "*", "intrinsic", "generic", "entry", ":", "d", "a", "z" };

char *longnames[]
{
"typed",	/* #		*/
"modified",	/* =		*/
0,		/* function	*/
"referenced",	/* @		*/
"allocated",	/* *		*/
0,		/* intrinsic	*/
0,		/* generic	*/
0,		/* entry	*/
"defined",	/* :		*/
"data",		/* d		*/
"as argument",	/* a		*/
"zero data",	/* z		*/
0 };
#define	SYM_INCR	4*1024

lookup(flag)
{
/*
 * lookup symbol in "sym" in symbol table.
 * if "flag" return results into sym.
 */
register char *s;
register int n;

for (s=hashtab[hash(sym,MAXHASH-1)]; s; s = s->s_next)
	{
	if (symeq(sym,s->s_name) && s->s_class != COMMON)
		{
		if(s->s_type == PARAMETER)
			s = s->s_addr ;		/* use it instead */
		if(flag)
			move((s->s_len&0377),s,&symbol);		/* copy it */
		return(cur_sym = s);
		}
	}
return(NOSYMBOL);
}

clookup()
{
/*
 * lookup and return the common block whose name is "sym".
 */
register char *s;
for (SCANSYM(s))
	{
	if (symeq(sym,s->s_name) && s->s_class == COMMON)
		{
		move((s->s_len&0377),s,&symbol);		/* copy it */
		return(cur_sym = s);
		}
	}
return(NOSYMBOL);
}

enter(t) char *t;
{
register char *s;
register char *q;
register int len;
int *p;

len = (t->s_len&0377);
do
	{
	s = symlast;
	q = s + len;
	}
while (q >= symend && symexpand());
symlast = q;
cur_sym = s;
if (t->s_class == SYMBOL)
	{			/* must put into hash table */
	p = hashtab + hash(t->s_name,MAXHASH-1);
	t->s_next = *p;		/* previous entry */
	*p = cur_sym;		/* new entry */
	}
move(len,t,s);
++symcount;		/* count symtab entries */
#ifdef	debug
if (qflg > 1)
	{
	printf("enter at %o %d %d %d	",s,t->s_len,t->s_class,t->s_type);
	dumpsym(cur_sym);
	}
#endif
return(cur_sym);
}

getsym()
{
/*
 * collect a symbol (variable, common etc.)
 */
if(!collect(ALPHA,DIGIT))
	ERR("not a symbol",E_SYM);
}

collect(t1,t2)
{
/*
 * collect a symbol starting with type "t1" and consisting of
 * types t1 and t2.
 */
register char *s;
register int c;
register toolong;
toolong = 0;
s = sym;
clear(&symbol,SYMSIZE);			/* clear symbol */
sym_type = NOTYPE;		/* no type known yet */
sym_len = SYMSIZE;
c = *inptr++;
if (chartype(c) != t1)
	return(FAIL);
do
	{
	if (s <= sym+NAMESIZE-1)
		*s++ = c;
	else
		++toolong;
	c = *inptr++;
	}
while (chartype(c) == t1 || chartype(c) == t2 || c == ' ');
--inptr;
if (toolong)
	WARNING("symbol too long",E_SYMLEN);
return(OK);
}

getlabel()
{
if (!collect(DIGIT,DIGIT))
	ERR("not label",E_NOTLAB);
sym_len = LABELSIZE;
}

symeq(str1,str2) char *str1, *str2;
{
register int i;
register char *s1, *s2;

s1 = str1; s2 = str2;
for (i=0; i<NAMESIZE; ++i)
	if (*s1++ != *s2++)
		return(FAIL);
return(OK);
}

dumptab()
{
register char *s;
register int i, n;
int pcnt;

n = 0;				/* equivalence class # */
printf("\naddr	name	type	location/flags\n");
pcnt = 0;
flags = 0;
for (i=0; i<4; ++i)
	{
	if (pcnt == 0)
		printf("\n");
	++pcnt;
	for (SCANSYM(s))
		{
		switch(i)
			{
		case 0:		/* dump labels */
			if (s->s_type == LABEL)
				{
				dumpsym(s);
				pcnt = 0;
				}
			break;
		case 1:		/* variables */
			if (variable(s) && !s->s_common && s->s_type != LABEL &&
					!s->s_equiv)
				if(s->s_name[0]!='.' || mflg>1)
					{
					dumpsym(s);
					pcnt = 0;
					}
			break;
		case 2:		/* equivalenced variables */
			if(s->s_class==EQUIV && s->e_start)
				{
				prequiv(s,++n);	/* print equivalence class */
				pcnt = 0;
				}
			break;
		case 3:
			if(constant(s) && (s->s_flags&F_ALLOC || mflg > 1))
				{
				dumpconst(s);
				pcnt = 0;
				}
			break;
			}
		}
	}
cmap();
pnames();
}

prsym(t)
{
register char *s;

s = t;
if (s == 0)
	{
	putchar('*');
	return;
	}
switch(s->s_class)
	{
default:
	printf("{%s}",classnames[s->s_class]);
	break;
case SYMBOL:
	if(s->s_type == LABEL)
		printf("#");
	printf("%.6s",s->s_name);
	break;
case CONST:
	prconst(s);
	}
}

prconst(t) char *t;
{
register char *s;
register int i;
register int c;

s = t;
switch(s->s_type)
	{
case INT2:
	printf("%d",s->s_int);
	break;
case INT4:
	printf("%.0f",qload(s->s_qint));
	break;
case REAL8:
case REAL4:
	printf("%e",s->s_float);
	break;
case STRING:		/* string constant */
	printf("%dh",s->s_slen);
	for (i=0; i<s->s_slen;++i)
		{
		c = s->s_string[i] & 0377;
		if (c < 040)
			printf("\\%o",c);
		else
			putchar(c);
		}
	break;
case LOG1:
case LOG2:
	printf(s->s_int ? ".true." : ".false.");
	break;
case CMPLX8:
case CMPLX16:
	printf("(");
	prconst(s->s_real);
	printf(",");
	prconst(s->s_imaginary);
	printf(")");
	break;
default:
	printf("unknown type");
	}
}

dumpsym(p) char *p;
{
register char *s;
register int i, n;
char *ub;

s = p;
if (s->s_type == PARAMETER)
	{
	printf("%.6s	parameter	",s->s_name);
	dumpconst(s->s_addr);
	return;
	}
praddr(s);
prsym(s);
printf("	%s",typenames[s->s_type]);
if (s->s_type == STRING)
	printf("*%d ",s->s_size);
else
	printf(" ");
if (variable(s) && s->s_type != LABEL && (n = s->s_nsubs))
	{
	printf("(");
	for (i=0; i<n; )
		{
		ub = s->s_subs[i].lwb;
		if (ub)
			{
			prsym(ub);
			putchar(':');
			}
		prsym(s->s_subs[i].upb);
		if (++i != n)
			printf(",");
		}
	printf(")");
	}
printf(" %s",locnames[s->s_loc]);
pflags(s->s_flags);
printf("\n");
}

cmap()
{
/*
 * print out map of common blocks.
 */
register char *s;
register char *c;
register char *lastcm;

for (SCANSYM(s))
	{
	if (s->s_class != COMMON)
		continue;
	printf("\ncommon /%.6s/ %d bytes\n",s->s_name,s->c_size);
	for (c=s->c_chain; COMMON!=c->s_class; c=c->s_common)
		{
		lastcm = c;
		dumpsym(c);
		}
#ifdef debug
	if (lastcm != c->c_last)
		{
		printf("c_last incorrect ");
		prsym(c->c_last);
		}
#endif
	}
}

dumpconst(p) char *p;
{
register char *s;

s = p;
praddr(s);
prconst(s);
printf("\t%s",typenames[s->s_type]);
printf("\t%s",locnames[s->s_loc]);
pflags(s->s_flags);
printf("\n");
}

pflags(n)
{
register int i;
register int j;

j = 0;
flags =| n;		/* remember flag names printed */
for (i=1; i; i=<<1)
	{
	if (n & i)
		printf(" %s",flagnames[j]);
	++j;
	}
}

symexpand()
{
/*
 * expand symbol table space.
 * rules are:
 * (1) until we hit 28K words expand by SYM_INCR
 * (2) when we cross 28K set to 28K (normal maximum)
 * (3) then set break address to 28K and get all of the stack
	segment giving us 32K less the stack.
 * (4) give a fatal error.
 */
register char *n;

#ifdef	debug
if (aflg)
	printf("expanding symtab\n");
#endif
if (symend == MAXMEM)
	nomem();
n = symend + SYM_INCR;		/* new top address */
if (symend < MEM_28K)
	return(setend(n > MEM_28K ? MEM_28K : n));
if (brk(MEM_28K) == -1 || bigstk() == -1)
	nomem();
symend = MAXMEM;
return(OK);
}

setend(n) char *n;
{
if (brk(symend = n) == -1)
	nomem();
return(OK);
}

nomem()
{
ERROR1("out of memory (%l bytes)",E_MEM,symend);
}

hash(name,size) char *name;
{
register int n;
register int *p;

p = name;
n = (*p++ + 1) * (*p++ + 1) * (*p++ + 1);
n =% size;
if (n < 0)
	n = -n;
return(n);
}

praddr(sp) char *sp;
{
if(qflg || (sp->s_flags&F_ALLOC))
	printf("%l",sp->s_addr);
printf("\t");
}

prequiv(p,n) char *p;
{
/*
 * print out the equivalence class.
 */
register char *s;

if (p->e_common && qflg <= 1)
	return;		/* will get printed later */
printf("\nequivalence class %d\n",n);

for (s=p->e_start; s && s->s_class!=EQUIV; s=s->s_equiv)
	dumpsym(s);
printf("\n");
}

undefs()
{
register char *s;
register int n;

if (wflg)
	return;
n = 0;
for (SCANSYM(s))
	{
	if (variable(s) && (!(s->s_common || s->s_equiv || s->s_loc != LOCAL)) &&
		(s->s_flags & (F_ARG|F_CHANGED|F_FN|F_DATA|F_DATAZ)) == 0)
		{
		if (n++ == 0)
			{
			n = 3;
			WARNING("Not assigned values:",E_UNDEF);
			}
		putchar('\t');
		prsym(s);
		if ((n&07) == 0)
			putchar('\n');
		}
	}
if (n)
	printf("\n");
}

pnames()
{
register int i;
register int j;
register char *s;

j = 0;
for (i=1; i; i=<<1)
	{
	if ((flags & i) && (s = longnames[j]))
		printf("%s-%s  ",flagnames[j],s);
	++j;
	}
printf("\n");
}
